/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.system.cvss.Annotator;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.CvsCommandsMenuItem;
import org.netbeans.modules.versioning.system.cvss.util.FlatFolder;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.actions.SystemAction;

public class FileStatusProvider
extends AnnotationProvider
implements VersioningListener,
PropertyChangeListener {
    private static final int STATUS_BADGEABLE = 12;
    private static FileStatusProvider instance;
    private boolean shutdown;

    public FileStatusProvider() {
        instance = this;
    }

    public static FileStatusProvider getInstance() {
        return instance;
    }

    public String annotateNameHtml(String string, Set set) {
        return CvsVersioningSystem.getInstance().getAnnotator().annotateNameHtml(string, set, 6622);
    }

    public String annotateName(String string, Set set) {
        return CvsVersioningSystem.getInstance().getAnnotator().annotateName(string, set);
    }

    public Image annotateIcon(Image image, int n, Set set) {
        Object object;
        if (this.shutdown) {
            return image;
        }
        HashSet<File> hashSet = new HashSet<File>();
        boolean bl = false;
        if (set instanceof NonRecursiveFolder) {
            object = ((NonRecursiveFolder)set).getFolder();
            hashSet.add(new FlatFolder(FileUtil.toFile((FileObject)object).getAbsolutePath()));
            bl = true;
        } else {
            object = set.iterator();
            while (object.hasNext()) {
                FileObject fileObject = (FileObject)object.next();
                if (fileObject.isFolder()) {
                    bl = true;
                }
                hashSet.add(FileUtil.toFile((FileObject)fileObject));
            }
        }
        if (!bl && set.size() > 1) {
            bl = Annotator.looksLikeLogicalFolder(set);
        }
        if (!bl) {
            return image;
        }
        object = CvsVersioningSystem.getInstance().getStatusCache();
        boolean bl2 = false;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if ((((FileStatusCache)object).getStatus(file).getStatus() & 0xC) == 0) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return image;
        }
        return CvsVersioningSystem.getInstance().getAnnotator().annotateFolderIcon(hashSet, image);
    }

    public Action[] actions(Set set) {
        return new Action[]{SystemAction.get((Class)CvsCommandsMenuItem.class)};
    }

    public InterceptionListener getInterceptionListener() {
        return CvsVersioningSystem.getInstance().getFileSystemHandler();
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)versioningEvent.getParams()[0];
            this.fireFileStatusEvent(file);
        }
    }

    public void fireFileStatusEvent(File file) {
        Set<Object> set;
        FileSystem fileSystem;
        Object object;
        File file2;
        HashMap<FileSystem, HashSet<Object>> hashMap = new HashMap<FileSystem, HashSet<Object>>();
        for (file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            try {
                object = FileUtil.toFileObject((File)file2);
                if (object == null) continue;
                fileSystem = object.getFileSystem();
                set = (HashSet<Object>)hashMap.get(fileSystem);
                if (set == null) {
                    set = new HashSet<Object>();
                    hashMap.put(fileSystem, (HashSet<Object>)set);
                }
                set.add(object);
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        file2 = FileUtil.toFileObject((File)file);
        if (file2 != null) {
            try {
                this.fireFileStatusChanged(new FileStatusEvent(file2.getFileSystem(), (FileObject)file2, false, true));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            fileSystem = (FileSystem)object.next();
            set = (Set)hashMap.get(fileSystem);
            this.fireFileStatusChanged(new FileStatusEvent(fileSystem, set, true, false));
        }
    }

    void shutdown() {
        this.shutdown = true;
        CvsModuleConfig.getDefault().removePropertyChangeListener(this);
        this.refreshModifiedFiles();
    }

    void init() {
        CvsModuleConfig.getDefault().addPropertyChangeListener(this);
    }

    private void refreshModifiedFiles() {
        Map map = CvsVersioningSystem.getInstance().getStatusCache().getAllModifiedFiles();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.fireFileStatusEvent(file);
        }
    }

    public void refreshAllAnnotations(boolean bl, boolean bl2) {
        File file;
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>(1);
        File[] fileArray = File.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            file = fileArray[i];
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            try {
                hashSet.add(fileObject.getFileSystem());
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            file = (FileSystem)iterator.next();
            this.fireFileStatusChanged(new FileStatusEvent((FileSystem)file, bl, bl2));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("textAnnotations".equals(propertyChangeEvent.getPropertyName())) {
            this.refreshAllAnnotations(false, true);
        }
    }
}

