/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.system.cvss.CvsMetadata;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.settings.MetadataAttic;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

class FilesystemHandler
implements FileChangeListener,
InterceptionListener {
    private static final RequestProcessor eventProcessor = new RequestProcessor("CVS-Event", 1);
    private final FileStatusCache cache;
    private final Map savedMetadata = new HashMap();
    private static Thread ignoredThread;

    public FilesystemHandler(CvsVersioningSystem cvsVersioningSystem) {
        this.cache = cvsVersioningSystem.getStatusCache();
    }

    static void ignoreEvents(boolean bl) {
        ignoredThread = bl ? Thread.currentThread() : null;
    }

    static boolean ignoringEvents() {
        return ignoredThread == Thread.currentThread();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        if (Thread.currentThread() == ignoredThread) {
            return;
        }
        eventProcessor.post((Runnable)new FileCreatedTask(FileUtil.toFile((FileObject)fileEvent.getFile())));
    }

    public void fileDataCreated(FileEvent fileEvent) {
        if (Thread.currentThread() == ignoredThread) {
            return;
        }
        eventProcessor.post((Runnable)new FileCreatedTask(FileUtil.toFile((FileObject)fileEvent.getFile())));
    }

    public void fileChanged(FileEvent fileEvent) {
        if (Thread.currentThread() == ignoredThread) {
            return;
        }
        eventProcessor.post((Runnable)new FileChangedTask(FileUtil.toFile((FileObject)fileEvent.getFile())));
    }

    public void fileDeleted(FileEvent fileEvent) {
        if (Thread.currentThread() == ignoredThread) {
            return;
        }
        eventProcessor.post((Runnable)new FileDeletedTask(FileUtil.toFile((FileObject)fileEvent.getFile())));
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        if (Thread.currentThread() == ignoredThread) {
            return;
        }
        eventProcessor.post((Runnable)new FileRenamedTask(fileRenameEvent));
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void createSuccess(FileObject fileObject) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        if (fileObject.isFolder() && fileObject.getNameExt().equals("CVS")) {
            File file = new File(FileUtil.toFile((FileObject)fileObject), "invalid-metadata");
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(65536, "Unable to create marker: " + file.getAbsolutePath());
            }
        }
    }

    public void beforeCreate(FileObject fileObject, String string, boolean bl) {
    }

    public void createFailure(FileObject fileObject, String string, boolean bl) {
    }

    public void beforeDelete(FileObject fileObject) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        if (fileObject.isFolder()) {
            this.saveRecursively(FileUtil.toFile((FileObject)fileObject));
        } else {
            FileObject fileObject2 = fileObject.getParent();
            if ("CVS".equals(fileObject2.getName())) {
                if ((fileObject2 = fileObject2.getParent()) == null) {
                    return;
                }
                File file = FileUtil.toFile((FileObject)fileObject2);
                this.saveMetadata(file);
            }
        }
    }

    private void saveRecursively(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.isDirectory()) continue;
            if ("CVS".equals(file2.getName())) {
                this.saveMetadata(file);
                continue;
            }
            this.saveRecursively(file2);
        }
    }

    public void deleteSuccess(FileObject fileObject) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (fileObject.isFolder()) {
            Iterator iterator = this.savedMetadata.keySet().iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (!Utils.isParentOrEqual(file, file2)) continue;
                CvsMetadata cvsMetadata = (CvsMetadata)this.savedMetadata.get(file2);
                MetadataAttic.setMetadata(file2, cvsMetadata);
                iterator.remove();
            }
            this.refreshRecursively(file);
        }
        this.fileDeletedImpl(file);
    }

    private void refreshRecursively(File file) {
        CvsMetadata cvsMetadata = MetadataAttic.getMetadata(file);
        if (cvsMetadata == null) {
            return;
        }
        Entry[] entryArray = cvsMetadata.getEntryObjects();
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            if (entry.getName() == null) continue;
            if (entry.isDirectory()) {
                this.refreshRecursively(new File(file, entry.getName()));
                continue;
            }
            this.cache.refreshCached(new File(file, entry.getName()), 0);
        }
    }

    public void deleteFailure(FileObject fileObject) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        if (fileObject.isFolder()) {
            File file = FileUtil.toFile((FileObject)fileObject);
            Iterator iterator = this.savedMetadata.keySet().iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (!Utils.isParentOrEqual(file, file2)) continue;
                if (!file2.exists()) {
                    CvsMetadata cvsMetadata = (CvsMetadata)this.savedMetadata.get(file2);
                    MetadataAttic.setMetadata(file2, cvsMetadata);
                }
                iterator.remove();
            }
            this.refreshRecursively(file);
        }
    }

    void init() {
        Set set = this.getRootFilesystems();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileSystem fileSystem = (FileSystem)iterator.next();
            fileSystem.addFileChangeListener((FileChangeListener)this);
        }
    }

    void shutdown() {
        Set set = this.getRootFilesystems();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileSystem fileSystem = (FileSystem)iterator.next();
            fileSystem.removeFileChangeListener((FileChangeListener)this);
        }
    }

    private Set getRootFilesystems() {
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>();
        File[] fileArray = File.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            if (fileObject == null) continue;
            try {
                hashSet.add(fileObject.getFileSystem());
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    private void fileCreatedImpl(File file) {
        File file2;
        CvsMetadata cvsMetadata;
        if (file == null) {
            return;
        }
        int n = this.cache.refresh(file, 0).getStatus();
        if (file.isDirectory() && (cvsMetadata = MetadataAttic.getMetadata(file)) != null) {
            try {
                file2 = new File(file, "CVS");
                if (!file2.exists()) {
                    cvsMetadata.save(file2);
                }
                MetadataAttic.setMetadata(file, null);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        if ((n & 0xFFFFFFFE) == 0) {
            return;
        }
        if (n == 256) {
            cvsMetadata = new StandardAdminHandler();
            file2 = null;
            try {
                file2 = cvsMetadata.getEntry(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file2 != null && !file2.isDirectory() && file2.isUserFileToBeRemoved()) {
                this.cvsUndoRemoveLocally((AdminHandler)cvsMetadata, file, (Entry)file2);
            }
            this.cache.refresh(file, 0);
        }
        if (file.getName().equals(".cvsignore")) {
            this.cache.directoryContentChanged(file.getParentFile());
        }
        if (file.isDirectory()) {
            this.cache.directoryContentChanged(file);
        }
    }

    private void fileDeletedImpl(File file) {
        if (file == null) {
            return;
        }
        StandardAdminHandler standardAdminHandler = new StandardAdminHandler();
        Entry entry = null;
        try {
            entry = standardAdminHandler.getEntry(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (entry != null && !entry.isDirectory() && !entry.isUserFileToBeRemoved()) {
            this.cvsRemoveLocally((AdminHandler)standardAdminHandler, file, entry);
        }
        this.cache.refresh(file, 0);
        if (file.getName().equals(".cvsignore")) {
            this.cache.directoryContentChanged(file.getParentFile());
        }
    }

    private void cvsRemoveLocally(AdminHandler adminHandler, File file, Entry entry) {
        try {
            if (entry.isNewUserFile()) {
                adminHandler.removeEntry(file);
            } else {
                entry.setRevision("-" + entry.getRevision());
                entry.setConflict("dummy timestamp");
                adminHandler.setEntry(file, entry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void cvsUndoRemoveLocally(AdminHandler adminHandler, File file, Entry entry) {
        entry.setRevision(entry.getRevision().substring(1));
        entry.setConflict(Entry.getLastModifiedDateFormatter().format(new Date(System.currentTimeMillis() - 1000L)));
        try {
            adminHandler.setEntry(file, entry);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveMetadata(File file) {
        file = FileUtil.normalizeFile((File)file);
        MetadataAttic.setMetadata(file, null);
        if (this.savedMetadata.get(file) != null) {
            return;
        }
        try {
            CvsMetadata cvsMetadata = CvsMetadata.readAndRemove(file);
            this.savedMetadata.put(file, cvsMetadata);
        }
        catch (IOException iOException) {
            return;
        }
    }

    private final class FileRenamedTask
    implements Runnable {
        private final FileRenameEvent event;

        public FileRenamedTask(FileRenameEvent fileRenameEvent) {
            this.event = fileRenameEvent;
        }

        public void run() {
            FileObject fileObject = this.event.getFile();
            String string = this.event.getName();
            String string2 = this.event.getExt();
            if (string2.length() > 0) {
                string2 = "." + string2;
            }
            File file = FileUtil.toFile((FileObject)fileObject.getParent());
            File file2 = new File(file, string + string2);
            FilesystemHandler.this.fileDeletedImpl(file2);
            FilesystemHandler.this.fileCreatedImpl(FileUtil.toFile((FileObject)fileObject));
        }
    }

    private final class FileDeletedTask
    implements Runnable {
        private final File file;

        FileDeletedTask(File file) {
            this.file = file;
        }

        public void run() {
            FilesystemHandler.this.fileDeletedImpl(this.file);
        }
    }

    private final class FileChangedTask
    implements Runnable {
        private final File file;

        FileChangedTask(File file) {
            this.file = file;
        }

        public void run() {
            FilesystemHandler.this.cache.refreshCached(this.file, 0);
            if (this.file.getName().equals(".cvsignore")) {
                FilesystemHandler.this.cache.directoryContentChanged(this.file.getParentFile());
            }
        }
    }

    private final class FileCreatedTask
    implements Runnable {
        private final File file;

        FileCreatedTask(File file) {
            this.file = file;
        }

        public void run() {
            FilesystemHandler.this.fileCreatedImpl(this.file);
        }
    }
}

