/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.net.SocketFactory;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;
import org.openide.util.NbBundle;

public class SSHConnection
extends AbstractConnection {
    private static final String CVS_SERVER_COMMAND = System.getProperty("Env-CVS_SERVER", "cvs") + " server";
    private final SocketFactory socketFactory;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private Session session;
    private ChannelExec channel;

    public SSHConnection(SocketFactory socketFactory, String string, int n, String string2, String string3) {
        this.socketFactory = socketFactory;
        this.host = string;
        this.port = n;
        this.username = string2 != null ? string2 : System.getProperty("user.name");
        this.password = string3;
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        Properties properties = new Properties();
        properties.put("StrictHostKeyChecking", "no");
        JSch jSch = new JSch();
        try {
            this.session = jSch.getSession(this.username, this.host, this.port);
            this.session.setSocketFactory((com.jcraft.jsch.SocketFactory)new SocketFactoryBridge());
            this.session.setConfig(properties);
            this.session.setUserInfo((UserInfo)new SSHUserInfo());
            this.session.connect();
        }
        catch (JSchException jSchException) {
            throw new AuthenticationException((Throwable)jSchException, NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3001"));
        }
        try {
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.channel.setCommand(CVS_SERVER_COMMAND);
            this.setInputStream(new LoggedDataInputStream((InputStream)new SshChannelInputStream((Channel)this.channel)));
            this.setOutputStream(new LoggedDataOutputStream(this.channel.getOutputStream()));
            this.channel.connect();
        }
        catch (JSchException jSchException) {
            IOException iOException = new IOException(NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3002"));
            iOException.initCause(jSchException);
            throw new AuthenticationException((Throwable)iOException, NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3003"));
        }
        catch (IOException iOException) {
            throw new AuthenticationException((Throwable)iOException, NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3003"));
        }
    }

    public void verify() throws AuthenticationException {
        try {
            this.open();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.channel.getExitStatus() != -1) {
                throw new AuthenticationException(CVS_SERVER_COMMAND, NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3004", (Object)CVS_SERVER_COMMAND));
            }
            this.close();
        }
        catch (CommandAbortedException commandAbortedException) {
            throw new AuthenticationException((Throwable)commandAbortedException, NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3005"));
        }
        catch (IOException iOException) {
            throw new AuthenticationException((Throwable)iOException, NbBundle.getMessage((Class)SSHConnection.class, (String)"Bk3006"));
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        this.session = null;
        this.channel = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        this.reset();
    }

    public boolean isOpen() {
        return this.channel != null && this.channel.isConnected();
    }

    public int getPort() {
        return this.port;
    }

    public void modifyInputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier connectionModifier) throws IOException {
        connectionModifier.modifyOutputStream(this.getOutputStream());
    }

    private static class SshChannelInputStream
    extends FilterInputStream {
        private final Channel channel;

        public SshChannelInputStream(Channel channel) throws IOException {
            super(channel.getInputStream());
            this.channel = channel;
        }

        public int available() throws IOException {
            this.checkChannelState();
            return super.available();
        }

        private void checkChannelState() throws IOException {
            int n = this.channel.getExitStatus();
            if (n > 0 || n < -1) {
                throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$SSHConnection == null ? (class$org$netbeans$modules$versioning$system$cvss$SSHConnection = SSHConnection.class$("org.netbeans.modules.versioning.system.cvss.SSHConnection")) : class$org$netbeans$modules$versioning$system$cvss$SSHConnection), (String)"BK3004", (Object)CVS_SERVER_COMMAND));
            }
            if (n == 0 || this.channel.isEOF()) {
                throw new EOFException(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$SSHConnection == null ? (class$org$netbeans$modules$versioning$system$cvss$SSHConnection = SSHConnection.class$("org.netbeans.modules.versioning.system.cvss.SSHConnection")) : class$org$netbeans$modules$versioning$system$cvss$SSHConnection), (String)"BK3007"));
            }
        }
    }

    private class SocketFactoryBridge
    implements com.jcraft.jsch.SocketFactory {
        private SocketFactoryBridge() {
        }

        public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
            return SSHConnection.this.socketFactory.createSocket(string, n);
        }

        public InputStream getInputStream(Socket socket) throws IOException {
            return socket.getInputStream();
        }

        public OutputStream getOutputStream(Socket socket) throws IOException {
            return socket.getOutputStream();
        }
    }

    private class SSHUserInfo
    implements UserInfo {
        private SSHUserInfo() {
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return SSHConnection.this.password;
        }

        public boolean promptPassword(String string) {
            return true;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public boolean promptYesNo(String string) {
            return false;
        }

        public void showMessage(String string) {
        }
    }
}

