/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.CvsMetadata;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.IllegalCommandException;
import org.netbeans.modules.versioning.system.cvss.NotVersionedException;
import org.netbeans.modules.versioning.system.cvss.VersionsCacheExecutor;
import org.netbeans.modules.versioning.system.cvss.settings.MetadataAttic;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class VersionsCache {
    public static final String REVISION_CURRENT = "";
    public static final String REVISION_BASE = "*";
    public static final String REVISION_HEAD = "HEAD";
    private static final String CACHE_DIR = "CVS/RevisionCache/";
    private static VersionsCache instance;
    private long purgeTimestamp = Long.MAX_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static VersionsCache getInstance() {
        return instance;
    }

    private VersionsCache() {
    }

    public synchronized File getRemoteFile(File file, String string, ExecutorGroup executorGroup) throws IOException, IllegalCommandException, CommandException, AuthenticationException, NotVersionedException {
        Object object;
        if (string == REVISION_BASE) {
            string = this.getBaseRevision(file);
        }
        if (string.equals(REVISION_HEAD) && (object = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(file)) != null && object.getTag() != null) {
            string = object.getTag();
        }
        if ((object = this.getCachedRevision(file, string)) != null) {
            return object;
        }
        object = this.checkoutRemoteFile(file, string, executorGroup);
        if (object == null) {
            return null;
        }
        object = this.saveRevision(file, (File)object, string);
        return object;
    }

    public void purgeVolatileRevisions() {
        this.purgeTimestamp = System.currentTimeMillis();
    }

    private File saveRevision(File file, File file2, String string) {
        File file3 = file.getParentFile().isDirectory() ? new File(file.getParentFile(), CACHE_DIR) : file2.getParentFile();
        if (!file3.exists() && !file3.mkdirs()) {
            return file2;
        }
        File file4 = new File(file3, this.cachedName(file, string));
        try {
            FileInputStream fileInputStream = new FileInputStream(file2);
            FileOutputStream fileOutputStream = new FileOutputStream(file4);
            FileUtil.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
            fileInputStream.close();
            fileOutputStream.close();
            file2.delete();
            return file4;
        }
        catch (IOException iOException) {
            return file2;
        }
    }

    private File getCachedRevision(File file, String string) {
        if (string == REVISION_CURRENT) {
            return file;
        }
        File file2 = new File(file.getParentFile(), CACHE_DIR + this.cachedName(file, string));
        if (this.isVolatile(string) && file2.lastModified() < this.purgeTimestamp) {
            file2.delete();
        }
        if (file2.canRead()) {
            return file2;
        }
        return null;
    }

    private boolean isVolatile(String string) {
        return string.indexOf(46) == -1;
    }

    private String getBaseRevision(File file) throws IOException {
        Entry entry = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(file);
        String string = entry.getRevision();
        if (string != null && string.startsWith("-")) {
            return string.substring(1);
        }
        return string;
    }

    private String cachedName(File file, String string) {
        return file.getName() + "#" + string;
    }

    private String getRepositoryForDirectory(File file, String string) {
        if (file == null) {
            return null;
        }
        if (!file.exists() && MetadataAttic.getMetadata(file) == null) {
            return this.getRepositoryForDirectory(file.getParentFile(), string) + "/" + file.getName();
        }
        try {
            return CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getAbsolutePath(), string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private File checkoutRemoteFile(File file, String string, ExecutorGroup executorGroup) throws IOException {
        GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
        String string2 = this.getCvsRoot(file.getParentFile());
        CVSRoot cVSRoot = CVSRoot.parse((String)string2);
        String string3 = cVSRoot.getRepository();
        globalOptions.setCVSRoot(string2);
        String string4 = this.getRepositoryForDirectory(file.getParentFile(), string3) + "/" + file.getName();
        CheckoutCommand checkoutCommand = new CheckoutCommand();
        checkoutCommand.setRecursive(false);
        if (!$assertionsDisabled && !string4.startsWith(string3)) {
            throw new AssertionError((Object)(string4 + " does not start with: " + string3));
        }
        if ((string4 = string4.substring(string3.length())).startsWith("/")) {
            string4 = string4.substring(1);
        }
        checkoutCommand.setModule(string4);
        checkoutCommand.setPipeToOutput(true);
        checkoutCommand.setCheckoutByRevision(string);
        String string5 = NbBundle.getMessage((Class)VersionsCache.class, (String)"MSG_VersionsCache_FetchingProgress", (Object)string, (Object)file.getName());
        checkoutCommand.setDisplayName(string5);
        VersionsCacheExecutor versionsCacheExecutor = new VersionsCacheExecutor(checkoutCommand, globalOptions);
        if (executorGroup != null) {
            executorGroup.progress(string5);
            executorGroup.addExecutor(versionsCacheExecutor);
        }
        versionsCacheExecutor.execute();
        ExecutorSupport.wait(new ExecutorSupport[]{versionsCacheExecutor});
        if (executorGroup == null) {
            versionsCacheExecutor.getGroup().executed();
        }
        if (versionsCacheExecutor.isSuccessful()) {
            return versionsCacheExecutor.getCheckedOutVersion();
        }
        IOException iOException = new IOException(NbBundle.getMessage((Class)VersionsCache.class, (String)"Bk4001", (Object)string, (Object)file.getName()));
        iOException.initCause(versionsCacheExecutor.getFailure());
        throw iOException;
    }

    private String getCvsRoot(File file) throws IOException {
        try {
            return Utils.getCVSRootFor(file);
        }
        catch (IOException iOException) {
            CvsMetadata cvsMetadata = MetadataAttic.getMetadata(file);
            if (cvsMetadata != null) {
                return cvsMetadata.getRoot();
            }
            throw new IOException("CVS/Root not found");
        }
    }

    static {
        $assertionsDisabled = !VersionsCache.class.desiredAssertionStatus();
        instance = new VersionsCache();
    }
}

