/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.executor;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.filesystems.FileUtil;

public class CheckoutExecutor
extends ExecutorSupport {
    private Set refreshedFiles;
    private Set expandedModules = new HashSet();

    public CheckoutExecutor(CvsVersioningSystem cvsVersioningSystem, CheckoutCommand checkoutCommand) {
        this(cvsVersioningSystem, checkoutCommand, null);
    }

    public CheckoutExecutor(CvsVersioningSystem cvsVersioningSystem, CheckoutCommand checkoutCommand, GlobalOptions globalOptions) {
        super(cvsVersioningSystem, (Command)checkoutCommand, globalOptions);
    }

    public Set getExpandedModules() {
        return this.expandedModules;
    }

    public final void moduleExpanded(ModuleExpansionEvent moduleExpansionEvent) {
        String string = moduleExpansionEvent.getModule();
        this.expandedModules.add(string);
    }

    protected void commandFinished(ClientRuntime.Result result) {
        File file;
        CheckoutCommand checkoutCommand = (CheckoutCommand)this.cmd;
        this.refreshedFiles = new HashSet(this.toRefresh.size());
        File[] fileArray = this.toRefresh.iterator();
        while (fileArray.hasNext()) {
            DefaultFileInfoContainer defaultFileInfoContainer = (DefaultFileInfoContainer)fileArray.next();
            int n = 0;
            if ("Changed".equals(defaultFileInfoContainer.getType()) || "Added".equals(defaultFileInfoContainer.getType())) {
                n = 65536;
            } else if ("Removed".equals(defaultFileInfoContainer.getType()) || "To-be-added".equals(defaultFileInfoContainer.getType())) {
                n = 0;
            }
            file = FileUtil.normalizeFile((File)defaultFileInfoContainer.getFile());
            this.cache.refreshCached(file, n);
            this.refreshedFiles.add(file);
        }
        fileArray = checkoutCommand.getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = FileUtil.normalizeFile((File)fileArray[i]);
            this.refreshRecursively(file2);
            if (file2.isFile()) {
                this.cache.refreshCached(file2.getParentFile(), 0);
            }
            if ((file = FileUtil.toFileObject((File)file2)) == null) continue;
            file.refresh(true);
        }
    }

    private void refreshRecursively(File file) {
        if (this.cvs.isIgnoredFilename(file)) {
            return;
        }
        if (this.refreshedFiles.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.refreshRecursively(fileArray[i]);
            }
            this.cache.refreshCached(file, 0);
        } else if (this.cache.getStatus(file.getParentFile()).getStatus() != 8) {
            this.cache.refreshCached(file, 0);
        }
    }
}

