/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.settings;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.modules.versioning.system.cvss.FileStatusProvider;
import org.openide.options.SystemOption;
import org.openide.util.Lookup;

public class CvsModuleConfig
extends SystemOption {
    private static final long serialVersionUID = 1L;
    public static final String PROP_IGNORED_FILEPATTERNS = "ignoredFilePatterns";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    public static final String PROP_DEFAULT_VALUES = "defaultValues";
    public static final String PROP_TEXT_ANNOTATIONS_FORMAT = "textAnnotations";
    static int id;

    public static CvsModuleConfig getDefault() {
        return (CvsModuleConfig)CvsModuleConfig.findObject((Class)CvsModuleConfig.class, (boolean)true);
    }

    public String getTextAnnotationsFormat() {
        return (String)this.getProperty(PROP_TEXT_ANNOTATIONS_FORMAT);
    }

    public void setTextAnnotationsFormat(String string) {
        this.putProperty(PROP_TEXT_ANNOTATIONS_FORMAT, string, true);
    }

    public Map getDefaultValues() {
        Map map = (Map)this.getProperty(PROP_DEFAULT_VALUES);
        if (map == null) {
            map = new PersistentHashMap(0);
            this.putProperty(PROP_DEFAULT_VALUES, map, false);
        }
        return map;
    }

    public Object getDefaultValue(String string, Object object) {
        Object v = this.getDefaultValues().get(string);
        return v != null ? v : object;
    }

    public String getDefaultValue(String string, String string2) {
        Object v = this.getDefaultValues().get(string);
        return v != null ? (String)v : string2;
    }

    public boolean getDefaultValue(String string, boolean bl) {
        Object v = this.getDefaultValues().get(string);
        return v != null ? (Boolean)v : bl;
    }

    public void setDefaultValue(String string, Object object) {
        Map map = this.getDefaultValues();
        Object v = map.get(string);
        if (v == object || object != null && object.equals(v)) {
            return;
        }
        if (object == null) {
            map.remove(string);
        } else {
            map.put(string, object);
        }
        this.setDefaultValues(new PersistentHashMap(map));
    }

    public void setDefaultValue(String string, boolean bl) {
        this.setDefaultValue(string, (Object)bl);
    }

    public void setDefaultValues(Map map) {
        this.putProperty(PROP_DEFAULT_VALUES, map, true);
    }

    public Pattern[] getIgnoredFilePatterns() {
        Pattern[] patternArray = (Pattern[])this.getProperty(PROP_IGNORED_FILEPATTERNS);
        if (patternArray == null) {
            patternArray = CvsModuleConfig.getDefaultFilePatterns();
            this.putProperty(PROP_IGNORED_FILEPATTERNS, patternArray, false);
        }
        return patternArray;
    }

    public void setIgnoredFilePatterns(Pattern[] patternArray) {
        this.putProperty(PROP_IGNORED_FILEPATTERNS, patternArray, true);
    }

    public Set getCommitExclusions() {
        Set set = (Set)this.getProperty(PROP_COMMIT_EXCLUSIONS);
        if (set == null) {
            set = new PersistentHashSet(0);
            this.putProperty(PROP_COMMIT_EXCLUSIONS, set, false);
        }
        return set;
    }

    public void setCommitExclusions(Set set) {
        this.putProperty(PROP_COMMIT_EXCLUSIONS, set, true);
    }

    public boolean isExcludedFromCommit(String string) {
        return this.getCommitExclusions().contains(string);
    }

    public void addExclusionPath(String string) {
        Set set = this.getCommitExclusions();
        if (set.add(string)) {
            this.setCommitExclusions(new PersistentHashSet((Collection)set));
            FileStatusProvider fileStatusProvider = (FileStatusProvider)Lookup.getDefault().lookup(FileStatusProvider.class);
            File file = new File(string);
            fileStatusProvider.fireFileStatusEvent(file);
        }
    }

    public void removeExclusionPath(String string) {
        Set set = this.getCommitExclusions();
        if (set.remove(string)) {
            this.setCommitExclusions(new PersistentHashSet((Collection)set));
            FileStatusProvider fileStatusProvider = (FileStatusProvider)Lookup.getDefault().lookup(FileStatusProvider.class);
            File file = new File(string);
            fileStatusProvider.fireFileStatusEvent(file);
        }
    }

    private static Pattern[] getDefaultFilePatterns() {
        return new Pattern[]{Pattern.compile("cvslog\\..*"), Pattern.compile("\\.make\\.state"), Pattern.compile("\\.nse_depinfo"), Pattern.compile(".*~"), Pattern.compile("#.*"), Pattern.compile("\\.#.*"), Pattern.compile(",.*"), Pattern.compile("_\\$.*"), Pattern.compile(".*\\$"), Pattern.compile(".*\\.old"), Pattern.compile(".*\\.bak"), Pattern.compile(".*\\.BAK"), Pattern.compile(".*\\.orig"), Pattern.compile(".*\\.rej"), Pattern.compile(".*\\.del-.*"), Pattern.compile(".*\\.a"), Pattern.compile(".*\\.olb"), Pattern.compile(".*\\.o"), Pattern.compile(".*\\.obj"), Pattern.compile(".*\\.so"), Pattern.compile(".*\\.exe"), Pattern.compile(".*\\.Z"), Pattern.compile(".*\\.elc"), Pattern.compile(".*\\.ln")};
    }

    public String displayName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private static final class PersistentHashMap
    extends HashMap {
        private static final long serialVersionUID = 1L;

        public PersistentHashMap() {
        }

        public PersistentHashMap(Map map) {
            super(map);
        }

        public PersistentHashMap(int n) {
            super(n);
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }

    private static final class PersistentHashSet
    extends HashSet {
        private static final long serialVersionUID = 1L;

        public PersistentHashSet() {
        }

        public PersistentHashSet(int n) {
            super(n);
        }

        public PersistentHashSet(Collection collection) {
            super(collection);
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }
}

