/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openide.options.SystemOption;

public final class HistorySettings
extends SystemOption {
    private static final long serialVersionUID = 1L;
    public static final String PROP_CVS_ROOTS = "cvsRoots";
    public static final String PROP_CHECKOUT_DIRECTORY = "checkoutDirectory";
    public static final String PROP_SHOW_CHECKOUT_COMPLETED = "showCheckoutCompleted";
    public static final int HISTORY_LEN = 8;
    public static final String PROP_HTTP_PROXY_HOST = "httpProxyHost";
    public static final String PROP_HTTP_PROXY_PORT = "httpProxyPort";
    public static final String PROP_SOCKS_PROXY_HOST = "socksProxyHost";
    public static final String PROP_SOCKS_PROXY_PORT = "socksProxyPort";
    public static final String PROP_EXT_COMMAND = "extCommand";

    public static HistorySettings getDefault() {
        return (HistorySettings)HistorySettings.findObject((Class)HistorySettings.class, (boolean)true);
    }

    public static List getRecent(String string) {
        List list = (List)HistorySettings.getDefault().getProperty(string);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public static void setRecent(String string, List list) {
        HistorySettings.getDefault().putProperty(string, new ArrayList(list), true);
    }

    public static void addRecent(String string, Serializable serializable) {
        ArrayList<Serializable> arrayList;
        List list = (List)HistorySettings.getDefault().getProperty(string);
        if (list == null) {
            arrayList = new ArrayList<Serializable>(1);
            arrayList.add(serializable);
        } else {
            arrayList = new ArrayList(list);
            arrayList.remove(serializable);
            while (arrayList.size() > 8) {
                arrayList.remove(arrayList.size() - 1);
            }
            arrayList.add(0, serializable);
        }
        HistorySettings.getDefault().putProperty(string, arrayList, true);
    }

    public static void setFlag(String string, int n) {
        HistorySettings.getDefault().putProperty(string, new Integer(n));
    }

    public static int getFlag(String string, int n) {
        Integer n2 = (Integer)HistorySettings.getDefault().getProperty(string);
        if (n2 != null) {
            return n2;
        }
        return n;
    }

    public String displayName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public List getCvsRoots() {
        return HistorySettings.getRecent(PROP_CVS_ROOTS);
    }

    public void setCvsRoots(List list) {
        HistorySettings.setRecent(PROP_CVS_ROOTS, list);
    }

    public List getCheckoutDirectory() {
        return HistorySettings.getRecent(PROP_CHECKOUT_DIRECTORY);
    }

    public void setCheckoutDirectory(List list) {
        HistorySettings.setRecent(PROP_CHECKOUT_DIRECTORY, list);
    }

    public boolean getShowCheckoutCompleted() {
        int n = HistorySettings.getFlag(PROP_SHOW_CHECKOUT_COMPLETED, -1);
        return n != 0;
    }

    public void setShowCheckoutCompleted(boolean bl) {
        HistorySettings.setFlag(PROP_SHOW_CHECKOUT_COMPLETED, bl ? -1 : 0);
    }

    public String getHttpProxyHost() {
        String string = (String)this.getProperty(PROP_HTTP_PROXY_HOST);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setHttpProxyHost(String string) {
        this.putProperty(PROP_HTTP_PROXY_HOST, string);
    }

    public String getHttpProxyPort() {
        String string = (String)this.getProperty(PROP_HTTP_PROXY_PORT);
        if (string == null) {
            string = "80";
        }
        return string;
    }

    public void setHttpProxyPort(String string) {
        this.putProperty(PROP_HTTP_PROXY_PORT, string);
    }

    public String getSocksProxyHost() {
        String string = (String)this.getProperty(PROP_SOCKS_PROXY_HOST);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setSocksProxyHost(String string) {
        this.putProperty(PROP_SOCKS_PROXY_HOST, string);
    }

    public String getSocksProxyPort() {
        String string = (String)this.getProperty(PROP_SOCKS_PROXY_PORT);
        if (string == null) {
            string = "1080";
        }
        return string;
    }

    public void setSocksProxyPort(String string) {
        this.putProperty(PROP_SOCKS_PROXY_PORT, string);
    }

    public void setExtCommand(String string) {
        this.putProperty(PROP_EXT_COMMAND, string);
    }

    public String getExtCommand() {
        return (String)this.getProperty(PROP_EXT_COMMAND);
    }
}

