/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.settings;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.versioning.system.cvss.CvsMetadata;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.options.SystemOption;

public class MetadataAttic
extends SystemOption {
    private static final long serialVersionUID = 1L;
    public static final String PROP_FOLDERS_MAP = "foldersMap";
    public static final String PROP_SCHEDULED_FOLDERS = "scheduledProjects";
    static int id;

    public static void cleanUp() {
        Map map = MetadataAttic.getDefault().getFoldersMap();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists()) continue;
            iterator.remove();
        }
        map = new PersistentMap(map);
        MetadataAttic.getDefault().putProperty(PROP_FOLDERS_MAP, map, true);
    }

    public static CvsMetadata getMetadata(File file) {
        Metadata metadata = (Metadata)MetadataAttic.getDefault().getFoldersMap().get(file);
        return metadata != null ? metadata.data : null;
    }

    public static void setMetadata(File file, CvsMetadata cvsMetadata) {
        Map map = MetadataAttic.getDefault().getFoldersMap();
        if (cvsMetadata != null) {
            Metadata metadata = new Metadata();
            metadata.data = cvsMetadata;
            map.put(file, metadata);
        } else {
            map.remove(file);
        }
        map = new PersistentMap(map);
        MetadataAttic.getDefault().putProperty(PROP_FOLDERS_MAP, map, true);
    }

    public static void scheduleFolder(FileObject fileObject, String string, String string2) {
        File file = FileUtil.toFile((FileObject)fileObject);
        Map map = MetadataAttic.getDefault().getScheduledFolders();
        if (string == null || string2 == null) {
            map.remove(file);
        } else {
            Repository repository = new Repository();
            repository.cvsRoot = string;
            repository.cvsRepository = string2;
            map.put(file, string2);
        }
        MetadataAttic.getDefault().setScheduledFolders(map);
    }

    public static String getScheduledRepository(FileObject fileObject) {
        File file;
        Map map = MetadataAttic.getDefault().getScheduledFolders();
        Repository repository = (Repository)map.get(file = FileUtil.toFile((FileObject)fileObject));
        if (repository != null) {
            return repository.cvsRepository;
        }
        return null;
    }

    public static String getScheduledRoot(FileObject fileObject) {
        File file;
        Map map = MetadataAttic.getDefault().getScheduledFolders();
        Repository repository = (Repository)map.get(file = FileUtil.toFile((FileObject)fileObject));
        if (repository != null) {
            return repository.cvsRoot;
        }
        return null;
    }

    private static MetadataAttic getDefault() {
        return (MetadataAttic)MetadataAttic.findObject((Class)MetadataAttic.class, (boolean)true);
    }

    public String displayName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Map getFoldersMap() {
        Map map = (Map)this.getProperty(PROP_FOLDERS_MAP);
        if (map == null) {
            map = new PersistentMap();
        }
        return map;
    }

    public void setFoldersMap(Map map) {
        this.putProperty(PROP_FOLDERS_MAP, new PersistentMap(map), true);
    }

    public Map getScheduledFolders() {
        Map map = (Map)this.getProperty(PROP_SCHEDULED_FOLDERS);
        if (map == null) {
            map = new PersistentMap();
        }
        return map;
    }

    public void setScheduledFolders(Map map) {
        this.putProperty(PROP_SCHEDULED_FOLDERS, new PersistentMap(map), true);
    }

    private static final class PersistentMap
    extends HashMap {
        private static final long serialVersionUID = 1L;

        public PersistentMap() {
        }

        public PersistentMap(Map map) {
            super(map);
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    private static final class Repository
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String cvsRoot;
        public String cvsRepository;

        private Repository() {
        }
    }

    private static final class Metadata
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CvsMetadata data;

        private Metadata() {
        }
    }
}

