/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public abstract class AbstractSystemAction
extends NodeAction {
    protected abstract String getBaseName(Node[] var1);

    protected AbstractSystemAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] nodeArray) {
        LifecycleManager.getDefault().saveAll();
        this.performCvsAction(nodeArray);
    }

    protected boolean enable(Node[] nodeArray) {
        return this.getContext(nodeArray).getRootFiles().length > 0;
    }

    protected abstract void performCvsAction(Node[] var1);

    public final boolean isEnabled() {
        return super.isEnabled();
    }

    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
    }

    public final void performAction() {
        super.performAction();
    }

    public String getName() {
        return this.getName("", TopComponent.getRegistry().getActivatedNodes());
    }

    public String getRunningName(Node[] nodeArray) {
        return this.getName("Running", nodeArray);
    }

    private String getName(String string, Node[] nodeArray) {
        Project project;
        Node node;
        String string2 = this.getBaseName(nodeArray) + string;
        if (!this.isEnabled()) {
            return NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(string2);
        }
        File[] fileArray = Utils.getCurrentContext(nodeArray, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus()).getFiles();
        int n = fileArray.length;
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            node = nodeArray[i];
            project = (Project)node.getLookup().lookup(class$org$netbeans$api$project$Project == null ? AbstractSystemAction.class$("org.netbeans.api.project.Project") : class$org$netbeans$api$project$Project);
            if (project != null) continue;
            bl = false;
            break;
        }
        if (bl) {
            n = nodeArray.length;
        }
        if (n == 0) {
            return NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(string2);
        }
        if (n == 1) {
            String string3;
            if (bl) {
                String string4 = ProjectUtils.getInformation((Project)((Project)nodeArray[0].getLookup().lookup(Project.class))).getDisplayName();
                return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(string2 + "_Context"), (Object)string4);
            }
            node = (FileObject)nodeArray[0].getLookup().lookup(FileObject.class);
            if (node != null) {
                string3 = node.getNameExt();
            } else {
                project = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
                if (project instanceof DataShadow) {
                    project = ((DataShadow)project).getOriginal();
                }
                string3 = project != null ? project.getPrimaryFile().getNameExt() : nodeArray[0].getDisplayName();
            }
            return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(string2 + "_Context"), string3);
        }
        if (bl) {
            try {
                return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(string2 + "_Projects"), new Integer(n));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(string2 + "_Context_Multiple"), new Integer(n));
    }

    public String getContextDisplayName(Node[] nodeArray) {
        Node node;
        File[] fileArray = Utils.getCurrentContext(nodeArray, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus()).getFiles();
        int n = fileArray.length;
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            node = nodeArray[i];
            Project project = (Project)node.getLookup().lookup(class$org$netbeans$api$project$Project == null ? AbstractSystemAction.class$("org.netbeans.api.project.Project") : class$org$netbeans$api$project$Project);
            if (project != null) continue;
            bl = false;
            break;
        }
        if (bl) {
            n = nodeArray.length;
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            if (bl) {
                return ProjectUtils.getInformation((Project)((Project)nodeArray[0].getLookup().lookup(Project.class))).getDisplayName();
            }
            FileObject fileObject = (FileObject)nodeArray[0].getLookup().lookup(FileObject.class);
            if (fileObject != null) {
                return fileObject.getNameExt();
            }
            node = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
            if (node instanceof DataShadow) {
                node = ((DataShadow)node).getOriginal();
            }
            if (node != null) {
                return node.getPrimaryFile().getNameExt();
            }
            return nodeArray[0].getDisplayName();
        }
        if (bl) {
            try {
                return MessageFormat.format(NbBundle.getBundle((Class)AbstractSystemAction.class).getString("MSG_ActionContext_MultipleProjects"), new Integer(n));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle((Class)AbstractSystemAction.class).getString("MSG_ActionContext_MultipleFiles"), new Integer(n));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected Context getContext(Node[] nodeArray) {
        return Utils.getCurrentContext(nodeArray, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus());
    }

    protected int getFileEnabledStatus() {
        return -1;
    }

    protected int getDirectoryEnabledStatus() {
        return -4;
    }
}

