/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class DeleteLocalAction
extends AbstractSystemAction {
    public static final int LOCALLY_DELETABLE_MASK = 4100;

    public void performCvsAction(Node[] nodeArray) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)DeleteLocalAction.class, (String)"CTL_DeleteLocal_Prompt"));
        confirmation.setTitle(NbBundle.getMessage((Class)DeleteLocalAction.class, (String)"CTL_DeleteLocal_Title"));
        confirmation.setMessageType(2);
        confirmation.setOptionType(0);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object != NotifyDescriptor.YES_OPTION) {
            return;
        }
        final File[] fileArray = this.getContext(nodeArray).getFiles();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                DeleteLocalAction.this.async(fileArray);
            }
        });
    }

    protected int getFileEnabledStatus() {
        return 4100;
    }

    protected String getBaseName(Node[] nodeArray) {
        return "Delete";
    }

    protected boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void async(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            StandardAdminHandler standardAdminHandler = new StandardAdminHandler();
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            FileLock fileLock = null;
            try {
                fileLock = fileObject.lock();
                standardAdminHandler.removeEntry(file);
                fileObject.delete(fileLock);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$DeleteLocalAction == null ? DeleteLocalAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.DeleteLocalAction") : class$org$netbeans$modules$versioning$system$cvss$ui$actions$DeleteLocalAction), (String)"BK0001", (Object)file.getAbsolutePath()));
                errorManager.notify((Throwable)iOException);
                continue;
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }
}

