/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions;

import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.netbeans.modules.versioning.system.cvss.ui.actions.SystemActionBridge;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.AddToRepositoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.UpdateWithDependenciesAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.status.StatusAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergeBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.SwitchBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public final class ProjectCvsMenuItem
extends NodeAction
implements Presenter.Popup {
    private static final String name = NbBundle.getBundle((Class)ProjectCvsMenuItem.class).getString("CTL_MenuItem_CVSCommands_Label");

    public String getName() {
        return name;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectCvsMenuItem.class);
    }

    protected void performAction(Node[] nodeArray) {
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length > 0) {
            int n = 0;
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                if (!Utils.isVersionedProject(node)) continue;
                ++n;
            }
            return n == nodeArray.length || n == 0;
        }
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new CvsProjectMenuItems();
    }

    private static Action[] actions() {
        Action[] actionArray;
        Object object;
        Node[] nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
        int n = 0;
        for (int i = 0; i < nodeArray.length; ++i) {
            object = nodeArray[i];
            if (!Utils.isVersionedProject((Node)object)) continue;
            ++n;
        }
        if (n == 0) {
            object = SystemAction.get((Class)AddToRepositoryAction.class);
            actionArray = new Action[]{new SystemActionBridge((Action)object, object.getName())};
        } else {
            object = NbBundle.getBundle((Class)ProjectCvsMenuItem.class);
            actionArray = new Action[]{new SystemActionBridge((Action)SystemAction.get((Class)StatusAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_Status")), new SystemActionBridge((Action)SystemAction.get((Class)DiffAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_Diff")), new SystemActionBridge((Action)SystemAction.get((Class)UpdateAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_Update")), new SystemActionBridge((Action)SystemAction.get((Class)UpdateWithDependenciesAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_UpdateWithDeps")), new SystemActionBridge((Action)SystemAction.get((Class)CommitAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_Commit")), null, new SystemActionBridge((Action)SystemAction.get((Class)TagAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_Tag")), null, new SystemActionBridge((Action)SystemAction.get((Class)BranchAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_Branch")), new SystemActionBridge((Action)SystemAction.get((Class)SwitchBranchAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_SwitchBranch")), new SystemActionBridge((Action)SystemAction.get((Class)MergeBranchAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_MergeFromBranch")), null, new SystemActionBridge((Action)SystemAction.get((Class)SearchHistoryAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_SearchHistory")), null, new SystemActionBridge((Action)SystemAction.get((Class)GetCleanAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_RevertModifications")), new SystemActionBridge((Action)SystemAction.get((Class)ResolveConflictsAction.class), ((ResourceBundle)object).getString("CTL_ProjectMenu_ResolveConflicts"))};
        }
        return actionArray;
    }

    private static final class CvsProjectMenuItems
    extends JMenu {
        static final long serialVersionUID = 1L;
        private boolean popupContructed;

        public CvsProjectMenuItems() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)name);
        }

        public void setSelected(boolean bl) {
            if (bl && !this.popupContructed) {
                Action[] actionArray = ProjectCvsMenuItem.actions();
                for (int i = 0; i < actionArray.length; ++i) {
                    Action action = actionArray[i];
                    if (action == null) {
                        this.add(new JSeparator());
                        continue;
                    }
                    JMenuItem jMenuItem = new JMenuItem(actionArray[i]);
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
                    this.add(jMenuItem);
                }
                this.popupContructed = true;
            }
            super.setSelected(bl);
        }
    }
}

