/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.checkout;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.executor.CheckoutExecutor;
import org.netbeans.modules.versioning.system.cvss.settings.HistorySettings;
import org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutCompletedPanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.ProjectUtilities;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public final class CheckoutAction
extends SystemAction {
    static /* synthetic */ Class class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutCompletedPanel;

    public CheckoutAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getBundle((Class)CheckoutAction.class).getString("CTL_MenuItem_Checkout_Label");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CheckoutAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CheckoutWizard checkoutWizard = new CheckoutWizard();
        if (!checkoutWizard.show()) {
            return;
        }
        final String string = checkoutWizard.getTag();
        final String string2 = checkoutWizard.getModules();
        final String string3 = checkoutWizard.getWorkingDir();
        final String string4 = checkoutWizard.getCvsRoot();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CheckoutAction.this.checkout(string4, string2, string, string3, true, null);
            }
        });
    }

    public CheckoutExecutor checkout(String string, String string2, String string3, String string4, boolean bl, ExecutorGroup executorGroup) {
        Object[] objectArray;
        Serializable serializable;
        StringTokenizer stringTokenizer;
        CheckoutCommand checkoutCommand = new CheckoutCommand();
        String string5 = string2;
        if (string5 == null || string5.length() == 0) {
            string5 = ".";
        }
        if ((stringTokenizer = new StringTokenizer(string5, ",;")).countTokens() == 1) {
            checkoutCommand.setModule(string5);
        } else {
            serializable = new ArrayList<String[]>();
            while (stringTokenizer.hasMoreTokens()) {
                objectArray = stringTokenizer.nextToken().trim();
                serializable.add((String[])objectArray);
            }
            objectArray = serializable.toArray(new String[serializable.size()]);
            checkoutCommand.setModules((String[])objectArray);
        }
        checkoutCommand.setDisplayName(NbBundle.getMessage((Class)CheckoutAction.class, (String)"BK1006"));
        if (string3 != null) {
            checkoutCommand.setCheckoutByRevision(string3);
        } else {
            checkoutCommand.setResetStickyOnes(true);
        }
        checkoutCommand.setPruneDirectories(true);
        checkoutCommand.setRecursive(true);
        serializable = new File(string4);
        objectArray = new File[]{serializable};
        checkoutCommand.setFiles((File[])objectArray);
        CvsVersioningSystem cvsVersioningSystem = CvsVersioningSystem.getInstance();
        GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
        globalOptions.setCVSRoot(string);
        boolean bl2 = false;
        if (executorGroup == null) {
            bl2 = true;
            executorGroup = new ExecutorGroup(NbBundle.getMessage((Class)CheckoutAction.class, (String)"BK1013"));
        }
        CheckoutExecutor checkoutExecutor = new CheckoutExecutor(cvsVersioningSystem, checkoutCommand, globalOptions);
        executorGroup.addExecutor(checkoutExecutor);
        if (HistorySettings.getFlag("showCheckoutCompleted", -1) != 0 && bl) {
            executorGroup.addBarrier(new CheckoutCompletedController(checkoutExecutor, (File)serializable, bl));
        }
        if (bl2) {
            executorGroup.execute();
        }
        return checkoutExecutor;
    }

    private class CheckoutCompletedController
    implements Runnable,
    ActionListener {
        private final CheckoutExecutor executor;
        private final File workingFolder;
        private final boolean openProject;
        private CheckoutCompletedPanel panel;
        private Dialog dialog;
        private Project projectToBeOpened;

        public CheckoutCompletedController(CheckoutExecutor checkoutExecutor, File file, boolean bl) {
            this.executor = checkoutExecutor;
            this.workingFolder = file;
            this.openProject = bl;
        }

        public void run() {
            Object object;
            Object[] objectArray;
            DialogDescriptor dialogDescriptor;
            String string;
            if (!this.executor.isSuccessful()) {
                return;
            }
            List list = new LinkedList();
            File file = FileUtil.normalizeFile((File)this.workingFolder);
            this.refreshRecursively(file);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null) {
                string = NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction = CheckoutAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction")) : class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction), (String)"BK1007");
                this.executor.getGroup().progress(string);
                dialogDescriptor = this.executor.getExpandedModules().iterator();
                while (dialogDescriptor.hasNext()) {
                    objectArray = (Object[])dialogDescriptor.next();
                    if (".".equals(objectArray)) {
                        list = ProjectUtilities.scanForProjects(fileObject);
                        break;
                    }
                    object = fileObject.getFileObject((String)objectArray);
                    if (object == null) continue;
                    this.executor.getGroup().progress(string);
                    list.addAll(ProjectUtilities.scanForProjects(object));
                }
            }
            this.panel = new CheckoutCompletedPanel();
            this.panel.openButton.addActionListener(this);
            this.panel.createButton.addActionListener(this);
            this.panel.closeButton.addActionListener(this);
            this.panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.panel.againCheckBox.setVisible(!this.openProject);
            string = NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction = CheckoutAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction")) : class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction), (String)"BK1008");
            dialogDescriptor = new DialogDescriptor((Object)this.panel, string);
            dialogDescriptor.setModal(true);
            this.panel.remove(this.panel.openButton);
            this.panel.remove(this.panel.createButton);
            this.panel.remove(this.panel.closeButton);
            objectArray = null;
            if (list.size() > 1) {
                object = NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction = CheckoutAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction")) : class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction), (String)"BK1009", (Object)new Integer(list.size()));
                this.panel.jLabel1.setText((String)object);
                objectArray = new Object[]{this.panel.openButton, this.panel.closeButton};
            } else if (list.size() == 1) {
                object = (Project)list.iterator().next();
                this.projectToBeOpened = object;
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)object);
                String string2 = projectInformation.getDisplayName();
                String string3 = NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction = CheckoutAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction")) : class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction), (String)"BK1011", (Object)string2);
                this.panel.jLabel1.setText(string3);
                this.panel.openButton.setText(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction = CheckoutAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction")) : class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction), (String)"BK1012"));
                objectArray = new Object[]{this.panel.openButton, this.panel.closeButton};
            } else {
                object = NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction = CheckoutAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction")) : class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction), (String)"BK1010");
                this.panel.jLabel1.setText((String)object);
                objectArray = new Object[]{this.panel.createButton, this.panel.closeButton};
            }
            dialogDescriptor.setMessageType(1);
            dialogDescriptor.setOptions(objectArray);
            dialogDescriptor.setClosingOptions(objectArray);
            dialogDescriptor.setHelpCtx(new HelpCtx(class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutCompletedPanel == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutCompletedPanel = CheckoutAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutCompletedPanel")) : class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutCompletedPanel));
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction = CheckoutAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction")) : class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction), (String)"ACSD_CheckoutCompleted_Dialog"));
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ CheckoutCompletedController this$1;
                {
                    this.this$1 = checkoutCompletedController;
                }

                public void run() {
                    CheckoutCompletedController.access$000(this.this$1).setVisible(true);
                }
            });
        }

        private void refreshRecursively(File file) {
            if (file == null) {
                return;
            }
            this.refreshRecursively(file.getParentFile());
            CvsVersioningSystem.getInstance().getStatusCache().refresh(file, 0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            this.dialog.setVisible(false);
            if (this.panel.openButton.equals(object)) {
                if (this.projectToBeOpened == null) {
                    JFileChooser jFileChooser = ProjectChooser.projectChooser();
                    jFileChooser.setCurrentDirectory(this.workingFolder);
                    jFileChooser.setMultiSelectionEnabled(true);
                    jFileChooser.showOpenDialog(null);
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file = fileArray[i];
                        FileObject fileObject = FileUtil.toFileObject((File)file);
                        if (fileObject == null) continue;
                        try {
                            Project project = ProjectManager.getDefault().findProject(fileObject);
                            if (project == null) continue;
                            this.openProject(project);
                            continue;
                        }
                        catch (IOException iOException) {
                            ErrorManager errorManager = ErrorManager.getDefault();
                            errorManager.annotate((Throwable)iOException, NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction == null ? CheckoutAction.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction") : class$org$netbeans$modules$versioning$system$cvss$ui$actions$checkout$CheckoutAction), (String)"BK1014", (Object)fileObject));
                            errorManager.notify((Throwable)iOException);
                        }
                    }
                } else {
                    if (this.projectToBeOpened == null) {
                        return;
                    }
                    this.openProject(this.projectToBeOpened);
                }
            } else if (this.panel.createButton.equals(object)) {
                ProjectUtilities.newProjectWizard(this.workingFolder);
            }
            if (this.panel.againCheckBox.isSelected()) {
                HistorySettings.setFlag("showCheckoutCompleted", 0);
            }
        }

        private void openProject(Project project) {
            Project[] projectArray = new Project[]{project};
            OpenProjects.getDefault().open(projectArray, false);
            ContextAwareAction contextAwareAction = (ContextAwareAction)CommonProjectActions.setAsMainProjectAction();
            Lookup lookup = Lookups.singleton((Object)project);
            Action action = contextAwareAction.createContextAwareInstance(lookup);
            action.actionPerformed(null);
            ProjectUtilities.selectAndExpandProject(project);
        }

        static /* synthetic */ Dialog access$000(CheckoutCompletedController checkoutCompletedController) {
            return checkoutCompletedController.dialog;
        }
    }
}

