/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.command.remove.RemoveCommand;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.executor.RemoveExecutor;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.add.AddExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitOptions;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitSettings;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CommitAction
extends AbstractSystemAction {
    private static CommitCommand commandTemplate = new CommitCommand();

    public CommitAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Commit";
    }

    protected boolean enable(Node[] nodeArray) {
        return CvsVersioningSystem.getInstance().getFileTableModel(Utils.getCurrentContext(nodeArray), 6612).getNodes().length > 0;
    }

    public static void invokeCommit(String string, Context context, String string2) {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)CommitAction.class);
        if (CvsVersioningSystem.getInstance().getFileTableModel(context, 6612).getNodes().length == 0) {
            JOptionPane.showMessageDialog(null, resourceBundle.getString("MSG_NoFilesToCommit_Prompt"), resourceBundle.getString("MSG_NoFilesToCommit_Title"), 1);
            return;
        }
        CommitCommand commitCommand = new CommitCommand();
        commitCommand.setDisplayName(NbBundle.getMessage((Class)CommitAction.class, (String)"BK0001"));
        CommitAction.copy(commitCommand, commandTemplate);
        final CommitSettings commitSettings = new CommitSettings();
        commitSettings.setCommand(commitCommand);
        final JButton jButton = new JButton(resourceBundle.getString("CTL_CommitForm_Action_Commit"));
        jButton.setToolTipText(NbBundle.getMessage((Class)CommitAction.class, (String)"TT_CommitDialog_Action_Commit"));
        jButton.setEnabled(false);
        JButton jButton2 = new JButton(resourceBundle.getString("CTL_CommitForm_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CommitAction.class, (String)"ACSD_CommitDialog_Action_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)commitSettings, MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title"), string), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
        dialogDescriptor.setClosingOptions(null);
        dialogDescriptor.setHelpCtx(new HelpCtx(CommitSettings.class));
        commitSettings.addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent versioningEvent) {
                CommitAction.refreshCommitDialog(commitSettings, jButton);
            }
        });
        CommitAction.setupNodes(commitSettings, context);
        commitSettings.putClientProperty("contentTitle", string);
        commitSettings.putClientProperty("DialogDescriptor", dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CommitAction.class, (String)"ACSD_CommitDialog"));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        CommitAction.saveExclusions(commitSettings);
        commitSettings.updateCommand(commitCommand);
        CommitAction.copy(commandTemplate, commitCommand);
        if (string2 == null) {
            string2 = NbBundle.getMessage((Class)CommitAction.class, (String)"BK0002");
        }
        ExecutorGroup executorGroup = new ExecutorGroup(string2);
        CommitAction.addCommit(executorGroup, commitSettings);
        executorGroup.execute();
    }

    private static void saveExclusions(CommitSettings commitSettings) {
        CommitSettings.CommitFile[] commitFileArray = commitSettings.getCommitFiles();
        for (int i = 0; i < commitFileArray.length; ++i) {
            CommitSettings.CommitFile commitFile = commitFileArray[i];
            if (commitFile.getOptions() == CommitOptions.EXCLUDE) {
                CvsModuleConfig.getDefault().addExclusionPath(commitFile.getNode().getFile().getAbsolutePath());
                continue;
            }
            CvsModuleConfig.getDefault().removeExclusionPath(commitFile.getNode().getFile().getAbsolutePath());
        }
    }

    private static void setupNodes(CommitSettings commitSettings, Context context) {
        CvsFileNode[] cvsFileNodeArray = CvsVersioningSystem.getInstance().getFileTableModel(context, 6612).getNodes();
        commitSettings.setNodes(cvsFileNodeArray);
    }

    private static void refreshCommitDialog(CommitSettings commitSettings, JButton jButton) {
        String string;
        String string2;
        CommitSettings.CommitFile commitFile;
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)CommitAction.class);
        CommitSettings.CommitFile[] commitFileArray = commitSettings.getCommitFiles();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        for (int i = 0; i < commitFileArray.length; ++i) {
            commitFile = commitFileArray[i];
            if (commitFile.getOptions() == CommitOptions.EXCLUDE) continue;
            hashSet.add(Utils.getSticky(commitFile.getNode().getFile()));
            int n = commitFile.getNode().getInformation().getStatus();
            if ((n & 0x6A0) != 0 || n == 64) {
                jButton.setEnabled(false);
                string2 = n == 64 ? resourceBundle.getString("MSG_CommitForm_ErrorConflicts") : resourceBundle.getString("MSG_CommitForm_ErrorRemoteChanges");
                commitSettings.setErrorLabel("<html><font color=\"#002080\">" + string2 + "</font></html>");
                bl = true;
            }
            hashSet.add(Utils.getSticky(commitFile.getNode().getFile()));
        }
        if (hashSet.size() > 1) {
            commitSettings.setColumns(new String[]{"name", "sticky", "status", "action", "path"});
        } else {
            commitSettings.setColumns(new String[]{"name", "status", "action", "path"});
        }
        String string3 = (String)commitSettings.getClientProperty("contentTitle");
        commitFile = (DialogDescriptor)commitSettings.getClientProperty("DialogDescriptor");
        if (hashSet.size() <= 1) {
            String string4 = string2 = hashSet.size() == 0 ? null : (String)hashSet.iterator().next();
            if (string2 == null) {
                commitFile.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title"), string3));
                string = "";
            } else {
                string2 = string2.substring(1);
                commitFile.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branch"), string3, string2));
                String string5 = MessageFormat.format(resourceBundle.getString("MSG_CommitForm_InfoBranch"), string2);
                string = "<html><font color=\"#002080\">" + string5 + "</font></html>";
            }
        } else {
            commitFile.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branches"), string3));
            string2 = resourceBundle.getString("MSG_CommitForm_ErrorMultipleBranches");
            string = "<html><font color=\"#CC0000\">" + string2 + "</font></html>";
        }
        if (!bl) {
            commitSettings.setErrorLabel(string);
            jButton.setEnabled(true);
        }
    }

    public void performCvsAction(Node[] nodeArray) {
        CommitAction.invokeCommit(this.getContextDisplayName(nodeArray), this.getContext(nodeArray), this.getRunningName(nodeArray));
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void copy(CommitCommand commitCommand, CommitCommand commitCommand2) {
        commitCommand.setMessage(commitCommand2.getMessage());
        commitCommand.setRecursive(commitCommand2.isRecursive());
        commitCommand.setForceCommit(commitCommand2.isForceCommit());
        commitCommand.setLogMessageFromFile(commitCommand2.getLogMessageFromFile());
        commitCommand.setNoModuleProgram(commitCommand2.isNoModuleProgram());
        commitCommand.setToRevisionOrBranch(commitCommand2.getToRevisionOrBranch());
        commitCommand.setDisplayName(commitCommand2.getDisplayName());
    }

    public static void addCommit(ExecutorGroup executorGroup, CommitSettings commitSettings) {
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        CommitSettings.CommitFile[] commitFileArray = commitSettings.getCommitFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        ArrayList arrayList6 = new ArrayList();
        ArrayList<File> arrayList7 = new ArrayList<File>();
        ArrayList arrayList8 = new ArrayList();
        ArrayList<File> arrayList9 = new ArrayList<File>();
        for (int i = 0; i < commitFileArray.length; ++i) {
            int n;
            CommitSettings.CommitFile commitFile = commitFileArray[i];
            if (commitFile.getOptions() == CommitOptions.EXCLUDE) continue;
            if (commitFile.getOptions() == CommitOptions.ADD_TEXT) {
                arrayList2.add(commitFile.getNode().getFile());
            } else if (commitFile.getOptions() == CommitOptions.ADD_BINARY) {
                arrayList7.add(commitFile.getNode().getFile());
            } else if (commitFile.getOptions() == CommitOptions.COMMIT_REMOVE && (n = fileStatusCache.getStatus(commitFile.getNode().getFile()).getStatus()) == 2048) {
                arrayList9.add(commitFile.getNode().getFile());
            }
            arrayList.add(commitFile.getNode().getFile());
        }
        executorGroup.addExecutors(CommitAction.createAdd(arrayList2, null));
        executorGroup.addExecutors(CommitAction.createAdd(arrayList3, KeywordSubstitutionOptions.DEFAULT));
        executorGroup.addExecutors(CommitAction.createAdd(arrayList4, KeywordSubstitutionOptions.DEFAULT_LOCKER));
        executorGroup.addExecutors(CommitAction.createAdd(arrayList5, KeywordSubstitutionOptions.ONLY_KEYWORDS));
        executorGroup.addExecutors(CommitAction.createAdd(arrayList6, KeywordSubstitutionOptions.OLD_VALUES));
        executorGroup.addExecutors(CommitAction.createAdd(arrayList7, KeywordSubstitutionOptions.BINARY));
        executorGroup.addExecutors(CommitAction.createAdd(arrayList8, KeywordSubstitutionOptions.ONLY_VALUES));
        executorGroup.addExecutors(CommitAction.createRemove(arrayList9));
        executorGroup.addExecutors(CommitAction.createCommit(arrayList, commitSettings.getCommitMessage()));
    }

    private static ExecutorSupport[] createCommit(List list, String string) {
        if (list.size() == 0) {
            return null;
        }
        CommitCommand commitCommand = new CommitCommand();
        commitCommand.setFiles(list.toArray(new File[list.size()]));
        commitCommand.setMessage(string);
        return CommitExecutor.splitCommand(commitCommand, CvsVersioningSystem.getInstance(), null);
    }

    private static ExecutorSupport[] createRemove(List list) {
        if (list.size() == 0) {
            return null;
        }
        RemoveCommand removeCommand = new RemoveCommand();
        removeCommand.setFiles(list.toArray(new File[list.size()]));
        return RemoveExecutor.splitCommand(removeCommand, CvsVersioningSystem.getInstance(), null);
    }

    private static ExecutorSupport[] createAdd(List list, KeywordSubstitutionOptions keywordSubstitutionOptions) {
        if (list.size() == 0) {
            return null;
        }
        AddCommand addCommand = new AddCommand();
        addCommand.setFiles(list.toArray(new File[list.size()]));
        addCommand.setKeywordSubst(keywordSubstitutionOptions);
        return AddExecutor.splitCommand(addCommand, CvsVersioningSystem.getInstance(), null);
    }
}

