/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.command.commit.CommitInformation;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CommitExecutor
extends ExecutorSupport {
    private Set refreshedFiles;

    public static CommitExecutor[] splitCommand(CommitCommand commitCommand, CvsVersioningSystem cvsVersioningSystem, GlobalOptions globalOptions) {
        Command[] commandArray = new Command[]{};
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)CommitExecutor.class);
        if (commitCommand.getDisplayName() == null) {
            commitCommand.setDisplayName(resourceBundle.getString("MSG_CommitExecutor_CmdDisplayName"));
        }
        try {
            commandArray = CommitExecutor.prepareBasicCommand((BasicCommand)commitCommand);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        CommitExecutor[] commitExecutorArray = new CommitExecutor[commandArray.length];
        for (int i = 0; i < commandArray.length; ++i) {
            Command command = commandArray[i];
            commitExecutorArray[i] = new CommitExecutor(cvsVersioningSystem, (CommitCommand)command, globalOptions);
        }
        return commitExecutorArray;
    }

    private CommitExecutor(CvsVersioningSystem cvsVersioningSystem, CommitCommand commitCommand, GlobalOptions globalOptions) {
        super(cvsVersioningSystem, (Command)commitCommand, globalOptions);
    }

    protected void commandFinished(ClientRuntime.Result result) {
        CommitCommand commitCommand = (CommitCommand)this.cmd;
        this.refreshedFiles = new HashSet(this.toRefresh.size());
        File[] fileArray = this.toRefresh.iterator();
        while (fileArray.hasNext()) {
            CommitInformation commitInformation = (CommitInformation)fileArray.next();
            if (commitInformation.getFile() == null) continue;
            int n = 0;
            String string = commitInformation.getType();
            if ("Changed".equals(string) || "Added".equals(string)) {
                n = 65536;
            } else if ("Removed".equals(string) || "To-be-added".equals(string)) {
                n = 0;
            }
            this.cache.refreshCached(commitInformation.getFile(), n);
            this.refreshedFiles.add(commitInformation.getFile());
        }
        if (this.cmd.hasFailed()) {
            return;
        }
        fileArray = commitCommand.getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.refreshRecursively(fileArray[i]);
            FileObject fileObject = FileUtil.toFileObject((File)fileArray[i]);
            if (fileObject == null) continue;
            fileObject.refresh(true);
        }
    }

    private void refreshRecursively(File file) {
        if (this.cvs.isIgnoredFilename(file)) {
            return;
        }
        if (this.refreshedFiles.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.refreshRecursively(fileArray[i]);
            }
            this.cache.refreshCached(file, 0);
        } else if (this.cache.getStatus(file.getParentFile()).getStatus() == 8) {
            this.cache.refreshCached(file, 65536);
        } else {
            this.cache.refreshCached(file, 0);
        }
    }
}

