/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class CommitProjectsAction
extends SystemAction {
    public CommitProjectsAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage((Class)CommitProjectsAction.class, (String)"CTL_MenuItem_CommitProjects");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CommitProjectsAction.class);
    }

    public boolean isEnabled() {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            Project project = projectArray[i];
            if (!Utils.isVersionedProject(project)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CommitProjectsAction.this.async();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void async() {
        Context context;
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)CommitProjectsAction.class);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)CommitProjectsAction.class, (String)"BK1009"));
        try {
            progressHandle.start();
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            context = Utils.getProjectsContext(projectArray);
            if (context.getFiles().length == 0) {
                progressHandle.finish();
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)resourceBundle.getString("MSG_NoProjectFiles_Prompt"));
                message.setTitle(resourceBundle.getString("MSG_NoProjectFiles_Title"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
        }
        finally {
            progressHandle.finish();
        }
        CommitAction.invokeCommit(resourceBundle.getString("CTL_DialogTitle_AllProjects"), context, NbBundle.getMessage((Class)CommitProjectsAction.class, (String)"CTL_MenuItem_CommitProjectsRunning"));
    }
}

