/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitOptions;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitTable;
import org.netbeans.modules.versioning.system.cvss.ui.components.KTextArea;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.awt.Mnemonics;

public class CommitSettings
extends JPanel
implements PropertyChangeListener,
TableModelListener {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_STICKY = "sticky";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_ACTION = "action";
    static final String COLUMN_NAME_PATH = "path";
    static final Object EVENT_SETTINGS_CHANGED = new Object();
    private CommitTable commitTable;
    private JCheckBox cbLocally;
    private JCheckBox cbRevision;
    private JLabel errorLabel;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private KTextArea taMessage;
    private JTextField tfRevision;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public CommitSettings() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(dimension.width / 2, dimension.height / 5 * 2));
        this.init();
    }

    void setColumns(String[] stringArray) {
        this.commitTable.setColumns(stringArray);
    }

    void setNodes(CvsFileNode[] cvsFileNodeArray) {
        this.commitTable.setNodes(cvsFileNodeArray);
    }

    public String getCommitMessage() {
        return this.taMessage.getText();
    }

    public void addNotify() {
        super.addNotify();
        CvsModuleConfig.getDefault().addPropertyChangeListener(this);
        this.commitTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        this.taMessage.selectAll();
    }

    public void removeNotify() {
        this.commitTable.getTableModel().removeTableModelListener(this);
        CvsModuleConfig.getDefault().removePropertyChangeListener(this);
        super.removeNotify();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("commitExclusions".equals(propertyChangeEvent.getPropertyName())) {
            this.commitTable.dataChanged();
            this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        }
    }

    public CommitFile[] getCommitFiles() {
        return this.commitTable.getCommitFiles();
    }

    private void init() {
        this.initComponents();
        this.errorLabel.setMinimumSize(new JLabel("Layout placeholder").getPreferredSize());
        this.errorLabel.setText("");
        this.jScrollPane1.setMinimumSize(this.jScrollPane1.getPreferredSize());
        this.commitTable = new CommitTable(this.jLabel3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.commitTable.getComponent(), gridBagConstraints);
    }

    void setErrorLabel(String string) {
        this.errorLabel.setText(string);
    }

    public void setCommand(CommitCommand commitCommand) {
        this.taMessage.setText(commitCommand.getMessage());
        if (commitCommand.getToRevisionOrBranch() != null) {
            this.tfRevision.setText(commitCommand.getToRevisionOrBranch());
            this.cbRevision.setSelected(true);
        } else {
            this.cbRevision.setSelected(false);
        }
        this.cbLocally.setSelected(!commitCommand.isRecursive());
    }

    public void updateCommand(CommitCommand commitCommand) {
        commitCommand.setMessage(this.taMessage.getText());
        commitCommand.setRecursive(!this.cbLocally.isSelected());
        if (this.cbRevision.isSelected()) {
            commitCommand.setToRevisionOrBranch(this.tfRevision.getText());
        } else {
            commitCommand.setToRevisionOrBranch(null);
        }
    }

    private void initComponents() {
        this.cbLocally = new JCheckBox();
        this.cbRevision = new JCheckBox();
        this.tfRevision = new JTextField();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taMessage = new KTextArea();
        this.jLabel3 = new JLabel();
        this.errorLabel = new JLabel();
        this.cbLocally.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/commit/Bundle").getString("MNE_CommitForm_Locally").charAt(0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbLocally, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/commit/Bundle").getString("CTL_CommitForm_Locally"));
        this.cbRevision.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/commit/Bundle").getString("MNE_CommitForm_Revision").charAt(0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbRevision, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/commit/Bundle").getString("CTL_CommitForm_Revision"));
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.jLabel2.setLabelFor(this.taMessage);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/commit/Bundle").getString("CTL_CommitForm_Message"));
        this.jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.taMessage.setColumns(30);
        this.taMessage.setLineWrap(true);
        this.taMessage.setRows(6);
        this.taMessage.setTabSize(4);
        this.taMessage.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.taMessage);
        this.taMessage.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/commit/Bundle").getString("TT_CommitForm_Message"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/commit/Bundle").getString("CTL_CommitForm_FilesToCommit"));
        this.jLabel3.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.errorLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.errorLabel, gridBagConstraints);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }

    public static class CommitFile {
        private final CommitOptions options;
        private final CvsFileNode node;

        public CommitFile(CvsFileNode cvsFileNode, CommitOptions commitOptions) {
            this.node = cvsFileNode;
            this.options = commitOptions;
        }

        public CommitOptions getOptions() {
            return this.options;
        }

        public CvsFileNode getNode() {
            return this.node;
        }
    }
}

