/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DiffMainPanel
extends JPanel
implements ActionListener,
VersioningListener,
DiffSetupSource {
    private Setup[] setups;
    private final Context context;
    private int displayStatuses;
    private final String contextName;
    private int currentType;
    private int currentDifferenceIndex;
    private int currentIndex = -1;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private static final RequestProcessor rp = new RequestProcessor("CVS-VersioningView", 1);
    private RequestProcessor.Task refreshTask;
    private ExecutorGroup group;
    private volatile boolean executed;
    private JComponent diffView;
    private JToggleButton allToggle;
    private JButton commitButton;
    private JToolBar controlsToolbar;
    private JPanel jPanel1;
    private JToggleButton localToggle;
    private JComboBox navigationCombo;
    private JButton nextButton;
    private JButton prevButton;
    private JButton refreshButton;
    private JToggleButton remoteToggle;
    private JButton updateButton;

    public DiffMainPanel(Context context, int n, String string, ExecutorGroup executorGroup) {
        this.context = context;
        this.contextName = string;
        this.group = executorGroup;
        this.currentType = n;
        this.initComponents();
        this.setupComponents();
        this.refreshSetups();
        this.refreshComponents();
        this.refreshTask = rp.create((Runnable)new RefreshViewTask());
    }

    public DiffMainPanel(File file, String string, String string2) {
        this.context = null;
        this.contextName = file.getName();
        this.initComponents();
        this.setupComponents();
        this.localToggle.setVisible(false);
        this.remoteToggle.setVisible(false);
        this.allToggle.setVisible(false);
        this.navigationCombo.setVisible(false);
        this.refreshButton.setVisible(false);
        this.updateButton.setVisible(false);
        this.commitButton.setVisible(false);
        this.setups = new Setup[]{new Setup(file, string, string2)};
        this.setDiffIndex(0, 0);
        this.dpt = new DiffPrepareTask(this.setups);
        this.prepareTask = RequestProcessor.getDefault().post((Runnable)this.dpt);
    }

    void componentClosed() {
        this.setups = null;
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
    }

    public synchronized void setGroup(ExecutorGroup executorGroup) {
        this.group = executorGroup;
        if (this.executed) {
            executorGroup.executed();
        }
    }

    void requestActive() {
        if (this.diffView != null) {
            this.diffView.requestFocusInWindow();
        }
    }

    private void setupComponents() {
        this.controlsToolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.controlsToolbar.setLayout(new ToolbarLayout());
        this.navigationCombo.addActionListener(this);
        this.navigationCombo.setRenderer(new ColoredComboRenderer());
        this.refreshButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.commitButton.addActionListener(this);
        this.localToggle.addActionListener(this);
        this.remoteToggle.addActionListener(this);
        this.allToggle.addActionListener(this);
        this.refreshButton.setToolTipText(NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_RefreshDiff_Tooltip"));
        this.updateButton.setToolTipText(NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_UpdateDiff_Tooltip", (Object)this.contextName));
        this.commitButton.setToolTipText(NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_CommitDiff_Tooltip", (Object)this.contextName));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.localToggle);
        buttonGroup.add(this.remoteToggle);
        buttonGroup.add(this.allToggle);
        if (this.currentType == 0) {
            this.localToggle.setSelected(true);
        } else if (this.currentType == 1) {
            this.remoteToggle.setSelected(true);
        } else if (this.currentType == 2) {
            this.allToggle.setSelected(true);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DiffMainPanel.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DiffMainPanel.this.onPrevButton();
            }
        };
        this.nextButton.setAction(this.nextAction);
        this.prevButton.setAction(this.prevAction);
    }

    private void refreshComponents() {
        DiffView diffView;
        DiffView diffView2 = diffView = this.setups != null ? this.setups[this.currentIndex].getView() : null;
        if (diffView != null) {
            this.nextAction.setEnabled(this.currentIndex < this.setups.length - 1 || this.currentDifferenceIndex < diffView.getDifferenceCount() - 1);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(this.currentIndex > 0 || this.currentDifferenceIndex > 0);
    }

    public void addNotify() {
        super.addNotify();
        if (this.refreshTask != null) {
            CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
        }
        JComponent jComponent = (JComponent)this.getParent();
        jComponent.getActionMap().put("jumpNext", this.nextAction);
        jComponent.getActionMap().put("jumpPrev", this.prevAction);
    }

    public void removeNotify() {
        CvsVersioningSystem.getInstance().getStatusCache().removeVersioningListener(this);
        super.removeNotify();
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            if (!this.affectsView(versioningEvent)) {
                return;
            }
            if (CvsVersioningSystem.getInstance().getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) != null) {
                this.refreshTask.schedule(1000);
            } else {
                this.refreshTask.schedule(200);
            }
        } else if (versioningEvent.getId() == CvsVersioningSystem.EVENT_PARAM_CHANGED && versioningEvent.getParams()[0].equals(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) && CvsVersioningSystem.getInstance().getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) == null) {
            this.refreshTask.schedule(0);
        }
    }

    private boolean affectsView(VersioningEvent versioningEvent) {
        File file = (File)versioningEvent.getParams()[0];
        FileInformation fileInformation = (FileInformation)versioningEvent.getParams()[1];
        FileInformation fileInformation2 = (FileInformation)versioningEvent.getParams()[2];
        if (fileInformation == null ? (fileInformation2.getStatus() & this.displayStatuses) == 0 : (fileInformation.getStatus() & this.displayStatuses) + (fileInformation2.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        return this.context.contains(file);
    }

    private void setDiffIndex(int n, int n2) {
        File file;
        this.currentIndex = n;
        DiffView diffView = this.setups[this.currentIndex].getView();
        TopComponent topComponent = (TopComponent)this.getClientProperty(TopComponent.class);
        if (topComponent != null) {
            FileObject fileObject;
            Node node = Node.EMPTY;
            file = this.setups[this.currentIndex].getBaseFile();
            if (file != null && (fileObject = FileUtil.toFileObject((File)file)) != null) {
                node = new AbstractNode(Children.LEAF, Lookups.singleton((Object)fileObject));
            }
            topComponent.setActivatedNodes(new Node[]{node});
        }
        boolean bl = false;
        this.removeDiffComponent();
        if (diffView != null) {
            if (n2 == -1) {
                n2 = diffView.getDifferenceCount() - 1;
            }
            if (n2 >= 0 && n2 < diffView.getDifferenceCount()) {
                diffView.setCurrentDifference(n2);
            }
            this.diffView = (JComponent)diffView.getComponent();
            this.diffView.getActionMap().put("jumpNext", this.nextAction);
            this.diffView.getActionMap().put("jumpPrev", this.prevAction);
            file = WindowManager.getDefault().getRegistry().getActivated();
            if (SwingUtilities.isDescendingFrom(this, (Component)((Object)file))) {
                bl = true;
            }
        } else {
            this.diffView = new SourcesUnavailableComponent(NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_DiffPanel_NoContent"));
        }
        this.add(this.diffView);
        this.currentDifferenceIndex = n2;
        if (this.navigationCombo.isVisible()) {
            this.navigationCombo.setSelectedIndex(this.currentIndex);
        }
        this.refreshComponents();
        this.revalidate();
        this.repaint();
        if (bl) {
            this.diffView.requestFocusInWindow();
        }
    }

    private void removeDiffComponent() {
        if (this.diffView != null) {
            this.remove(this.diffView);
            this.diffView = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.navigationCombo) {
            this.onNavigationCombo();
        } else if (object == this.refreshButton) {
            this.onRefreshButton();
        } else if (object == this.updateButton) {
            this.onUpdateButton();
        } else if (object == this.commitButton) {
            this.onCommitButton();
        } else if (object == this.localToggle || object == this.remoteToggle || object == this.allToggle) {
            this.onDiffTypeChanged();
        }
    }

    private void onRefreshButton() {
        LifecycleManager.getDefault().saveAll();
        this.refreshSetups();
        this.executeUpdateCommand(true);
    }

    private void onUpdateButton() {
        this.executeUpdateCommand(false);
    }

    private void onCommitButton() {
        CommitAction.invokeCommit(this.contextName, this.context, null);
    }

    private void executeUpdateCommand(boolean bl) {
        if (this.context == null || this.context.getRoots().size() == 0) {
            return;
        }
        UpdateCommand updateCommand = new UpdateCommand();
        String string = bl ? NbBundle.getMessage((Class)DiffMainPanel.class, (String)"BK0001") : NbBundle.getMessage((Class)DiffMainPanel.class, (String)"BK0002");
        updateCommand.setDisplayName(string);
        GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
        if (this.context.getExclusions().size() > 0) {
            globalOptions.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
        }
        updateCommand.setFiles(this.context.getRootFiles());
        updateCommand.setBuildDirectories(true);
        updateCommand.setPruneDirectories(true);
        globalOptions.setDoNoChanges(bl);
        ExecutorGroup executorGroup = new ExecutorGroup(string);
        executorGroup.addExecutors(UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), globalOptions));
        executorGroup.execute();
    }

    private void onNextButton() {
        DiffView diffView;
        if (this.navigationCombo.isVisible()) {
            this.currentIndex = this.navigationCombo.getSelectedIndex();
        }
        if ((diffView = this.setups[this.currentIndex].getView()) != null) {
            int n = diffView.getCurrentDifference();
            if (n < diffView.getDifferenceCount() - 1) {
                this.currentDifferenceIndex = Math.max(this.currentDifferenceIndex, n);
            }
            if (++this.currentDifferenceIndex >= diffView.getDifferenceCount()) {
                if (++this.currentIndex >= this.setups.length) {
                    --this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, 0);
                }
            } else {
                diffView.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.setups.length) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, 0);
        }
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffView diffView = this.setups[this.currentIndex].getView();
        if (diffView != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    ++this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, -1);
                }
            } else {
                diffView.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.setups.length - 1;
            }
            this.setDiffIndex(this.currentIndex, -1);
        }
        this.refreshComponents();
    }

    private void onNavigationCombo() {
        int n = this.navigationCombo.getSelectedIndex();
        if (n != this.currentIndex) {
            this.setDiffIndex(n, 0);
        }
    }

    public Collection getSetups() {
        if (this.setups == null) {
            return Collections.EMPTY_SET;
        }
        return Arrays.asList(this.setups);
    }

    public String getSetupDisplayName() {
        return this.contextName;
    }

    private void refreshSetups() {
        Serializable serializable;
        if (this.dpt != null) {
            this.prepareTask.cancel();
        }
        switch (this.currentType) {
            case 0: {
                this.displayStatuses = 6612;
                break;
            }
            case 1: {
                this.displayStatuses = 1696;
                break;
            }
            case 2: {
                this.displayStatuses = 8180;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
            }
        }
        File[] fileArray = DiffExecutor.getModifiedFiles(this.context, this.displayStatuses);
        Setup[] setupArray = new Setup[fileArray.length];
        for (int i = 0; i < setupArray.length; ++i) {
            serializable = fileArray[i];
            setupArray[i] = new Setup((File)serializable, this.currentType);
        }
        Arrays.sort(setupArray, new SetupsComparator());
        this.setups = setupArray;
        this.navigationCombo.setModel(new DefaultComboBoxModel<Setup>(this.setups));
        if (this.setups.length == 0) {
            String string;
            switch (this.currentType) {
                case 0: {
                    string = NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_DiffPanel_NoLocalChanges");
                    break;
                }
                case 1: {
                    string = NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_DiffPanel_NoRemoteChanges");
                    break;
                }
                case 2: {
                    string = NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_DiffPanel_NoAllChanges");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
                }
            }
            this.setups = null;
            this.navigationCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{string}));
            this.navigationCombo.setEnabled(false);
            this.navigationCombo.setPreferredSize(null);
            serializable = this.navigationCombo.getPreferredSize();
            this.navigationCombo.setPreferredSize(new Dimension(((Dimension)serializable).width + 1, ((Dimension)serializable).height));
            this.removeDiffComponent();
            this.diffView = new SourcesUnavailableComponent(string);
            this.add(this.diffView);
            this.nextAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.revalidate();
            this.repaint();
            this.executed();
        } else {
            this.navigationCombo.setEnabled(true);
            this.navigationCombo.setPreferredSize(null);
            Dimension dimension = this.navigationCombo.getPreferredSize();
            this.navigationCombo.setPreferredSize(new Dimension(dimension.width + 1, dimension.height));
            this.setDiffIndex(0, 0);
            this.dpt = new DiffPrepareTask(this.setups);
            this.prepareTask = RequestProcessor.getDefault().post((Runnable)this.dpt);
        }
    }

    private void onDiffTypeChanged() {
        if (this.localToggle.isSelected()) {
            if (this.currentType == 0) {
                return;
            }
            this.currentType = 0;
        } else if (this.remoteToggle.isSelected()) {
            if (this.currentType == 1) {
                return;
            }
            this.currentType = 1;
        } else if (this.allToggle.isSelected()) {
            if (this.currentType == 2) {
                return;
            }
            this.currentType = 2;
        }
        this.refreshSetups();
    }

    private void initComponents() {
        this.controlsToolbar = new JToolBar();
        this.allToggle = new JToggleButton();
        this.localToggle = new JToggleButton();
        this.remoteToggle = new JToggleButton();
        this.navigationCombo = new JComboBox();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.jPanel1 = new JPanel();
        this.refreshButton = new JButton();
        this.updateButton = new JButton();
        this.commitButton = new JButton();
        this.setLayout(new BorderLayout());
        this.controlsToolbar.setFloatable(false);
        this.allToggle.setText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_All"));
        this.allToggle.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_All_Tooltip"));
        this.controlsToolbar.add(this.allToggle);
        this.localToggle.setText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Local"));
        this.localToggle.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Local_Tooltip"));
        this.controlsToolbar.add(this.localToggle);
        this.remoteToggle.setText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Remote"));
        this.remoteToggle.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Remote_Tooltip"));
        this.controlsToolbar.add(this.remoteToggle);
        this.controlsToolbar.add(this.navigationCombo);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png")));
        this.nextButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
        this.nextButton.setEnabled(false);
        this.controlsToolbar.add(this.nextButton);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png")));
        this.prevButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
        this.prevButton.setEnabled(false);
        this.controlsToolbar.add(this.prevButton);
        this.jPanel1.setMaximumSize(new Dimension(15, 1));
        this.jPanel1.setPreferredSize(new Dimension(15, 1));
        this.controlsToolbar.add(this.jPanel1);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/refresh.png")));
        this.refreshButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
        this.controlsToolbar.add(this.refreshButton);
        this.updateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/update.png")));
        this.updateButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
        this.controlsToolbar.add(this.updateButton);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/commit.png")));
        this.commitButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
        this.controlsToolbar.add(this.commitButton);
        this.add((Component)this.controlsToolbar, "North");
    }

    private synchronized void executed() {
        if (this.group != null) {
            this.group.executed();
        } else {
            this.executed = true;
        }
    }

    static /* synthetic */ int access$900(DiffMainPanel diffMainPanel) {
        return diffMainPanel.currentIndex;
    }

    static /* synthetic */ void access$1000(DiffMainPanel diffMainPanel, int n, int n2) {
        diffMainPanel.setDiffIndex(n, n2);
    }

    static /* synthetic */ void access$1300(DiffMainPanel diffMainPanel) {
        diffMainPanel.refreshSetups();
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ RefreshViewTask this$1;
                {
                    this.this$1 = refreshViewTask;
                }

                public void run() {
                    DiffMainPanel.access$1300(RefreshViewTask.access$1200(this.this$1));
                }
            });
        }

        static /* synthetic */ DiffMainPanel access$1200(RefreshViewTask refreshViewTask) {
            return refreshViewTask.DiffMainPanel.this;
        }
    }

    private static class SetupsComparator
    extends Utils.ByImportanceComparator {
        private FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();

        public int compare(Object object, Object object2) {
            File file = ((Setup)object).getBaseFile();
            File file2 = ((Setup)object2).getBaseFile();
            int n = super.compare(this.cache.getStatus(file), this.cache.getStatus(file2));
            if (n == 0) {
                return file.getName().compareToIgnoreCase(file2.getName());
            }
            return n;
        }
    }

    private class ToolbarLayout
    implements LayoutManager {
        private int TOOLBAR_HEIGHT_ADJUSTMENT = 10;
        private int TOOLBAR_SEPARATOR_MIN_WIDTH = 12;
        private int toolbarHeight = -1;
        private Dimension parentSize;
        private Set adjusted = new HashSet();

        private ToolbarLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            Rectangle[] rectangleArray = this.layout(container);
            for (int i = 0; i < rectangleArray.length; ++i) {
                JComponent jComponent = (JComponent)container.getComponent(i);
                if (!jComponent.isVisible()) continue;
                jComponent.setBounds(rectangleArray[i]);
            }
        }

        private Rectangle[] layout(Container container) {
            Dimension dimension = DiffMainPanel.this.getSize();
            Dimension dimension2 = container.getSize();
            int n = 0;
            int n2 = 0;
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            int n3 = container.getComponentCount();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                Rectangle rectangle = new Rectangle();
                JComponent jComponent = (JComponent)container.getComponent(i);
                if (jComponent.isVisible()) {
                    rectangle.setLocation(n4, n);
                    if (jComponent instanceof AbstractButton) {
                        this.adjustToobarButton((AbstractButton)jComponent);
                    } else {
                        this.adjustToolbarComponentSize(jComponent);
                    }
                    Dimension dimension3 = jComponent.getPreferredSize();
                    int n5 = dimension3.width;
                    if (jComponent instanceof JSeparator && dimension.height - dimension.width <= 0) {
                        n5 = Math.max(n5, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                    }
                    int n6 = this.getToolbarHeight(dimension) - 1;
                    n2 = Math.max(n2, n6);
                    rectangle.setSize(n5, n6);
                    if ((n4 += n5) > dimension2.width) {
                        n += n2 + 2;
                        n4 = 0;
                        n2 = 0;
                    }
                }
                arrayList.add(rectangle);
            }
            return arrayList.toArray(new Rectangle[arrayList.size()]);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = DiffMainPanel.this.getSize();
            int n = this.getToolbarHeight(dimension);
            int n2 = container.getComponentCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                if (component instanceof AbstractButton) {
                    this.adjustToobarButton((AbstractButton)component);
                } else {
                    this.adjustToolbarComponentSize((JComponent)component);
                }
                Dimension dimension2 = component.getPreferredSize();
                int n4 = dimension2.width;
                if (component instanceof JSeparator && dimension.height - dimension.width <= 0) {
                    n4 = Math.max(n4, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                n3 += n4;
            }
            return new Dimension(n3, n);
        }

        public Dimension preferredLayoutSize(Container container) {
            Rectangle[] rectangleArray = this.layout(container);
            Rectangle rectangle = new Rectangle();
            for (int i = 0; i < rectangleArray.length; ++i) {
                rectangle.add(rectangleArray[i]);
            }
            return new Dimension(rectangle.width, rectangle.height);
        }

        private int getToolbarHeight(Dimension dimension) {
            if (this.parentSize == null || !this.parentSize.equals(dimension)) {
                this.parentSize = dimension;
                this.toolbarHeight = -1;
            }
            if (this.toolbarHeight == -1) {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 10);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
                int n = 0;
                String[] stringArray = new String[]{"Label.font", "Button.font", "ToggleButton.font"};
                for (int i = 0; i < stringArray.length; ++i) {
                    Font font = uIDefaults.getFont(stringArray[i]);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
                    n = Math.max(n, fontMetrics.getHeight());
                }
                this.toolbarHeight = n + this.TOOLBAR_HEIGHT_ADJUSTMENT;
            }
            return this.toolbarHeight;
        }

        private void adjustToobarButton(AbstractButton abstractButton) {
            if (this.adjusted.contains(abstractButton)) {
                return;
            }
            if (!(abstractButton instanceof JToggleButton)) {
                abstractButton.setContentAreaFilled(false);
                abstractButton.setMargin(new Insets(0, 3, 0, 3));
                abstractButton.setBorderPainted(false);
                abstractButton.addMouseListener(new MouseAdapter(this, abstractButton){
                    private final /* synthetic */ AbstractButton val$button;
                    private final /* synthetic */ ToolbarLayout this$1;
                    {
                        this.this$1 = toolbarLayout;
                        this.val$button = abstractButton;
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                        this.val$button.setContentAreaFilled(true);
                        this.val$button.setBorderPainted(true);
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        this.val$button.setContentAreaFilled(false);
                        this.val$button.setBorderPainted(false);
                    }
                });
            }
            this.adjustToolbarComponentSize(abstractButton);
        }

        private void adjustToolbarComponentSize(JComponent jComponent) {
            if (this.adjusted.contains(jComponent)) {
                return;
            }
            if (jComponent.getBorder() instanceof CompoundBorder) {
                Dimension dimension = jComponent.getPreferredSize();
                if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                    dimension.width += 9;
                }
                jComponent.setPreferredSize(dimension);
            }
            this.adjusted.add(jComponent);
        }
    }

    private static class SourcesUnavailableComponent
    extends JComponent {
        public SourcesUnavailableComponent(String string) {
            JLabel jLabel = new JLabel(string);
            this.setLayout(new BorderLayout());
            jLabel.setHorizontalAlignment(0);
            this.add((Component)jLabel, "Center");
        }
    }

    private class DiffPrepareTask
    implements Runnable {
        private final Setup[] prepareSetups;

        public DiffPrepareTask(Setup[] setupArray) {
            this.prepareSetups = setupArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Diff diff = Diff.getDefault();
            try {
                for (int i = 0; i < this.prepareSetups.length; ++i) {
                    if (this.prepareSetups != DiffMainPanel.this.setups) {
                        return;
                    }
                    try {
                        this.prepareSetups[i].initSources(DiffMainPanel.this.group);
                        int n = i;
                        StreamSource streamSource = this.prepareSetups[n].getFirstSource();
                        StreamSource streamSource2 = this.prepareSetups[n].getSecondSource();
                        DiffView diffView = diff.createDiff(streamSource, streamSource2);
                        SwingUtilities.invokeLater(new Runnable(this, n, diffView){
                            private final /* synthetic */ int val$fi;
                            private final /* synthetic */ DiffView val$view;
                            private final /* synthetic */ DiffPrepareTask this$1;
                            {
                                this.this$1 = diffPrepareTask;
                                this.val$fi = n;
                                this.val$view = diffView;
                            }

                            public void run() {
                                DiffPrepareTask.access$700(this.this$1)[this.val$fi].setView(this.val$view);
                                if (DiffPrepareTask.access$700(this.this$1) != DiffMainPanel.access$500(DiffPrepareTask.access$800(this.this$1))) {
                                    return;
                                }
                                if (DiffMainPanel.access$900(DiffPrepareTask.access$800(this.this$1)) == this.val$fi) {
                                    DiffMainPanel.access$1000(DiffPrepareTask.access$800(this.this$1), this.val$fi, 0);
                                }
                            }
                        });
                        continue;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
            finally {
                DiffMainPanel.this.executed();
            }
        }

        static /* synthetic */ Setup[] access$700(DiffPrepareTask diffPrepareTask) {
            return diffPrepareTask.prepareSetups;
        }

        static /* synthetic */ DiffMainPanel access$800(DiffPrepareTask diffPrepareTask) {
            return diffPrepareTask.DiffMainPanel.this;
        }
    }

    private static class ColoredComboRenderer
    extends BasicComboBoxRenderer {
        private ColoredComboRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                object = ((Setup)object).getBaseFile().getName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

