/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class DiffProjectsAction
extends SystemAction {
    public DiffProjectsAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage((Class)DiffProjectsAction.class, (String)"CTL_MenuItem_DiffProjects");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DiffProjectsAction.class);
    }

    public boolean isEnabled() {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            Project project = projectArray[i];
            if (!Utils.isVersionedProject(project)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                DiffProjectsAction.this.async();
            }
        });
    }

    private void async() {
        final ExecutorGroup executorGroup = new ExecutorGroup(NbBundle.getMessage((Class)DiffProjectsAction.class, (String)"CTL_MenuItem_DiffProjectsRunning"));
        executorGroup.progress(NbBundle.getMessage((Class)DiffProjectsAction.class, (String)"BK2001"));
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        final Context context = Utils.getProjectsContext(projectArray);
        final ResourceBundle resourceBundle = NbBundle.getBundle((Class)DiffProjectsAction.class);
        if (context.getFiles().length == 0) {
            executorGroup.executed();
            JOptionPane.showMessageDialog(null, resourceBundle.getString("MSG_NoProjectFiles_Prompt"), resourceBundle.getString("MSG_NoProjectFiles_Title"), 1);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = resourceBundle.getString("CTL_DialogTitle_DiffProjects");
                DiffExecutor diffExecutor = new DiffExecutor(context, string);
                diffExecutor.showLocalDiff(executorGroup);
            }
        });
    }
}

