/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.diff.EncodedReaderFactory;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class DiffStreamSource
extends StreamSource {
    private final File baseFile;
    private final String revision;
    private final String title;
    private String mimeType;
    private IOException failure;
    private File remoteFile;
    private boolean binary;
    private ExecutorGroup group;

    public DiffStreamSource(File file, String string, String string2) {
        this.baseFile = file;
        this.revision = string;
        this.title = string2;
    }

    public String getName() {
        return this.baseFile.getName();
    }

    public String getTitle() {
        return this.title;
    }

    public void setGroup(ExecutorGroup executorGroup) {
        this.group = executorGroup;
    }

    public String getMIMEType() {
        try {
            this.init(null);
        }
        catch (IOException iOException) {
            return null;
        }
        return this.mimeType;
    }

    public Reader createReader() throws IOException {
        this.init(null);
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (this.binary) {
            return new StringReader(NbBundle.getMessage((Class)DiffStreamSource.class, (String)"BK5001", (Object)this.getTitle()));
        }
        return EncodedReaderFactory.getDefault().getReader(this.remoteFile, this.mimeType);
    }

    public Writer createWriter(Difference[] differenceArray) throws IOException {
        throw new IOException("Operation not supported");
    }

    synchronized void init(ExecutorGroup executorGroup) throws IOException {
        if (this.remoteFile != null || this.revision == null) {
            return;
        }
        this.binary = !CvsVersioningSystem.getInstance().isText(this.baseFile);
        try {
            this.remoteFile = VersionsCache.getInstance().getRemoteFile(this.baseFile, this.revision, executorGroup);
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.binary = !CvsVersioningSystem.getInstance().isText(this.remoteFile);
            }
            this.failure = null;
        }
        catch (Exception exception) {
            this.failure = new IOException("Cannot initialize stream source");
            this.failure.initCause(exception);
            throw this.failure;
        }
        FileObject fileObject = FileUtil.toFileObject((File)this.baseFile);
        if (fileObject == null && this.remoteFile != null) {
            fileObject = FileUtil.toFileObject((File)this.remoteFile);
        }
        this.mimeType = fileObject != null ? fileObject.getMIMEType() : (this.binary ? "application/octet-stream" : "text/plain");
    }
}

