/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffStreamSource;
import org.openide.util.NbBundle;

public final class Setup {
    public static final int DIFFTYPE_LOCAL = 0;
    public static final int DIFFTYPE_REMOTE = 1;
    public static final int DIFFTYPE_ALL = 2;
    public static final String REVISION_CURRENT = "";
    public static final String REVISION_HEAD = "HEAD";
    private final File baseFile;
    private final String firstRevision;
    private final String secondRevision;
    private DiffStreamSource firstSource;
    private DiffStreamSource secondSource;
    private DiffView view;
    private String title;

    public Setup(File file, int n) {
        String string;
        String string2;
        String string3;
        this.baseFile = file;
        FileInformation fileInformation = CvsVersioningSystem.getInstance().getStatusCache().getStatus(file);
        int n2 = fileInformation.getStatus();
        Entry entry = fileInformation.getEntry(file);
        String string4 = string3 = entry != null ? entry.getRevision() : null;
        if (string3 != null && string3.charAt(0) == '-') {
            string3 = string3.substring(1);
        }
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)Setup.class);
        if (n == 2 && n2 == 128) {
            this.firstRevision = REVISION_HEAD;
            string2 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_RemoteModified"), string3);
        } else if (n2 == 4 || n2 == 4096 || n2 == 512) {
            this.firstRevision = null;
            string2 = resourceBundle.getString("MSG_DiffPanel_NoBaseRevision");
        } else {
            this.firstRevision = string3;
            string2 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_BaseRevision"), string3);
        }
        if (n2 == 64) {
            this.secondRevision = REVISION_CURRENT;
            string = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_LocalConflict"), string3);
        } else if (n2 == 4 || n2 == 4096) {
            this.secondRevision = REVISION_CURRENT;
            string = resourceBundle.getString("MSG_DiffPanel_LocalNew");
        } else if (n2 == 2048 || n2 == 256) {
            this.secondRevision = null;
            string = resourceBundle.getString("MSG_DiffPanel_LocalDeleted");
        } else if (n2 == 512) {
            this.secondRevision = REVISION_HEAD;
            string = resourceBundle.getString("MSG_DiffPanel_RemoteNew");
        } else if (n2 == 1024) {
            this.secondRevision = null;
            string = resourceBundle.getString("MSG_DiffPanel_RemoteDeleted");
        } else if (n2 == 32) {
            this.secondRevision = REVISION_HEAD;
            string = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_RemoteModified"), string3);
        } else if (n == 1) {
            this.secondRevision = REVISION_HEAD;
            string = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_RemoteModified"), string3);
        } else {
            this.secondRevision = REVISION_CURRENT;
            string = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_LocalModified"), string3);
        }
        this.firstSource = new DiffStreamSource(file, this.firstRevision, string2);
        this.secondSource = new DiffStreamSource(file, this.secondRevision, string);
        this.title = "<html>" + CvsVersioningSystem.getInstance().getAnnotator().annotateNameHtml(file, fileInformation);
    }

    public Setup(File file, String string, String string2) {
        this.baseFile = file;
        this.firstRevision = string;
        this.secondRevision = string2;
        this.firstSource = new DiffStreamSource(file, string, string);
        this.secondSource = new DiffStreamSource(file, string2, string2);
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setView(DiffView diffView) {
        this.view = diffView;
    }

    public DiffView getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    public String toString() {
        return this.title;
    }

    static String getDisplayedRevision(File file, String string) {
        if (string == REVISION_CURRENT) {
            FileInformation fileInformation = CvsVersioningSystem.getInstance().getStatusCache().getStatus(file);
            return NbBundle.getMessage((Class)Setup.class, (String)"MSG_LocalRevision", (Object)fileInformation.getEntry(file).getRevision());
        }
        return string;
    }

    void initSources(ExecutorGroup executorGroup) throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init(executorGroup);
        }
        if (this.secondSource != null) {
            this.secondSource.init(executorGroup);
        }
    }
}

