/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.ignore;

import java.io.File;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.nodes.Node;

public class IgnoreAction
extends AbstractSystemAction {
    public static final int UNDEFINED = 0;
    public static final int IGNORING = 1;
    public static final int UNIGNORING = 2;

    protected String getBaseName(Node[] nodeArray) {
        int n = this.getActionStatus(nodeArray);
        switch (n) {
            case 0: 
            case 1: {
                return "CTL_MenuItem_Ignore";
            }
            case 2: {
                return "CTL_MenuItem_Unignore";
            }
        }
        throw new RuntimeException("Invalid action status: " + n);
    }

    public int getActionStatus(Node[] nodeArray) {
        return this.getActionStatus(Utils.getCurrentContext(nodeArray).getFiles());
    }

    public int getActionStatus(File[] fileArray) {
        int n = -1;
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName().equals(".cvsignore")) {
                n = 0;
                break;
            }
            FileInformation fileInformation = fileStatusCache.getStatus(fileArray[i]);
            if (fileInformation.getStatus() == 4) {
                n = n == -1 || n == 1 ? 1 : 0;
                continue;
            }
            if (fileInformation.getStatus() == 2) {
                n = (n == -1 || n == 2) && this.canBeUnignored(fileArray[i]) ? 2 : 0;
                continue;
            }
            n = 0;
            break;
        }
        return n == -1 ? 0 : n;
    }

    private boolean canBeUnignored(File file) {
        return CvsVersioningSystem.getInstance().isInCvsIgnore(file);
    }

    protected boolean enable(Node[] nodeArray) {
        return this.getActionStatus(nodeArray) != 0;
    }

    public void performCvsAction(Node[] nodeArray) {
        int n = this.getActionStatus(nodeArray);
        if (n == 1) {
            CvsVersioningSystem.getInstance().setIgnored(Utils.getCurrentContext(nodeArray).getFiles());
        } else if (n == 2) {
            CvsVersioningSystem.getInstance().setNotignored(Utils.getCurrentContext(nodeArray).getFiles());
        } else {
            throw new RuntimeException("Invalid action status: " + n);
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

