/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.log;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryTopComponent;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class SearchHistoryAction
extends AbstractSystemAction {
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_SearchHistory";
    }

    protected int getFileEnabledStatus() {
        return 4088;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performCvsAction(Node[] nodeArray) {
        String string = NbBundle.getMessage((Class)SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)this.getContextDisplayName(nodeArray));
        this.openHistory(this.getContext(nodeArray), string);
    }

    private void openHistory(final Context context, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(context);
                searchHistoryTopComponent.setDisplayName(string);
                searchHistoryTopComponent.open();
                searchHistoryTopComponent.requestActive();
                File[] fileArray = context.getFiles();
                if (fileArray.length == 1 && fileArray[0].isFile()) {
                    searchHistoryTopComponent.search();
                }
            }
        });
    }

    public static void openSearch(String string, String string2, String string3, Date date) {
        SearchHistoryAction.openSearch(SearchHistoryAction.getDefaultContext(), string, string2, string3, date);
    }

    public static void openSearch(Context context, String string, String string2, String string3, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        Date date2 = calendar.getTime();
        calendar.setTime(date);
        calendar.add(5, -1);
        Date date3 = calendar.getTime();
        if (string2 != null && string2.indexOf(10) != -1) {
            string2 = string2.substring(0, string2.indexOf(10));
        }
        SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(context, string2, string3, date3, date2);
        String string4 = NbBundle.getMessage((Class)SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)string);
        searchHistoryTopComponent.setDisplayName(string4);
        searchHistoryTopComponent.open();
        searchHistoryTopComponent.requestActive();
        searchHistoryTopComponent.search();
    }

    private static Context getDefaultContext() {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        return Utils.getProjectsContext(projectArray);
    }
}

