/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.project;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.importcmd.ImportCommand;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.executor.CheckoutExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.Kit;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

final class ImportExecutor
extends ExecutorSupport
implements Runnable {
    private final String module;
    private final String cvsRoot;
    private final boolean checkout;
    private final String folder;
    private CheckoutExecutor checkoutExecutor;
    private File checkoutDir;
    private final ExecutorGroup group;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ImportExecutor(ImportCommand importCommand, GlobalOptions globalOptions, boolean bl, String string, ExecutorGroup executorGroup) {
        super(CvsVersioningSystem.getInstance(), (Command)importCommand, globalOptions);
        this.module = importCommand.getModule();
        this.cvsRoot = globalOptions.getCVSRoot();
        this.checkout = bl;
        this.folder = string;
        this.group = executorGroup;
        executorGroup.addExecutor(this);
        if (bl) {
            this.checkoutDir = Kit.createTmpFolder();
            CheckoutAction checkoutAction = (CheckoutAction)SystemAction.get((Class)CheckoutAction.class);
            this.checkoutExecutor = checkoutAction.checkout(this.cvsRoot, this.module, null, this.checkoutDir.getAbsolutePath(), false, executorGroup);
            executorGroup.addBarrier(this);
        }
    }

    protected void commandFinished(ClientRuntime.Result result) {
    }

    public void run() {
        if (this.checkoutExecutor.isSuccessful()) {
            this.copyMetadata();
        }
        Kit.deleteRecursively(this.checkoutDir);
    }

    private void copyMetadata() {
        File file = new File(this.folder);
        File file2 = new File(this.checkoutDir, this.module);
        if (!$assertionsDisabled && !file2.isDirectory()) {
            throw new AssertionError((Object)file2.getAbsolutePath());
        }
        this.copyFolderMeta(file2, file);
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        fileStatusCache.refresh(file, 0);
    }

    private void copyFolderMeta(File file, File file2) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (!file3.isDirectory()) continue;
            if ("CVS".equals(file3.getName())) {
                this.copyCvsMeta(file3, file2);
                continue;
            }
            File file4 = new File(file2, file3.getName());
            if (!file4.isDirectory()) continue;
            this.copyFolderMeta(file3, file4);
        }
    }

    private void copyCvsMeta(File file, File file2) {
        File file3 = new File(file2, "CVS");
        if (!file3.exists() || file3.isDirectory() && file3.listFiles().length == 0) {
            file3.mkdirs();
            if (file3.isDirectory()) {
                try {
                    File file4 = new File(file, "Root");
                    ImportExecutor.copyFile(file4, new File(file3, "Root"));
                    File file5 = new File(file, "Repository");
                    ImportExecutor.copyFile(file5, new File(file3, "Repository"));
                    File file6 = new File(file, "Entries");
                    ImportExecutor.copyFile(file6, new File(file3, "Entries"));
                    StandardAdminHandler standardAdminHandler = new StandardAdminHandler();
                    Iterator iterator = standardAdminHandler.getEntries(file2);
                    while (iterator.hasNext()) {
                        Entry entry = (Entry)iterator.next();
                        String string = entry.getName();
                        Date date = entry.getLastModified();
                        File file7 = new File(file2, string);
                        if (!file7.isFile()) continue;
                        file7.setLastModified(date.getTime());
                    }
                }
                catch (IOException iOException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)iOException, NbBundle.getMessage((Class)ImportExecutor.class, (String)"BK3001"));
                    errorManager.notify((Throwable)iOException);
                }
            }
        }
    }

    private static void copyFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        if (!$assertionsDisabled && (long)((int)l) != l) {
            throw new AssertionError((Object)("Unsupported file size:" + l));
        }
        ImportExecutor.copyStream(fileOutputStream, fileInputStream, (int)l);
    }

    private static void copyStream(OutputStream outputStream, InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        do {
            n2 = n <= 4096 ? n : 4096;
            if ((n2 = inputStream.read(byArray, 0, n2)) < 0) {
                throw new EOFException();
            }
            outputStream.write(byArray, 0, n2);
        } while ((n -= n2) != 0);
    }

    static {
        $assertionsDisabled = !ImportExecutor.class.desiredAssertionStatus();
    }
}

