/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchSettings;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BranchAction
extends AbstractSystemAction {
    private static final int enabledForStatus = 1208;

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Branch";
    }

    protected int getFileEnabledStatus() {
        return 1208;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performCvsAction(Node[] nodeArray) {
        Context context = this.getContext(nodeArray);
        String string = MessageFormat.format(NbBundle.getBundle((Class)BranchAction.class).getString("CTL_BranchDialog_Title"), this.getContextDisplayName(nodeArray));
        JButton jButton = new JButton(NbBundle.getMessage((Class)BranchAction.class, (String)"CTL_BranchDialog_Action_Branch"));
        jButton.setToolTipText(NbBundle.getMessage((Class)BranchAction.class, (String)"TT_BranchDialog_Action_Branch"));
        JButton jButton2 = new JButton(NbBundle.getMessage((Class)BranchAction.class, (String)"CTL_BranchDialog_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BranchAction.class, (String)"ACSD_BranchDialog_Action_Cancel"));
        BranchSettings branchSettings = new BranchSettings(context.getFiles());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)branchSettings, string, true, new Object[]{jButton, jButton2}, (Object)jButton, 0, new HelpCtx(BranchAction.class), null);
        dialogDescriptor.setClosingOptions(null);
        branchSettings.putClientProperty("org.openide.DialogDescriptor", dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BranchAction.class, (String)"ACSD_BranchDialog"));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        branchSettings.saveSettings();
        RequestProcessor.getDefault().post((Runnable)new BranchExecutor(context, branchSettings, this.getRunningName(nodeArray)));
    }

    private static class BranchExecutor
    implements Runnable {
        private final Context context;
        private final BranchSettings settings;
        private final String name;

        public BranchExecutor(Context context, BranchSettings branchSettings, String string) {
            this.context = context;
            this.settings = branchSettings;
            this.name = string;
        }

        public void run() {
            ExecutorGroup executorGroup = new ExecutorGroup(this.name);
            if (this.settings.isTaggingBase()) {
                executorGroup.addExecutors(this.tag(this.context.getFiles(), this.settings.getBaseTagName()));
                executorGroup.addBarrier(null);
            }
            executorGroup.addExecutors(this.branch(this.context.getFiles(), this.settings.getBranchName()));
            executorGroup.addBarrier(null);
            if (this.settings.isCheckingOutBranch()) {
                executorGroup.addExecutors(this.update(this.context, this.settings.getBranchName()));
            }
            executorGroup.execute();
        }

        private UpdateExecutor[] update(Context context, String string) {
            UpdateCommand updateCommand = new UpdateCommand();
            GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
            if (context.getExclusions().size() > 0) {
                globalOptions.setExclusions(context.getExclusions().toArray(new File[context.getExclusions().size()]));
            }
            updateCommand.setUpdateByRevision(string);
            updateCommand.setFiles(context.getRootFiles());
            return UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), globalOptions);
        }

        private ExecutorSupport[] branch(File[] fileArray, String string) {
            TagCommand tagCommand = new TagCommand();
            tagCommand.setMakeBranchTag(true);
            tagCommand.setFiles(fileArray);
            tagCommand.setTag(string);
            return TagExecutor.splitCommand(tagCommand, CvsVersioningSystem.getInstance(), null);
        }

        private ExecutorSupport[] tag(File[] fileArray, String string) {
            TagCommand tagCommand = new TagCommand();
            tagCommand.setFiles(fileArray);
            tagCommand.setTag(string);
            return TagExecutor.splitCommand(tagCommand, CvsVersioningSystem.getInstance(), null);
        }
    }
}

