/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class BranchSettings
extends JPanel {
    private final File[] roots;
    private boolean autoComputeBaseTagName = true;
    private JCheckBox cbCheckoutBranch;
    private JCheckBox cbTagBase;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel nameLabel;
    private JTextField tfBaseTagName;
    private JTextField tfName;

    public BranchSettings(File[] fileArray) {
        this.roots = fileArray;
        this.initComponents();
        this.cbTagBase.setSelected(CvsModuleConfig.getDefault().getDefaultValue("BranchSettings.tagBase", true));
        this.tfBaseTagName.setText(CvsModuleConfig.getDefault().getDefaultValue("BranchSettings.tagBaseName", NbBundle.getMessage((Class)BranchSettings.class, (String)"BK0001")));
        this.tfBaseTagName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                BranchSettings.this.autoComputeBaseTagName = BranchSettings.this.computeBaseTagName().equals(BranchSettings.this.tfBaseTagName.getText());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                BranchSettings.this.autoComputeBaseTagName = BranchSettings.this.computeBaseTagName().equals(BranchSettings.this.tfBaseTagName.getText());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                BranchSettings.this.autoComputeBaseTagName = BranchSettings.this.computeBaseTagName().equals(BranchSettings.this.tfBaseTagName.getText());
            }
        });
        this.cbCheckoutBranch.setSelected(CvsModuleConfig.getDefault().getDefaultValue("BranchSettings.checkout", true));
        this.tfName.setText(CvsModuleConfig.getDefault().getDefaultValue("BranchSettings.branchName", NbBundle.getMessage((Class)BranchSettings.class, (String)"BK0002")));
        this.tfName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                BranchSettings.this.refreshComponents();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                BranchSettings.this.refreshComponents();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                BranchSettings.this.refreshComponents();
            }
        });
        this.refreshComponents();
    }

    public boolean isCheckingOutBranch() {
        return this.cbCheckoutBranch.isSelected();
    }

    public boolean isTaggingBase() {
        return this.cbTagBase.isSelected();
    }

    public String getBranchName() {
        return this.tfName.getText();
    }

    public String getBaseTagName() {
        return this.tfBaseTagName.getText();
    }

    public void saveSettings() {
        CvsModuleConfig.getDefault().setDefaultValue("BranchSettings.tagBase", this.cbTagBase.isSelected());
        CvsModuleConfig.getDefault().setDefaultValue("BranchSettings.checkout", this.cbCheckoutBranch.isSelected());
        CvsModuleConfig.getDefault().setDefaultValue("BranchSettings.branchName", this.tfName.getText());
    }

    private String computeBaseTagName() {
        return NbBundle.getMessage((Class)BranchSettings.class, (String)"BK0003", (Object)this.tfName.getText());
    }

    private void refreshComponents() {
        DialogDescriptor dialogDescriptor;
        this.jLabel1.setEnabled(this.cbTagBase.isSelected());
        this.tfBaseTagName.setEnabled(this.cbTagBase.isSelected());
        if (this.autoComputeBaseTagName && this.cbTagBase.isSelected()) {
            this.tfBaseTagName.setText(this.computeBaseTagName());
        }
        if ((dialogDescriptor = (DialogDescriptor)this.getClientProperty("org.openide.DialogDescriptor")) != null) {
            dialogDescriptor.setValid(this.tfName.getText().trim().length() > 0);
        }
    }

    private void initComponents() {
        this.cbTagBase = new JCheckBox();
        this.cbCheckoutBranch = new JCheckBox();
        this.nameLabel = new JLabel();
        this.tfName = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.tfBaseTagName = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cbTagBase.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbTagBase, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_BranchForm_TagBase"));
        this.cbTagBase.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_BranchForm_TagBase"));
        this.cbTagBase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BranchSettings.this.cbTagBaseActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.cbTagBase, gridBagConstraints);
        this.cbCheckoutBranch.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbCheckoutBranch, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_BranchForm_UpdateToBranch"));
        this.cbCheckoutBranch.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_BranchForm_UpdateToBranch"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.cbCheckoutBranch, gridBagConstraints);
        this.nameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("MNE_BranchForm_BranchName").charAt(0));
        this.nameLabel.setLabelFor(this.tfName);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_BranchForm_BranchName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.tfName.setColumns(20);
        this.tfName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BranchSettings.this.branchNameChanged(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.tfName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_BranchForm_BrowseBranch"));
        this.jButton1.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_BranchForm_Browse"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BranchSettings.this.browseBranches(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jLabel1.setLabelFor(this.tfBaseTagName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_BranchForm_BaseTagName"));
        this.jLabel1.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_BranchForm_BaseTagName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 21, 0, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.tfBaseTagName, gridBagConstraints);
    }

    private void browseBranches(ActionEvent actionEvent) {
        for (int i = 0; i < this.roots.length; ++i) {
            try {
                CVSRoot.parse((String)Utils.getCVSRootFor(this.roots[i]));
                BranchSelector branchSelector = new BranchSelector();
                String string = branchSelector.selectTag(this.roots[i], null);
                if (string != null) {
                    this.tfName.setText(string);
                }
                return;
            }
            catch (IOException iOException) {
                continue;
            }
        }
    }

    private void branchNameChanged(ActionEvent actionEvent) {
        this.refreshComponents();
    }

    private void cbTagBaseActionPerformed(ActionEvent actionEvent) {
        this.refreshComponents();
    }
}

