/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.RtagCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergeBranchPanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.RTagExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MergeBranchAction
extends AbstractSystemAction {
    private static final int enabledForStatus = 1208;

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_MergeBranch";
    }

    protected int getFileEnabledStatus() {
        return 1208;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    public void performCvsAction(Node[] nodeArray) {
        Context context = this.getContext(nodeArray);
        String string = MessageFormat.format(NbBundle.getBundle((Class)MergeBranchAction.class).getString("CTL_MergeBranchDialog_Title"), this.getContextDisplayName(nodeArray));
        MergeBranchPanel mergeBranchPanel = new MergeBranchPanel(context.getFiles());
        JButton jButton = new JButton(NbBundle.getMessage((Class)MergeBranchAction.class, (String)"CTL_MergeBranchDialog_Action_Merge"));
        jButton.setToolTipText(NbBundle.getMessage((Class)MergeBranchAction.class, (String)"TT_MergeBranchDialog_Action_Merge"));
        JButton jButton2 = new JButton(NbBundle.getMessage((Class)MergeBranchAction.class, (String)"CTL_MergeBranchDialog_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)MergeBranchAction.class, (String)"ACSD_MergeBranchDialog_Action_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mergeBranchPanel, string, true, new Object[]{jButton, jButton2}, (Object)jButton, 0, new HelpCtx(MergeBranchAction.class), null);
        dialogDescriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)MergeBranchAction.class, (String)"ACSD_MergeBranchDialog"));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        mergeBranchPanel.saveSettings();
        RequestProcessor.getDefault().post((Runnable)new MergeBranchExecutor(context, mergeBranchPanel, this.getRunningName(nodeArray)));
    }

    protected boolean asynchronous() {
        return false;
    }

    private static class MergeBranchExecutor
    implements Runnable {
        private final Context context;
        private final MergeBranchPanel settings;
        private String temporaryTag;
        private String name;

        public MergeBranchExecutor(Context context, MergeBranchPanel mergeBranchPanel, String string) {
            this.context = context;
            this.settings = mergeBranchPanel;
            this.name = string;
        }

        public void run() {
            ExecutorGroup executorGroup = new ExecutorGroup(this.name);
            if (this.settings.isTaggingAfterMerge()) {
                this.temporaryTag = this.settings.getAfterMergeTagName() + "_tempheadmarker";
                ExecutorSupport[] executorSupportArray = this.tagHeadTemporary();
                executorGroup.addExecutors(executorSupportArray);
                Runnable runnable = new Runnable(this, executorSupportArray, executorGroup){
                    private final /* synthetic */ ExecutorSupport[] val$tmpTagging;
                    private final /* synthetic */ ExecutorGroup val$group;
                    private final /* synthetic */ MergeBranchExecutor this$0;
                    {
                        this.this$0 = mergeBranchExecutor;
                        this.val$tmpTagging = executorSupportArray;
                        this.val$group = executorGroup;
                    }

                    public void run() {
                        if (this.val$tmpTagging == null || ExecutorSupport.wait(this.val$tmpTagging)) {
                            this.val$group.addCleanups(MergeBranchExecutor.access$000(this.this$0));
                        }
                    }
                };
                executorGroup.addBarrier(runnable);
                executorGroup.addExecutors(this.update());
                executorGroup.addBarrier(null);
                executorGroup.addExecutors(this.tag());
            } else {
                executorGroup.addExecutors(this.update());
            }
            executorGroup.execute();
        }

        private UpdateExecutor[] update() {
            UpdateCommand updateCommand = new UpdateCommand();
            String string = this.settings.isMergingFromTrunk() ? "HEAD" : this.settings.getBranchName();
            String string2 = this.temporaryTag != null ? this.temporaryTag : string;
            GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
            if (this.context.getExclusions().size() > 0) {
                globalOptions.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
            }
            if (this.settings.isUsingMergeTag()) {
                updateCommand.setMergeRevision1(this.settings.getMergeTagName());
                updateCommand.setMergeRevision2(string2);
            } else {
                updateCommand.setMergeRevision1(string2);
            }
            updateCommand.setFiles(this.context.getRootFiles());
            updateCommand.setBuildDirectories(true);
            updateCommand.setPruneDirectories(true);
            return UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), globalOptions);
        }

        private RTagExecutor[] tag() {
            RtagCommand rtagCommand = new RtagCommand();
            rtagCommand.setOverrideExistingTag(true);
            rtagCommand.setTagByRevision(this.temporaryTag);
            rtagCommand.setTag(this.settings.getAfterMergeTagName());
            return RTagExecutor.splitCommand(rtagCommand, this.context.getFiles(), null);
        }

        private RTagExecutor[] tagHeadTemporary() {
            RtagCommand rtagCommand = new RtagCommand();
            rtagCommand.setOverrideExistingTag(true);
            rtagCommand.setTagByRevision(this.settings.isMergingFromTrunk() ? "HEAD" : this.settings.getBranchName());
            rtagCommand.setTag(this.temporaryTag);
            return RTagExecutor.splitCommand(rtagCommand, this.context.getFiles(), null);
        }

        private RTagExecutor[] removeTagHeadTemporary() {
            RtagCommand rtagCommand = new RtagCommand();
            rtagCommand.setDeleteTag(true);
            rtagCommand.setTag(this.temporaryTag);
            return RTagExecutor.splitCommand(rtagCommand, this.context.getFiles(), null);
        }

        static /* synthetic */ RTagExecutor[] access$000(MergeBranchExecutor mergeBranchExecutor) {
            return mergeBranchExecutor.removeTagHeadTemporary();
        }
    }
}

