/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class MergeBranchPanel
extends JPanel
implements DocumentListener {
    private final File[] roots;
    private JButton bBrowseBranch;
    private JButton bBrowseMergeTag;
    private JButton bBrowseTagAfterMerge;
    private ButtonGroup buttonGroup1;
    private JCheckBox cbTagAfterMerge;
    private JCheckBox cbUseMergeTag;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JRadioButton rbMergeFromBranch;
    private JRadioButton rbMergeFromTrunk;
    private JTextField tfAfterMergeTagName;
    private JTextField tfBranchName;
    private JTextField tfCurrentBranch;
    private JTextField tfMergeTagName;

    public MergeBranchPanel(File[] fileArray) {
        this.roots = fileArray;
        this.initComponents();
        this.rbMergeFromTrunk.setSelected(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.mergeTrunk", true));
        this.rbMergeFromBranch.setSelected(!CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.mergeTrunk", true));
        this.cbUseMergeTag.setSelected(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.useMergeTag", false));
        this.cbTagAfterMerge.setSelected(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.tagAfterMerge", false));
        this.tfBranchName.setText(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.branchName", NbBundle.getMessage((Class)MergeBranchPanel.class, (String)"BK1001")));
        this.tfBranchName.getDocument().addDocumentListener(this);
        this.tfMergeTagName.setText(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.mergeTagName", NbBundle.getMessage((Class)MergeBranchPanel.class, (String)"BK1002")));
        this.tfAfterMergeTagName.setText(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.afterMergeTagName", NbBundle.getMessage((Class)MergeBranchPanel.class, (String)"BK1003")));
        this.tfCurrentBranch.setText(this.detectCurrentWorkingBranch());
        this.refreshComponents();
    }

    private String detectCurrentWorkingBranch() {
        Object object;
        File file = this.roots[0];
        if (file.isFile()) {
            object = null;
            try {
                object = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (object != null) {
                String string = object.getStickyInformation();
                if (string != null) {
                    return string;
                }
            } else {
                file = file.getParentFile();
            }
        }
        if (file.isDirectory() && (object = CvsVersioningSystem.getInstance().getAdminHandler().getStickyTagForDirectory(file)) != null && ((String)object).startsWith("T")) {
            return ((String)object).substring(1);
        }
        return NbBundle.getBundle((Class)MergeBranchPanel.class).getString("MSG_MergeBranchForm_Trunk");
    }

    public boolean isTaggingAfterMerge() {
        return this.cbTagAfterMerge.isSelected();
    }

    public boolean isUsingMergeTag() {
        return this.cbUseMergeTag.isSelected();
    }

    public boolean isMergingFromTrunk() {
        return this.rbMergeFromTrunk.isSelected();
    }

    public String getAfterMergeTagName() {
        return this.tfAfterMergeTagName.getText();
    }

    public String getBranchName() {
        return this.tfBranchName.getText();
    }

    public String getMergeTagName() {
        return this.tfMergeTagName.getText();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.refreshComponents();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.refreshComponents();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.refreshComponents();
    }

    private void refreshComponents() {
        this.tfBranchName.setEnabled(this.rbMergeFromBranch.isSelected());
        this.bBrowseBranch.setEnabled(this.rbMergeFromBranch.isSelected());
        this.tfMergeTagName.setEnabled(this.cbUseMergeTag.isSelected());
        this.bBrowseMergeTag.setEnabled(this.cbUseMergeTag.isSelected());
        this.tfAfterMergeTagName.setEnabled(this.cbTagAfterMerge.isSelected());
        this.bBrowseTagAfterMerge.setEnabled(this.cbTagAfterMerge.isSelected());
        String string = this.isMergingFromTrunk() ? ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagAfterMerge_Trunk") : ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagAfterMerge_Branch");
        this.cbTagAfterMerge.setText(MessageFormat.format(string, this.tfBranchName.getText()));
    }

    public void saveSettings() {
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.mergeTrunk", this.rbMergeFromTrunk.isSelected());
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.useMergeTag", this.cbUseMergeTag.isSelected());
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.tagAfterMerge", this.cbTagAfterMerge.isSelected());
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.branchName", this.tfBranchName.getText());
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.mergeTagName", this.tfMergeTagName.getText());
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.afterMergeTagName", this.tfAfterMergeTagName.getText());
    }

    private String browseBranches() {
        for (int i = 0; i < this.roots.length; ++i) {
            try {
                CVSRoot.parse((String)Utils.getCVSRootFor(this.roots[i]));
                BranchSelector branchSelector = new BranchSelector();
                String string = branchSelector.selectTag(this.roots[i], null);
                return string;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return null;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.tfCurrentBranch = new JTextField();
        this.rbMergeFromTrunk = new JRadioButton();
        this.rbMergeFromBranch = new JRadioButton();
        this.tfBranchName = new JTextField();
        this.bBrowseBranch = new JButton();
        this.cbUseMergeTag = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.tfMergeTagName = new JTextField();
        this.bBrowseMergeTag = new JButton();
        this.cbTagAfterMerge = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.tfAfterMergeTagName = new JTextField();
        this.bBrowseTagAfterMerge = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.jLabel1.setLabelFor(this.tfCurrentBranch);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_CurrentBranch"));
        this.jLabel1.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_CurrentBranch"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.tfCurrentBranch.setColumns(10);
        this.tfCurrentBranch.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfCurrentBranch, gridBagConstraints);
        this.buttonGroup1.add(this.rbMergeFromTrunk);
        Mnemonics.setLocalizedText((AbstractButton)this.rbMergeFromTrunk, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_MergeFromTrunk"));
        this.rbMergeFromTrunk.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_MergeFromTrunk"));
        this.rbMergeFromTrunk.setBorder(BorderFactory.createEmptyBorder(12, 0, 2, 0));
        this.rbMergeFromTrunk.setMargin(new Insets(0, 0, 0, 0));
        this.rbMergeFromTrunk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeBranchPanel.this.buttonSwitch(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.rbMergeFromTrunk, gridBagConstraints);
        this.buttonGroup1.add(this.rbMergeFromBranch);
        Mnemonics.setLocalizedText((AbstractButton)this.rbMergeFromBranch, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_MergeFromBranch"));
        this.rbMergeFromBranch.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_MergeFromBranch"));
        this.rbMergeFromBranch.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbMergeFromBranch.setMargin(new Insets(0, 0, 0, 0));
        this.rbMergeFromBranch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeBranchPanel.this.buttonSwitch(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.rbMergeFromBranch, gridBagConstraints);
        this.tfBranchName.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.tfBranchName, gridBagConstraints);
        this.tfBranchName.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("ACSN_MergeBranchForm_BranchTextField"));
        this.tfBranchName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("ACSD_MergeBranchForm_BranchTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseBranch, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_Browse"));
        this.bBrowseBranch.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_Browse"));
        this.bBrowseBranch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeBranchPanel.this.browseBranch(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.bBrowseBranch, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbUseMergeTag, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_UseMergeTag"));
        this.cbUseMergeTag.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_UseMergeTag"));
        this.cbUseMergeTag.setBorder(BorderFactory.createEmptyBorder(12, 0, 2, 0));
        this.cbUseMergeTag.setMargin(new Insets(0, 0, 0, 0));
        this.cbUseMergeTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeBranchPanel.this.buttonSwitch(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.cbUseMergeTag, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tfMergeTagName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagName1"));
        this.jLabel2.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_TagName1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 20, 0, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.tfMergeTagName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseMergeTag, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_UseMergeTag_Browse"));
        this.bBrowseMergeTag.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_UseMergeTag_Browse"));
        this.bBrowseMergeTag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeBranchPanel.this.browseMergeTag(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.bBrowseMergeTag, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbTagAfterMerge, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagAfterMerge"));
        this.cbTagAfterMerge.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_TagAfterMerge"));
        this.cbTagAfterMerge.setBorder(BorderFactory.createEmptyBorder(12, 0, 2, 0));
        this.cbTagAfterMerge.setMargin(new Insets(0, 0, 0, 0));
        this.cbTagAfterMerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeBranchPanel.this.buttonSwitch(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.cbTagAfterMerge, gridBagConstraints);
        this.jLabel3.setLabelFor(this.tfAfterMergeTagName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagName2"));
        this.jLabel3.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_TagName2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.tfAfterMergeTagName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowseTagAfterMerge, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagAfterMerge_Browse"));
        this.bBrowseTagAfterMerge.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_TagAfterMerge_Browse"));
        this.bBrowseTagAfterMerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MergeBranchPanel.this.browseTagAfterMerge(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        this.add((Component)this.bBrowseTagAfterMerge, gridBagConstraints);
    }

    private void browseTagAfterMerge(ActionEvent actionEvent) {
        String string = this.browseBranches();
        if (string != null) {
            this.tfAfterMergeTagName.setText(string);
        }
    }

    private void browseMergeTag(ActionEvent actionEvent) {
        String string = this.browseBranches();
        if (string != null) {
            this.tfMergeTagName.setText(string);
        }
    }

    private void browseBranch(ActionEvent actionEvent) {
        String string = this.browseBranches();
        if (string != null) {
            this.tfBranchName.setText(string);
        }
    }

    private void buttonSwitch(ActionEvent actionEvent) {
        this.refreshComponents();
    }
}

