/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class SwitchBranchPanel
extends JPanel {
    private final File[] roots;
    private JButton bBrowse;
    private ButtonGroup bgSwitchRadio;
    private JRadioButton rbSwitchToBranch;
    private JRadioButton rbSwitchToTrunk;
    private JTextField tfBranchName;

    public SwitchBranchPanel(File[] fileArray) {
        this.roots = fileArray;
        this.initComponents();
        this.rbSwitchToTrunk.setSelected(CvsModuleConfig.getDefault().getDefaultValue("SwitchBranchSettings.switchToTrunk", true));
        this.rbSwitchToBranch.setSelected(CvsModuleConfig.getDefault().getDefaultValue("SwitchBranchSettings.switchToBranch", false));
        this.tfBranchName.setText(CvsModuleConfig.getDefault().getDefaultValue("SwitchBranchSettings.branchName", NbBundle.getMessage((Class)SwitchBranchPanel.class, (String)"BK2001")));
        this.refreshComponents();
    }

    public void saveSettings() {
        CvsModuleConfig.getDefault().setDefaultValue("SwitchBranchSettings.switchToTrunk", this.rbSwitchToTrunk.isSelected());
        CvsModuleConfig.getDefault().setDefaultValue("SwitchBranchSettings.switchToBranch", this.rbSwitchToBranch.isSelected());
        CvsModuleConfig.getDefault().setDefaultValue("SwitchBranchSettings.branchName", this.tfBranchName.getText());
    }

    private void refreshComponents() {
        if (this.rbSwitchToTrunk.isSelected()) {
            this.tfBranchName.setEnabled(false);
            this.bBrowse.setEnabled(false);
        } else {
            this.tfBranchName.setEnabled(true);
            this.bBrowse.setEnabled(true);
        }
    }

    public String getBranchName() {
        return this.tfBranchName.getText();
    }

    public boolean isSwitchToTrunk() {
        return this.rbSwitchToTrunk.isSelected();
    }

    private void initComponents() {
        this.bgSwitchRadio = new ButtonGroup();
        this.rbSwitchToTrunk = new JRadioButton();
        this.rbSwitchToBranch = new JRadioButton();
        this.tfBranchName = new JTextField();
        this.bBrowse = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.bgSwitchRadio.add(this.rbSwitchToTrunk);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSwitchToTrunk, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_SwitchBranchForm_ToTrunk"));
        this.rbSwitchToTrunk.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_SwitchBranchForm_ToTrunk"));
        this.rbSwitchToTrunk.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.rbSwitchToTrunk.setMargin(new Insets(0, 0, 0, 0));
        this.rbSwitchToTrunk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwitchBranchPanel.this.radioSwitch(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.rbSwitchToTrunk, gridBagConstraints);
        this.bgSwitchRadio.add(this.rbSwitchToBranch);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSwitchToBranch, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_SwitchBranchForm_ToBranch"));
        this.rbSwitchToBranch.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_SwitchBranchForm_ToBranch"));
        this.rbSwitchToBranch.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbSwitchToBranch.setMargin(new Insets(0, 0, 0, 0));
        this.rbSwitchToBranch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwitchBranchPanel.this.radioSwitch(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.rbSwitchToBranch, gridBagConstraints);
        this.tfBranchName.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.tfBranchName, gridBagConstraints);
        this.tfBranchName.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("ACSN_SwitchBranchForm_BranchName"));
        this.tfBranchName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("ACSD_SwitchBranchForm_BranchName"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_SwitchBranchForm_BrowseBranch"));
        this.bBrowse.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_SwitchBranchForm_BrowseBranch"));
        this.bBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwitchBranchPanel.this.browseBranches(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.bBrowse, gridBagConstraints);
    }

    private void browseBranches(ActionEvent actionEvent) {
        for (int i = 0; i < this.roots.length; ++i) {
            try {
                CVSRoot.parse((String)Utils.getCVSRootFor(this.roots[i]));
                BranchSelector branchSelector = new BranchSelector();
                String string = branchSelector.selectTag(this.roots[i], null);
                if (string != null) {
                    this.tfBranchName.setText(string);
                }
                return;
            }
            catch (IOException iOException) {
                continue;
            }
        }
    }

    private void radioSwitch(ActionEvent actionEvent) {
        this.refreshComponents();
    }
}

