/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GetCleanAction
extends AbstractSystemAction {
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_GetClean";
    }

    protected boolean enable(Node[] nodeArray) {
        return CvsVersioningSystem.getInstance().getFileTableModel(Utils.getCurrentContext(nodeArray), 6612).getNodes().length > 0;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performCvsAction(final Node[] nodeArray) {
        if (!GetCleanAction.confirmed(null, null)) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                GetCleanAction.this.revertModifications(nodeArray);
            }
        });
    }

    private static boolean confirmed(File file, String string) {
        String string2 = file == null || string == null ? NbBundle.getMessage((Class)GetCleanAction.class, (String)"CTL_RevertModifications_Prompt") : NbBundle.getMessage((Class)GetCleanAction.class, (String)"CTL_RevertModifications_Prompt2", (Object)file.getName(), (Object)string);
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string2, NbBundle.getMessage((Class)GetCleanAction.class, (String)"CTL_RevertModifications_Title"), 0, 2, null, null);
        Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
        return object == NotifyDescriptor.YES_OPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertModifications(Node[] nodeArray) {
        ExecutorGroup executorGroup = new ExecutorGroup(NbBundle.getMessage((Class)GetCleanAction.class, (String)"CTL_RevertModifications_Progress"));
        try {
            int n;
            executorGroup.progress(NbBundle.getMessage((Class)GetCleanAction.class, (String)"CTL_RevertModifications_ProgressPrepare"));
            FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
            File[] fileArray = fileStatusCache.listFiles(this.getContext(nodeArray), 2512);
            for (n = 0; n < fileArray.length; ++n) {
                File file = fileArray[n];
                GetCleanAction.rollback(file, "*", executorGroup);
            }
            for (n = 0; n < fileArray.length; ++n) {
                GetCleanAction.refresh(fileArray[n]);
            }
        }
        finally {
            executorGroup.executed();
        }
    }

    public static void rollback(File file, String string) {
        if (!GetCleanAction.confirmed(file, string)) {
            return;
        }
        GetCleanAction.rollback(file, string, null);
        GetCleanAction.refresh(file);
    }

    private static void refresh(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            fileObject.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rollback(File file, String string, ExecutorGroup executorGroup) {
        block28: {
            FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
            AdminHandler adminHandler = CvsVersioningSystem.getInstance().getAdminHandler();
            Entry entry = null;
            try {
                entry = adminHandler.getEntry(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (entry == null) {
                file.delete();
                UpdateCommand updateCommand = new UpdateCommand();
                updateCommand.setFiles(new File[]{file});
                UpdateExecutor updateExecutor = UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), null)[0];
                executorGroup.addExecutor(updateExecutor);
                updateExecutor.execute();
                return;
            }
            try {
                File file2 = VersionsCache.getInstance().getRemoteFile(file, string, executorGroup);
                if (file2 != null) {
                    GetCleanAction.backup(file);
                    try {
                        IOException iOException3;
                        FileLock fileLock;
                        Object object;
                        block25: {
                            FileObject fileObject;
                            Object object2;
                            CvsVersioningSystem.ignoreFilesystemEvents(true);
                            if (!file.exists()) {
                                object2 = file.getParentFile();
                                object = Utils.mkfolders((File)object2);
                                fileObject = object.createData(file.getName());
                            } else {
                                fileObject = FileUtil.toFileObject((File)file);
                            }
                            object2 = null;
                            object = null;
                            fileLock = null;
                            try {
                                object2 = new FileInputStream(file2);
                                fileLock = fileObject.lock();
                                object = fileObject.getOutputStream(fileLock);
                                GetCleanAction.copyStream((InputStream)object2, (OutputStream)object);
                                Object var12_15 = null;
                                if (object2 == null) break block25;
                            }
                            catch (Throwable throwable) {
                                IOException iOException22;
                                Object var12_16 = null;
                                if (object2 != null) {
                                    try {
                                        ((InputStream)object2).close();
                                    }
                                    catch (IOException iOException22) {
                                        // empty catch block
                                    }
                                }
                                if (object != null) {
                                    try {
                                        ((OutputStream)object).close();
                                    }
                                    catch (IOException iOException22) {
                                        // empty catch block
                                    }
                                }
                                if (fileLock != null) {
                                    fileLock.releaseLock();
                                }
                                throw throwable;
                            }
                            try {
                                ((InputStream)object2).close();
                            }
                            catch (IOException iOException3) {
                                // empty catch block
                            }
                        }
                        if (object != null) {
                            try {
                                ((OutputStream)object).close();
                            }
                            catch (IOException iOException3) {
                                // empty catch block
                            }
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                    finally {
                        CvsVersioningSystem.ignoreFilesystemEvents(false);
                    }
                    if (entry != null && entry.isUserFileToBeRemoved()) {
                        entry.setRevision(entry.getRevision().substring(1));
                        adminHandler.setEntry(file, entry);
                    }
                    fileStatusCache.refresh(file, string == "*" ? 65536 : 0);
                    break block28;
                }
                ErrorManager.getDefault().log(16, "Unable to checkout " + file.getName());
                file2.getName();
            }
            catch (Exception exception) {
                if (exception.getCause() instanceof InterruptedException) break block28;
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }

    private static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n;
        while ((n = inputStream.read(byArray, 0, 4096)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        return;
    }

    private static void backup(File file) {
        Entry entry = null;
        try {
            entry = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(file);
            if (entry != null) {
                File file2 = new File(file.getParentFile(), ".#" + file.getName() + "." + entry.getRevision());
                FileUtils.copyFile((File)file, (File)file2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

