/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileStatusProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class UpdateExecutor
extends ExecutorSupport {
    private Set refreshedFiles = Collections.synchronizedSet(new HashSet());
    private boolean rwUpdate;
    private long updateStartTimestamp;

    public static UpdateExecutor[] splitCommand(UpdateCommand updateCommand, CvsVersioningSystem cvsVersioningSystem, GlobalOptions globalOptions) {
        Command[] commandArray = new Command[]{};
        if (updateCommand.getDisplayName() == null) {
            updateCommand.setDisplayName(NbBundle.getMessage((Class)UpdateExecutor.class, (String)"MSG_UpdateExecutor_CmdDisplayName"));
        }
        try {
            commandArray = UpdateExecutor.prepareBasicCommand((BasicCommand)updateCommand);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        UpdateExecutor[] updateExecutorArray = new UpdateExecutor[commandArray.length];
        for (int i = 0; i < commandArray.length; ++i) {
            Command command = commandArray[i];
            updateExecutorArray[i] = new UpdateExecutor(cvsVersioningSystem, (UpdateCommand)command, globalOptions);
        }
        return updateExecutorArray;
    }

    private UpdateExecutor(CvsVersioningSystem cvsVersioningSystem, UpdateCommand updateCommand, GlobalOptions globalOptions) {
        super(cvsVersioningSystem, (Command)updateCommand, globalOptions);
        this.rwUpdate = globalOptions == null || !globalOptions.isDoNoChanges();
    }

    protected void setup() {
        super.setup();
        this.updateStartTimestamp = System.currentTimeMillis();
    }

    public void fileInfoGenerated(FileInfoEvent fileInfoEvent) {
        super.fileInfoGenerated(fileInfoEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandFinished(ClientRuntime.Result result) {
        DefaultFileInfoContainer defaultFileInfoContainer;
        UpdateCommand updateCommand = (UpdateCommand)this.cmd;
        this.cvs.setParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING, Boolean.TRUE);
        File[] fileArray = updateCommand.getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.cache.clearVirtualDirectoryContents(fileArray[i], updateCommand.isRecursive(), updateCommand.getGlobalOptions().getExclusions());
        }
        HashSet hashSet = new HashSet(2);
        boolean bl = false;
        Iterator iterator = this.toRefresh.iterator();
        while (iterator.hasNext()) {
            defaultFileInfoContainer = (DefaultFileInfoContainer)iterator.next();
            File file = defaultFileInfoContainer.getFile();
            if (this.refreshedFiles.contains(file)) continue;
            int n = defaultFileInfoContainer.getType().charAt(0);
            if (n == 80) {
                n = 85;
            }
            if (this.rwUpdate) {
                if (n == 85) {
                    n = 65536;
                }
                if (n == 71) {
                    n = 77;
                }
                if (n == 67) {
                    bl = true;
                }
            }
            this.cache.refreshCached(file, n);
            this.refreshedFiles.add(file);
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (updateCommand.isRecursive()) {
                this.refreshRecursively(fileArray[i]);
            } else {
                this.refreshFlat(fileArray[i]);
            }
            this.addFileSystem(hashSet, fileArray[i]);
            if (!fileArray[i].isFile()) continue;
            this.cache.refreshCached(fileArray[i].getParentFile(), 0);
        }
        this.cvs.setParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING, null);
        if (bl) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)UpdateExecutor.class, (String)"MSG_UpdateGeneratedConflicts_Prompt"), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            defaultFileInfoContainer = (FileSystem)iterator2.next();
            try {
                CvsVersioningSystem.ignoreFilesystemEvents(true);
                defaultFileInfoContainer.refresh(true);
            }
            finally {
                CvsVersioningSystem.ignoreFilesystemEvents(false);
            }
        }
        if (updateCommand.getUpdateByRevision() != null || updateCommand.isResetStickyOnes()) {
            FileStatusProvider.getInstance().refreshAllAnnotations(false, true);
        }
    }

    private void addFileSystem(Set set, File file) {
        FileObject fileObject;
        while ((fileObject = FileUtil.toFileObject((File)file)) == null) {
            if ((file = file.getParentFile()) != null) continue;
            return;
        }
        try {
            set.add(fileObject.getFileSystem());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    private void refreshRecursively(File file) {
        try {
            if (this.cvs.isIgnoredFilename(file)) {
                return;
            }
            if (this.cmd.getGlobalOptions().isExcluded(file)) {
                return;
            }
            if (file.isDirectory()) {
                if (this.cache.getStatus(file).getStatus() == 2) {
                    return;
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.refreshRecursively(fileArray[i]);
                }
                if (!this.refreshedFiles.contains(file)) {
                    this.cache.refreshCached(file, 0);
                }
            } else if (!this.refreshedFiles.contains(file)) {
                this.refreshFile(file);
            }
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
    }

    private void refreshFlat(File file) {
        if (this.cvs.isIgnoredFilename(file)) {
            return;
        }
        if (this.cmd.getGlobalOptions().isExcluded(file)) {
            return;
        }
        if (this.refreshedFiles.contains(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (this.cvs.isIgnoredFilename(fileArray[i])) {
                    return;
                }
                if (this.refreshedFiles.contains(fileArray[i])) {
                    return;
                }
                if (fileArray[i].isDirectory()) continue;
                this.refreshFile(fileArray[i]);
            }
            this.cache.refreshCached(file, 0);
        } else {
            this.refreshFile(file);
        }
    }

    private void refreshFile(File file) {
        long l = file.lastModified();
        if (this.cache.getStatus(file.getParentFile()).getStatus() == 8 && l > 0L && l < this.updateStartTimestamp) {
            this.cache.refreshCached(file, 65536);
        } else {
            this.cache.refreshCached(file, 0);
        }
    }
}

