/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class UpdateProjectsAction
extends SystemAction {
    public UpdateProjectsAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"CTL_MenuItem_UpdateProjects");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(UpdateProjectsAction.class);
    }

    public boolean isEnabled() {
        if (super.isEnabled()) {
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projectArray.length; ++i) {
                Project project = projectArray[i];
                if (!Utils.isVersionedProject(project)) continue;
                return true;
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setEnabled(false);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                UpdateProjectsAction.this.async();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void async() {
        ExecutorGroup executorGroup = new ExecutorGroup(NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"BK0002"));
        try {
            executorGroup.progress(NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"BK0003"));
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            Context context = Utils.getProjectsContext(projectArray);
            if (context.getRootFiles().length == 0) {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"MSG_NoProjectFiles_Prompt"), NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"MSG_NoProjectFiles_Title"), 1);
                return;
            }
            GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
            if (context.getExclusions().size() > 0) {
                globalOptions.setExclusions(context.getExclusions().toArray(new File[context.getExclusions().size()]));
            }
            UpdateCommand updateCommand = new UpdateCommand();
            updateCommand.setDisplayName(NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"BK0002"));
            updateCommand.setFiles(context.getRootFiles());
            updateCommand.setBuildDirectories(true);
            updateCommand.setPruneDirectories(true);
            executorGroup.addExecutors(UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), globalOptions));
            executorGroup.execute();
        }
        finally {
            this.setEnabled(true);
            executorGroup.executed();
        }
    }
}

