/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class DiffTreeTable
extends TreeTableView {
    private RevisionsRootNode rootNode;
    private List results;

    public DiffTreeTable() {
        this.treeTable.setShowHorizontalLines(true);
        this.treeTable.setShowVerticalLines(false);
        this.setRootVisible(false);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setupColumns();
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setLeafIcon(null);
        this.tree.setCellRenderer(defaultTreeCellRenderer);
    }

    private void setupColumns() {
        Node.Property[] propertyArray = new Node.Property[4];
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)DiffTreeTable.class);
        propertyArray[0] = new ColumnDescriptor("name", String.class, "", "");
        propertyArray[0].setValue("TreeColumnTTV", (Object)Boolean.TRUE);
        propertyArray[1] = new ColumnDescriptor("date", String.class, resourceBundle.getString("LBL_DiffTree_Column_Time"), resourceBundle.getString("LBL_DiffTree_Column_Time_Desc"));
        propertyArray[2] = new ColumnDescriptor("username", String.class, resourceBundle.getString("LBL_DiffTree_Column_Username"), resourceBundle.getString("LBL_DiffTree_Column_Username_Desc"));
        propertyArray[3] = new ColumnDescriptor("message", String.class, resourceBundle.getString("LBL_DiffTree_Column_Message"), resourceBundle.getString("LBL_DiffTree_Column_Message_Desc"));
        this.setProperties(propertyArray);
    }

    private void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = DiffTreeTable.this.getWidth();
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(n * 25 / 100);
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(n * 15 / 100);
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(n * 10 / 100);
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(n * 50 / 100);
            }
        });
    }

    void setSelection(int n) {
        this.treeTable.getSelectionModel().setValueIsAdjusting(false);
        this.treeTable.scrollRectToVisible(this.treeTable.getCellRect(n, 1, true));
        this.treeTable.getSelectionModel().setSelectionInterval(n, n);
    }

    void setSelection(SearchHistoryPanel.ResultsContainer resultsContainer) {
        RevisionNode revisionNode = (RevisionNode)this.getNode((Node)this.rootNode, resultsContainer);
        if (revisionNode == null) {
            return;
        }
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        try {
            explorerManager.setSelectedNodes(new Node[]{revisionNode});
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
        }
    }

    void setSelection(SearchHistoryPanel.DispRevision dispRevision) {
        RevisionNode revisionNode = (RevisionNode)this.getNode((Node)this.rootNode, dispRevision);
        if (revisionNode == null) {
            return;
        }
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        try {
            explorerManager.setSelectedNodes(new Node[]{revisionNode});
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
        }
    }

    private Node getNode(Node node, Object object) {
        Object object2 = node.getLookup().lookup(object.getClass());
        if (object.equals(object2)) {
            return node;
        }
        Enumeration enumeration = node.getChildren().nodes();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            Node node3 = this.getNode(node2, object);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    public int[] getSelection() {
        return this.treeTable.getSelectedRows();
    }

    public int getRowCount() {
        return this.treeTable.getRowCount();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        explorerManager.setRootContext((Node)this.rootNode);
        this.setDefaultColumnSizes();
    }

    public void setResults(List list) {
        this.results = list;
        this.rootNode = new RevisionsRootNode();
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        if (explorerManager != null) {
            explorerManager.setRootContext((Node)this.rootNode);
        }
    }

    private class RevisionsRootNodeChildren
    extends Children.Keys {
        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refreshKeys() {
            this.setKeys(DiffTreeTable.this.results);
        }

        protected Node[] createNodes(Object object) {
            RevisionNode revisionNode = object instanceof SearchHistoryPanel.ResultsContainer ? new RevisionNode((SearchHistoryPanel.ResultsContainer)object) : new RevisionNode((SearchHistoryPanel.DispRevision)object);
            return new Node[]{revisionNode};
        }
    }

    private class RevisionsRootNode
    extends AbstractNode {
        public RevisionsRootNode() {
            super((Children)new RevisionsRootNodeChildren(), Lookups.singleton((Object)DiffTreeTable.this.results));
        }

        public String getName() {
            return "revision";
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable = DiffTreeTable.class$("org.netbeans.modules.versioning.system.cvss.ui.history.DiffTreeTable")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable), (String)"LBL_DiffTree_Column_Name");
        }

        public String getShortDescription() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable = DiffTreeTable.class$("org.netbeans.modules.versioning.system.cvss.ui.history.DiffTreeTable")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable), (String)"LBL_DiffTree_Column_Name_Desc");
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

