/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.history.FileEnvironment;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNodeChildren;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.CloneableOpenSupport;

class RevisionNode
extends AbstractNode {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_DATE = "date";
    static final String COLUMN_NAME_USERNAME = "username";
    static final String COLUMN_NAME_MESSAGE = "message";
    private LogInformation.Revision revision;
    private SearchHistoryPanel.ResultsContainer container;
    private String path;
    static /* synthetic */ Class class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView;

    public RevisionNode(SearchHistoryPanel.ResultsContainer resultsContainer) {
        super((Children)new RevisionNodeChildren(resultsContainer), Lookups.singleton((Object)resultsContainer));
        this.container = resultsContainer;
        this.revision = null;
        this.path = resultsContainer.getPath();
        this.setName(((SearchHistoryPanel.DispRevision)resultsContainer.getRevisions().get(0)).getRevision().getLogInfoHeader().getFile().getName());
        this.initProperties();
    }

    public RevisionNode(SearchHistoryPanel.DispRevision dispRevision) {
        super((Children)(dispRevision.getChildren() == null ? Children.LEAF : new RevisionNodeChildren(dispRevision)), Lookups.fixed((Object[])new Object[]{dispRevision}));
        this.path = dispRevision.getPath();
        this.revision = dispRevision.getRevision();
        this.setName(dispRevision.getRevision().getNumber());
        this.initProperties();
    }

    LogInformation.Revision getRevision() {
        return this.revision;
    }

    SearchHistoryPanel.ResultsContainer getContainer() {
        return this.container;
    }

    public String getShortDescription() {
        return this.path;
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return null;
        }
        if (this.revision == null) {
            return new Action[0];
        }
        return new Action[]{new RollbackAction(), new RollbackChangeAction(), new FindCommitAction(false), new FindCommitAction(true)};
    }

    public Node.Cookie getCookie(Class clazz) {
        if (ViewCookie.class.equals(clazz)) {
            File file = this.revision.getLogInfoHeader().getFile();
            String string = null;
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null) {
                string = fileObject.getMIMEType();
            }
            ViewEnv viewEnv = new ViewEnv(file, this.revision.getNumber().trim(), string);
            return new ViewCookieImpl(viewEnv);
        }
        return super.getCookie(clazz);
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new DateProperty());
        set.put((Node.Property)new UsernameProperty());
        set.put((Node.Property)new MessageProperty());
        sheet.put(set);
        this.setSheet(sheet);
    }

    private static class RevisionPropertyEditor
    extends PropertyEditorSupport {
        private static final JLabel renderer = new JLabel();

        public RevisionPropertyEditor(String string) {
            this.setValue(string);
        }

        public void paintValue(Graphics graphics, Rectangle rectangle) {
            renderer.setForeground(graphics.getColor());
            renderer.setText((String)this.getValue());
            renderer.setBounds(rectangle);
            renderer.paint(graphics);
        }

        public boolean isPaintable() {
            return true;
        }

        static {
            renderer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
    }

    private class RollbackChangeAction
    extends AbstractAction {
        public RollbackChangeAction() {
            this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode = RevisionNode.class$("org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode), (String)"CTL_Action_RollbackChange"));
            this.setEnabled(Utils.previousRevision(RevisionNode.this.revision.getNumber()) != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SummaryView.rollbackChanges(new LogInformation.Revision[]{RevisionNode.this.revision});
        }
    }

    private class RollbackAction
    extends AbstractAction {
        public RollbackAction() {
            this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode = RevisionNode.class$("org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode), (String)"CTL_Action_RollbackTo", (Object)RevisionNode.this.revision.getNumber()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = RevisionNode.this.revision.getLogInfoHeader().getFile();
            GetCleanAction.rollback(file, RevisionNode.this.revision.getNumber());
        }
    }

    private class FindCommitAction
    extends AbstractAction {
        private boolean allProjects;

        public FindCommitAction(boolean bl) {
            this.allProjects = bl;
            if (bl) {
                this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode = RevisionNode.class$("org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode), (String)"CTL_Action_FindCommitInProjects"));
            } else {
                File file = RevisionNode.this.revision.getLogInfoHeader().getFile();
                Project project = Utils.getProject(file);
                if (project != null) {
                    String string = ProjectUtils.getInformation((Project)project).getDisplayName();
                    this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode = RevisionNode.class$("org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode), (String)"CTL_Action_FindCommitInProject", (Object)string));
                } else {
                    this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode = RevisionNode.class$("org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode), (String)"CTL_Action_FindCommit"));
                    this.setEnabled(false);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = RevisionNode.this.revision.getLogInfoHeader().getFile();
            if (this.allProjects) {
                Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
                int n = projectArray.length;
                SearchHistoryAction.openSearch(n == 1 ? ProjectUtils.getInformation((Project)projectArray[0]).getDisplayName() : NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView = RevisionNode.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView), (String)"CTL_FindAssociateChanges_OpenProjects_Title", (Object)Integer.toString(n)), RevisionNode.this.revision.getMessage().trim(), RevisionNode.this.revision.getAuthor(), RevisionNode.this.revision.getDate());
            } else {
                Project project = Utils.getProject(file);
                Context context = Utils.getProjectsContext(new Project[]{project});
                SearchHistoryAction.openSearch(context, ProjectUtils.getInformation((Project)project).getDisplayName(), RevisionNode.this.revision.getMessage().trim(), RevisionNode.this.revision.getAuthor(), RevisionNode.this.revision.getDate());
            }
        }
    }

    private class MessageProperty
    extends CommitNodeProperty {
        public MessageProperty() {
            super(RevisionNode.COLUMN_NAME_MESSAGE, class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, RevisionNode.COLUMN_NAME_MESSAGE, RevisionNode.COLUMN_NAME_MESSAGE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.revision != null) {
                return RevisionNode.this.revision.getMessage();
            }
            return "";
        }
    }

    private class DateProperty
    extends CommitNodeProperty {
        public DateProperty() {
            super(RevisionNode.COLUMN_NAME_DATE, class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, RevisionNode.COLUMN_NAME_DATE, RevisionNode.COLUMN_NAME_DATE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.revision != null) {
                return RevisionNode.this.revision.getDateString();
            }
            return "";
        }
    }

    private class UsernameProperty
    extends CommitNodeProperty {
        public UsernameProperty() {
            super(RevisionNode.COLUMN_NAME_USERNAME, class$java$lang$String == null ? (class$java$lang$String = RevisionNode.class$("java.lang.String")) : class$java$lang$String, RevisionNode.COLUMN_NAME_USERNAME, RevisionNode.COLUMN_NAME_USERNAME);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.revision != null) {
                return RevisionNode.this.revision.getAuthor();
            }
            return "";
        }
    }

    private abstract class CommitNodeProperty
    extends PropertySupport.ReadOnly {
        protected CommitNodeProperty(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return exception.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            try {
                return new RevisionPropertyEditor((String)this.getValue());
            }
            catch (Exception exception) {
                return super.getPropertyEditor();
            }
        }
    }

    private class ViewEnv
    extends FileEnvironment {
        private static final long serialVersionUID = 1L;

        ViewEnv(File file, String string, String string2) {
            super(file, string, string2);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (ViewCookieImpl)RevisionNode.this.getCookie(class$org$openide$cookies$ViewCookie == null ? (class$org$openide$cookies$ViewCookie = RevisionNode.class$("org.openide.cookies.ViewCookie")) : class$org$openide$cookies$ViewCookie);
        }
    }

    private class ViewCookieImpl
    extends CloneableEditorSupport
    implements ViewCookie {
        ViewCookieImpl(CloneableEditorSupport.Env env) {
            super(env);
        }

        protected String messageName() {
            return RevisionNode.this.revision.getLogInfoHeader().getFile().getName() + " " + RevisionNode.this.getName();
        }

        protected String messageSave() {
            return RevisionNode.this.revision.getLogInfoHeader().getFile().getName() + " " + RevisionNode.this.getName();
        }

        protected String messageToolTip() {
            return RevisionNode.this.revision.getLogInfoHeader().getFile().getName() + " " + RevisionNode.this.getName();
        }

        protected String messageOpening() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode = RevisionNode.class$("org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$RevisionNode), (String)"CTL_Action_Opening", (Object)(RevisionNode.this.revision.getLogInfoHeader().getFile().getName() + " " + RevisionNode.this.getName()));
        }

        protected String messageOpened() {
            return "";
        }

        protected CloneableEditor createCloneableEditor() {
            CloneableEditor cloneableEditor = super.createCloneableEditor();
            cloneableEditor.setActivatedNodes(new Node[]{RevisionNode.this});
            return cloneableEditor;
        }

        private Object writeReplace() {
            return null;
        }
    }
}

