/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.LogExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.RLogExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class SearchExecutor
implements Runnable {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static final DateFormat[] dateFormats = new DateFormat[]{fullDateFormat, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), simpleDateFormat, new SimpleDateFormat("yyyy-MM-dd")};
    private static Set misconfiguredServers = Collections.synchronizedSet(new HashSet());
    private final SearchHistoryPanel master;
    private File[] folders;
    private File[] files;
    private final SearchCriteriaPanel criteria;
    private List results = new ArrayList();

    public SearchExecutor(SearchHistoryPanel searchHistoryPanel) {
        this.master = searchHistoryPanel;
        File[] fileArray = searchHistoryPanel.getRoots();
        HashSet<String> hashSet = new HashSet<String>(1);
        HashSet<File> hashSet2 = new HashSet<File>(fileArray.length);
        HashSet<File> hashSet3 = new HashSet<File>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            boolean bl = false;
            try {
                String string = Utils.getCVSRootFor(file);
                bl = misconfiguredServers.contains(string);
                if (file.isDirectory() && bl && hashSet.add(string)) {
                    this.showMisconfiguredServerWarning(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file.isFile() || bl) {
                hashSet3.add(file);
                continue;
            }
            hashSet2.add(file);
        }
        this.files = hashSet3.toArray(new File[hashSet3.size()]);
        this.folders = hashSet2.toArray(new File[hashSet2.size()]);
        this.criteria = searchHistoryPanel.getCriteria();
    }

    public void run() {
        ExecutorSupport[] executorSupportArray;
        Object object;
        String string = this.criteria.getFrom();
        String string2 = this.criteria.getTo();
        Date date = this.parseDate(string);
        Date date2 = this.parseDate(string2);
        RlogCommand rlogCommand = new RlogCommand();
        LogCommand logCommand = new LogCommand();
        if (date != null || date2 != null) {
            object = "";
            if (date != null) {
                object = fullDateFormat.format(date);
            }
            object = (String)object + "<=";
            if (date2 != null) {
                object = (String)object + fullDateFormat.format(date2);
            }
            rlogCommand.setDateFilter((String)object);
            logCommand.setDateFilter((String)object);
        } else if (string != null || string2 != null) {
            object = "";
            if (string != null) {
                object = string;
            }
            object = (String)object + ":";
            if (string2 != null) {
                object = (String)object + string2;
            }
            rlogCommand.setRevisionFilter((String)object);
            logCommand.setRevisionFilter((String)object);
        }
        rlogCommand.setNoTags(true);
        rlogCommand.setUserFilter(this.criteria.getUsername());
        logCommand.setUserFilter(this.criteria.getUsername());
        object = new ExecutorGroup(NbBundle.getMessage((Class)SearchExecutor.class, (String)"BK0001"), false);
        ExecutorSupport[] executorSupportArray2 = this.folders.length > 0 ? RLogExecutor.splitCommand(rlogCommand, this.folders, null) : new RLogExecutor[]{};
        ((ExecutorGroup)object).addExecutors(executorSupportArray2);
        if (this.files.length > 0) {
            logCommand.setFiles(this.files);
            executorSupportArray = LogExecutor.splitCommand(logCommand, null);
        } else {
            executorSupportArray = new LogExecutor[]{};
        }
        ((ExecutorGroup)object).addExecutors(executorSupportArray);
        ExecutorSupport[] executorSupportArray3 = executorSupportArray2;
        ExecutorSupport[] executorSupportArray4 = executorSupportArray;
        Runnable runnable = new Runnable((RLogExecutor[])executorSupportArray3, (LogExecutor[])executorSupportArray4){
            private final /* synthetic */ RLogExecutor[] val$frexecutors;
            private final /* synthetic */ LogExecutor[] val$flexecutors;
            {
                this.val$frexecutors = rLogExecutorArray;
                this.val$flexecutors = logExecutorArray;
            }

            public void run() {
                List list = SearchExecutor.this.processResults(this.val$frexecutors, this.val$flexecutors);
                SearchExecutor.this.results.addAll(list);
                if (SearchExecutor.this.testForRLogFailures(this.val$frexecutors)) {
                    SearchExecutor.this.run();
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        SearchExecutor.access$400(1.access$300(this.this$1)).setResults(SearchExecutor.access$100(1.access$300(this.this$1)));
                    }
                });
            }

            static /* synthetic */ SearchExecutor access$300(1 var0) {
                return var0.SearchExecutor.this;
            }
        };
        ((ExecutorGroup)object).addBarrier(runnable);
        ((ExecutorGroup)object).execute();
    }

    private boolean testForRLogFailures(RLogExecutor[] rLogExecutorArray) {
        HashSet<File> hashSet = new HashSet<File>();
        HashSet<String> hashSet2 = new HashSet<String>(1);
        for (int i = 0; i < rLogExecutorArray.length; ++i) {
            RLogExecutor rLogExecutor = rLogExecutorArray[i];
            if (!rLogExecutor.hasFailedOnSymbolicLink()) continue;
            try {
                String string = Utils.getCVSRootFor(rLogExecutor.getFile());
                if (hashSet2.add(string)) {
                    this.showMisconfiguredServerWarning(string);
                }
                misconfiguredServers.add(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            hashSet.add(rLogExecutor.getFile());
        }
        if (hashSet.size() > 0) {
            this.files = hashSet.toArray(new File[hashSet.size()]);
            this.folders = new File[0];
            return true;
        }
        return false;
    }

    private void showMisconfiguredServerWarning(String string) {
        ClientRuntime clientRuntime = CvsVersioningSystem.getInstance().getClientRuntime(string);
        clientRuntime.log(NbBundle.getMessage((Class)SearchExecutor.class, (String)"MSG_SymlinkWarning1") + "\n", null);
        clientRuntime.log(NbBundle.getMessage((Class)SearchExecutor.class, (String)"MSG_SymlinkWarning2", (Object)"http://javacvs.netbeans.org/release/5.0") + "\n", new OutputListener(){

            public void outputLineSelected(OutputEvent outputEvent) {
            }

            public void outputLineAction(OutputEvent outputEvent) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://javacvs.netbeans.org/release/5.0"));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }

            public void outputLineCleared(OutputEvent outputEvent) {
            }
        });
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)SearchExecutor.class, (String)"MSG_StatusSymlinkWarning"));
    }

    private List processResults(RLogExecutor[] rLogExecutorArray, LogExecutor[] logExecutorArray) {
        LogInformation logInformation;
        Object object;
        int n;
        ArrayList arrayList = new ArrayList(200);
        for (n = 0; n < rLogExecutorArray.length; ++n) {
            object = rLogExecutorArray[n];
            arrayList.addAll(((RLogExecutor)object).getLogEntries());
        }
        for (n = 0; n < logExecutorArray.length; ++n) {
            object = logExecutorArray[n];
            arrayList.addAll(((LogExecutor)object).getLogEntries());
        }
        String string = this.criteria.getCommitMessage();
        object = new ArrayList(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            logInformation = (LogInformation)iterator.next();
            object.addAll(logInformation.getRevisionList());
        }
        if (string != null) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                logInformation = (LogInformation.Revision)iterator.next();
                String string2 = logInformation.getMessage();
                if (string2.indexOf(string) != -1) continue;
                iterator.remove();
            }
        }
        return object;
    }

    private Date parseDate(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < dateFormats.length; ++i) {
            DateFormat dateFormat = dateFormats[i];
            try {
                return dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    static /* synthetic */ SearchHistoryPanel access$400(SearchExecutor searchExecutor) {
        return searchExecutor.master;
    }
}

