/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.ui.history.DiffResultsView;
import org.netbeans.modules.versioning.system.cvss.ui.history.Divider;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView;
import org.netbeans.modules.versioning.system.cvss.util.NoContentPanel;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class SearchHistoryPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ActionListener,
DiffSetupSource {
    private final File[] roots;
    private final SearchCriteriaPanel criteria;
    private Divider divider;
    private Action searchAction;
    private SearchExecutor currentSearch;
    private RequestProcessor.Task currentSearchTask;
    private boolean criteriaVisible;
    private boolean searchInProgress;
    private List results;
    private List dispResults;
    private SummaryView summaryView;
    private DiffResultsView diffView;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private ExplorerManager explorerManager;
    private static final Comparator revisionsComparator = new ByRemotePathRevisionNumberComparator(){

        public int compare(Object object, Object object2) {
            return super.compare(((DispRevision)object).getRevision(), ((DispRevision)object2).getRevision());
        }
    };
    private JButton bNext;
    private JButton bPrev;
    private JButton bSearch;
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JSeparator jSeparator2;
    private JToolBar jToolBar1;
    private JPanel resultsPanel;
    private JPanel searchCriteriaPanel;
    private JToggleButton tbDiff;
    private JToggleButton tbSummary;

    public SearchHistoryPanel(File[] fileArray, SearchCriteriaPanel searchCriteriaPanel) {
        this.roots = fileArray;
        this.criteria = searchCriteriaPanel;
        this.criteriaVisible = true;
        this.explorerManager = new ExplorerManager();
        this.initComponents();
        this.setupComponents();
        this.refreshComponents(true);
    }

    private void setupComponents() {
        this.remove(this.jPanel1);
        this.divider = new Divider(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.divider, gridBagConstraints);
        this.searchCriteriaPanel.add(this.criteria);
        this.searchAction = new AbstractAction(NbBundle.getMessage((Class)SearchHistoryPanel.class, (String)"CTL_Search")){
            {
                this.putValue("ShortDescription", NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel = SearchHistoryPanel.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel), (String)"TT_Search"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.search();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "search");
        this.getActionMap().put("search", this.searchAction);
        this.bSearch.setAction(this.searchAction);
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage((Class)SearchHistoryPanel.class, (String)"CTL_Search"));
        Dimension dimension = this.tbSummary.getPreferredSize();
        Dimension dimension2 = this.tbDiff.getPreferredSize();
        if (dimension.width > dimension2.width) {
            this.tbDiff.setPreferredSize(dimension);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.diffView.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.diffView.onPrevButton();
            }
        };
        this.bNext.setAction(this.nextAction);
        this.bPrev.setAction(this.prevAction);
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 1) {
            this.criteriaVisible = !this.criteriaVisible;
            this.refreshComponents(false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (topComponent == null) {
                return;
            }
            topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
        }
    }

    public void addNotify() {
        super.addNotify();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void removeNotify() {
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    final void refreshComponents(boolean bl) {
        if (bl) {
            this.resultsPanel.removeAll();
            if (this.results == null) {
                if (this.searchInProgress) {
                    this.resultsPanel.add(new NoContentPanel(NbBundle.getMessage((Class)SearchHistoryPanel.class, (String)"LBL_SearchHistory_Searching")));
                } else {
                    this.resultsPanel.add(new NoContentPanel(NbBundle.getMessage((Class)SearchHistoryPanel.class, (String)"LBL_SearchHistory_NoResults")));
                }
            } else if (this.tbSummary.isSelected()) {
                if (this.summaryView == null) {
                    this.summaryView = new SummaryView(this, this.dispResults);
                }
                this.resultsPanel.add(this.summaryView.getComponent());
            } else {
                if (this.diffView == null) {
                    this.diffView = new DiffResultsView(this, this.dispResults);
                }
                this.resultsPanel.add(this.diffView.getComponent());
            }
            this.resultsPanel.revalidate();
            this.resultsPanel.repaint();
        }
        this.nextAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isNextEnabled());
        this.prevAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isPrevEnabled());
        this.divider.setArrowDirection(this.criteriaVisible ? 1 : 0);
        this.searchCriteriaPanel.setVisible(this.criteriaVisible);
        this.bSearch.setVisible(this.criteriaVisible);
        this.revalidate();
        this.repaint();
    }

    public void setResults(List list) {
        this.setResults(list, false);
    }

    private void setResults(List list, boolean bl) {
        this.results = list;
        if (this.results != null) {
            this.dispResults = SearchHistoryPanel.createDisplayList(this.results);
        }
        this.searchInProgress = bl;
        this.summaryView = null;
        this.diffView = null;
        this.refreshComponents(true);
    }

    public File[] getRoots() {
        return this.roots;
    }

    public SearchCriteriaPanel getCriteria() {
        return this.criteria;
    }

    private synchronized void search() {
        if (this.currentSearchTask != null) {
            this.currentSearchTask.cancel();
        }
        this.setResults(null, true);
        this.currentSearch = new SearchExecutor(this);
        this.currentSearchTask = RequestProcessor.getDefault().create((Runnable)this.currentSearch);
        this.currentSearchTask.schedule(0);
    }

    private static List createDisplayList(List list) {
        ArrayList<ResultsContainer> arrayList = new ArrayList<ResultsContainer>();
        ArrayList<DispRevision> arrayList2 = new ArrayList<DispRevision>(list);
        Collections.sort(arrayList2, new ByRemotePathRevisionNumberComparator());
        int n = arrayList2.size();
        if (n == 0) {
            return arrayList;
        }
        for (int i = 0; i < n; ++i) {
            LogInformation.Revision revision = (LogInformation.Revision)arrayList2.get(i);
            arrayList2.set(i, new DispRevision(revision));
        }
        ResultsContainer resultsContainer = null;
        resultsContainer = new ResultsContainer(((DispRevision)arrayList2.get(0)).getRevision().getLogInfoHeader());
        arrayList.add(resultsContainer);
        for (int i = 0; i < n; ++i) {
            DispRevision dispRevision;
            DispRevision dispRevision2 = (DispRevision)arrayList2.get(i);
            if (resultsContainer.getHeader() != dispRevision2.getRevision().getLogInfoHeader()) {
                if (resultsContainer.getRevisions().size() < 1) {
                    arrayList.remove(resultsContainer);
                    if (resultsContainer.getRevisions().size() == 1) {
                        arrayList.add((ResultsContainer)resultsContainer.getRevisions().get(0));
                    }
                }
                resultsContainer = new ResultsContainer(dispRevision2.getRevision().getLogInfoHeader());
                arrayList.add(resultsContainer);
            }
            if ((dispRevision = SearchHistoryPanel.getParentRevision(arrayList2, dispRevision2)) != null) {
                dispRevision.addRevision(dispRevision2);
                continue;
            }
            resultsContainer.add(dispRevision2);
        }
        if (resultsContainer.getRevisions().size() < 1) {
            arrayList.remove(resultsContainer);
            if (resultsContainer.getRevisions().size() == 1) {
                arrayList.add((ResultsContainer)resultsContainer.getRevisions().get(0));
            }
        }
        return arrayList;
    }

    private static DispRevision getParentRevision(List list, DispRevision dispRevision) {
        LogInformation.Revision revision;
        int n;
        String string = dispRevision.getRevision().getNumber();
        do {
            int n2;
            if ((n2 = string.lastIndexOf(46, string.lastIndexOf(46) - 1)) == -1) {
                return null;
            }
            string = string.substring(0, n2);
            revision = new LogInformation.Revision(dispRevision.getRevision().getLogInfoHeader());
            revision.setNumber(string);
        } while ((n = Collections.binarySearch(list, new DispRevision(revision), revisionsComparator)) < 0);
        return (DispRevision)list.get(n);
    }

    void executeSearch() {
        this.search();
    }

    void showDiff(DispRevision dispRevision) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(dispRevision);
    }

    public void showDiff(ResultsContainer resultsContainer) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(resultsContainer);
    }

    public Collection getSetups() {
        if (this.dispResults == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList<Setup> arrayList = new ArrayList<Setup>(this.dispResults.size());
        Iterator iterator = this.dispResults.iterator();
        while (iterator.hasNext()) {
            String string;
            Object object;
            ResultsContainer resultsContainer = (ResultsContainer)iterator.next();
            File file = resultsContainer.getHeader().getFile();
            boolean bl = true;
            String string2 = null;
            List list = resultsContainer.getRevisions();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                object = (DispRevision)iterator2.next();
                string = ((DispRevision)object).getRevision().getNumber();
                if (string2 != null && !string2.equals(Utils.previousRevision(string))) {
                    bl = false;
                    break;
                }
                string2 = string;
            }
            if (!bl) {
                return Collections.EMPTY_SET;
            }
            object = resultsContainer.getEldestRevision();
            string = resultsContainer.getNewestRevision();
            Setup setup = new Setup(file, (String)object, string);
            arrayList.add(setup);
        }
        return arrayList;
    }

    public String getSetupDisplayName() {
        return null;
    }

    public static int compareRevisions(String string, String string2) {
        int n;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        do {
            if (!stringTokenizer.hasMoreTokens()) {
                return stringTokenizer2.hasMoreTokens() ? -1 : 0;
            }
            if (stringTokenizer2.hasMoreTokens()) continue;
            return stringTokenizer.hasMoreTokens() ? 1 : 0;
        } while ((n2 = Integer.parseInt(stringTokenizer.nextToken())) == (n = Integer.parseInt(stringTokenizer2.nextToken())));
        return n - n2;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.searchCriteriaPanel = new JPanel();
        this.bSearch = new JButton();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.tbSummary = new JToggleButton();
        this.tbDiff = new JToggleButton();
        this.jSeparator2 = new JSeparator();
        this.bNext = new JButton();
        this.bPrev = new JButton();
        this.resultsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        this.searchCriteriaPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.searchCriteriaPanel, gridBagConstraints);
        this.bSearch.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_Search"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.bSearch, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(10, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonGroup1.add(this.tbSummary);
        this.tbSummary.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbSummary, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_ShowSummary"));
        this.tbSummary.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_Summary"));
        this.tbSummary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.onViewToggle(actionEvent);
            }
        });
        this.jToolBar1.add(this.tbSummary);
        this.buttonGroup1.add(this.tbDiff);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDiff, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_ShowDiff"));
        this.tbDiff.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_ShowDiff"));
        this.tbDiff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryPanel.this.onViewToggle(actionEvent);
            }
        });
        this.jToolBar1.add(this.tbDiff);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jToolBar1.add(this.jSeparator2);
        this.bNext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png")));
        this.jToolBar1.add(this.bNext);
        this.bNext.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("ACSN_NextDifference"));
        this.bPrev.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png")));
        this.jToolBar1.add(this.bPrev);
        this.bPrev.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("ACSN_PrevDifference"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.resultsPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)this.resultsPanel, gridBagConstraints);
    }

    private void onViewToggle(ActionEvent actionEvent) {
        this.refreshComponents(true);
    }

    private static class ByRemotePathRevisionNumberComparator
    implements Comparator {
        private ByRemotePathRevisionNumberComparator() {
        }

        public int compare(Object object, Object object2) {
            LogInformation.Revision revision = (LogInformation.Revision)object;
            LogInformation.Revision revision2 = (LogInformation.Revision)object2;
            int n = revision.getLogInfoHeader().getFile().getName().compareToIgnoreCase(revision2.getLogInfoHeader().getFile().getName());
            if (n != 0) {
                return n;
            }
            n = revision.getLogInfoHeader().getRepositoryFilename().compareToIgnoreCase(revision2.getLogInfoHeader().getRepositoryFilename());
            if (n != 0) {
                return n;
            }
            return SearchHistoryPanel.compareRevisions(revision.getNumber(), revision2.getNumber());
        }
    }

    static class DispRevision {
        private final LogInformation.Revision revision;
        private String name;
        private List children;
        private String path;
        private int indentation;

        public DispRevision(LogInformation.Revision revision) {
            block2: {
                this.revision = revision;
                File file = revision.getLogInfoHeader().getFile();
                try {
                    this.name = CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getParentFile().getAbsolutePath(), "") + "/" + file.getName();
                }
                catch (Exception exception) {
                    this.name = revision.getLogInfoHeader().getRepositoryFilename();
                    if (!this.name.endsWith(",v")) break block2;
                    this.name = this.name.substring(0, this.name.lastIndexOf(",v"));
                }
            }
            this.path = this.name.substring(0, this.name.lastIndexOf(47));
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public LogInformation.Revision getRevision() {
            return this.revision;
        }

        public void addRevision(DispRevision dispRevision) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(dispRevision);
        }

        public List getChildren() {
            return this.children;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof DispRevision)) {
                return false;
            }
            return this.revision.equals(((DispRevision)object).revision);
        }

        public int hashCode() {
            return this.revision.hashCode();
        }

        public int getIndentation() {
            return this.indentation;
        }

        public void setIndentation(int n) {
            this.indentation = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("  ");
            for (int i = 0; i < this.getIndentation(); ++i) {
                stringBuffer.append("  ");
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(stringBuffer).append(this.getRevision().getNumber()).append("\t").append(this.getRevision().getDateString()).append(" ").append(this.getRevision().getAuthor());
            stringBuffer2.append("\n");
            stringBuffer2.append(this.getRevision().getMessage());
            return stringBuffer2.toString();
        }
    }

    static class ResultsContainer {
        private List revisions;
        private String name;
        private String path;
        private final LogInformation header;

        public ResultsContainer(LogInformation logInformation) {
            block2: {
                this.revisions = new ArrayList(2);
                this.header = logInformation;
                File file = logInformation.getFile();
                try {
                    this.name = CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getParentFile().getAbsolutePath(), "") + "/" + file.getName();
                }
                catch (Exception exception) {
                    this.name = logInformation.getRepositoryFilename();
                    if (!this.name.endsWith(",v")) break block2;
                    this.name = this.name.substring(0, this.name.lastIndexOf(",v"));
                }
            }
            this.path = this.name.substring(0, this.name.lastIndexOf(47));
            this.name = this.name.substring(this.path.length() + 1);
        }

        public LogInformation getHeader() {
            return this.header;
        }

        public void add(DispRevision dispRevision) {
            this.revisions.add(this.revisions.size(), dispRevision);
        }

        public String getName() {
            return this.name;
        }

        public List getRevisions() {
            return this.revisions;
        }

        public String getEldestRevision() {
            DispRevision dispRevision = (DispRevision)this.revisions.get(this.revisions.size() - 1);
            return Utils.previousRevision(dispRevision.getRevision().getNumber());
        }

        public String getNewestRevision() {
            return ((DispRevision)this.revisions.get(0)).getRevision().getNumber();
        }

        public String getPath() {
            return this.path;
        }

        public File getFile() {
            return this.header.getFile();
        }

        public String toString() {
            return this.getName() + "    " + this.getPath();
        }
    }
}

