/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.cookies.ViewCookie;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener {
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;

    public SummaryView(SearchHistoryPanel searchHistoryPanel, List list) {
        this.master = searchHistoryPanel;
        this.dispResults = this.expandResults(list);
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getMimeLookup((String)"text/x-java").lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fontColorSettings.getFontColors("highlight-search");
        this.message = searchHistoryPanel.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        searchHistoryPanel.addComponentListener(this);
    }

    public void componentResized(ComponentEvent componentEvent) {
        int[] nArray = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(nArray);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private List expandResults(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof SearchHistoryPanel.ResultsContainer) {
                SearchHistoryPanel.DispRevision dispRevision;
                arrayList.add(e);
                SearchHistoryPanel.ResultsContainer resultsContainer = (SearchHistoryPanel.ResultsContainer)e;
                Iterator iterator2 = resultsContainer.getRevisions().iterator();
                while (iterator2.hasNext()) {
                    dispRevision = (SearchHistoryPanel.DispRevision)iterator2.next();
                    arrayList.add(dispRevision);
                }
                iterator2 = resultsContainer.getRevisions().iterator();
                while (iterator2.hasNext()) {
                    dispRevision = (SearchHistoryPanel.DispRevision)iterator2.next();
                    this.addResults(arrayList, dispRevision, 1);
                }
                continue;
            }
            arrayList.add(e);
            this.addResults(arrayList, (SearchHistoryPanel.DispRevision)e, 0);
        }
        return arrayList;
    }

    private void addResults(ArrayList arrayList, SearchHistoryPanel.DispRevision dispRevision, int n) {
        dispRevision.setIndentation(n);
        List list = dispRevision.getChildren();
        if (list != null) {
            SearchHistoryPanel.DispRevision dispRevision2;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                dispRevision2 = (SearchHistoryPanel.DispRevision)iterator.next();
                arrayList.add(dispRevision2);
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                dispRevision2 = (SearchHistoryPanel.DispRevision)iterator.next();
                this.addResults(arrayList, dispRevision2, n + 1);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.resultsList.getCellBounds(n, n);
        Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        Rectangle rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.diffPrevious(n);
        }
        if ((rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Acp-" + n)) != null && rectangle2.contains(point)) {
            this.associatedChangesInProject(n);
        }
        if ((rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Acop-" + n)) != null && rectangle2.contains(point)) {
            this.associatedChangesInOpenProjects(n);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.resultsList.getCellBounds(n, n);
        Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        Rectangle rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Acp-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Acop-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onPopup(MouseEvent mouseEvent) {
        String string;
        int[] nArray = this.resultsList.getSelectedIndices();
        if (nArray.length == 0) {
            int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(n);
            nArray = new int[]{n};
        }
        final int[] nArray2 = nArray;
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string2 = null;
        SearchHistoryPanel.ResultsContainer resultsContainer = null;
        SearchHistoryPanel.DispRevision dispRevision = null;
        Object e = this.dispResults.get(nArray2[0]);
        if (e instanceof SearchHistoryPanel.ResultsContainer) {
            resultsContainer = (SearchHistoryPanel.ResultsContainer)this.dispResults.get(nArray2[0]);
        } else {
            dispRevision = (SearchHistoryPanel.DispRevision)this.dispResults.get(nArray2[0]);
            string2 = Utils.previousRevision(dispRevision.getRevision().getNumber().trim());
        }
        if (resultsContainer != null) {
            string = resultsContainer.getEldestRevision();
            if (string == null) {
                string = ((SearchHistoryPanel.DispRevision)resultsContainer.getRevisions().get(resultsContainer.getRevisions().size() - 1)).getRevision().getNumber();
            }
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_SummaryView_Diff", (Object)string, (Object)resultsContainer.getNewestRevision())){

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.diffPrevious(nArray2[0]);
                }
            }));
        } else if (string2 != null) {
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", (Object)string2)){
                {
                    super(string);
                    this.setEnabled(nArray2.length == 1 && SummaryView.this.dispResults.get(nArray2[0]) instanceof SearchHistoryPanel.DispRevision);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.diffPrevious(nArray2[0]);
                }
            }));
        }
        jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
            {
                super(string);
                this.setEnabled(SummaryView.this.someRevisions(nArray2));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SummaryView.this.rollbackChange(nArray2);
            }
        }));
        if (dispRevision != null) {
            if (!"dead".equals(dispRevision.getRevision().getState())) {
                jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)dispRevision.getRevision().getNumber())){
                    {
                        super(string);
                        this.setEnabled(nArray2.length == 1 && SummaryView.this.dispResults.get(nArray2[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        SummaryView.this.rollback(nArray2[0]);
                    }
                }));
                jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_SummaryView_View", (Object)dispRevision.getRevision().getNumber())){
                    {
                        super(string);
                        this.setEnabled(nArray2.length == 1 && SummaryView.this.dispResults.get(nArray2[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RequestProcessor.getDefault().post(new Runnable(this){
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                SummaryView.access$800(5.access$700(this.this$1), 5.access$600(this.this$1)[0]);
                            }
                        });
                    }

                    static /* synthetic */ int[] access$600(5 var0) {
                        return var0.nArray2;
                    }

                    static /* synthetic */ SummaryView access$700(5 var0) {
                        return var0.SummaryView.this;
                    }
                }));
            }
            if ((string = Utils.getProject(dispRevision.getRevision().getLogInfoHeader().getFile())) != null) {
                String string3 = ProjectUtils.getInformation((Project)string).getDisplayName();
                jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_Action_AssociateChangesInProject", (Object)string3)){
                    {
                        super(string);
                        this.setEnabled(nArray2.length == 1 && SummaryView.this.dispResults.get(nArray2[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        SummaryView.this.associatedChangesInProject(nArray2[0]);
                    }
                }));
            }
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_Action_AssociateChangesInOpenProjects")){
                {
                    super(string);
                    this.setEnabled(nArray2.length == 1 && SummaryView.this.dispResults.get(nArray2[0]) instanceof SearchHistoryPanel.DispRevision);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.associatedChangesInOpenProjects(nArray2[0]);
                }
            }));
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private boolean someRevisions(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            Object e = this.dispResults.get(nArray[i]);
            if (!(e instanceof SearchHistoryPanel.DispRevision)) continue;
            return true;
        }
        return false;
    }

    private void rollbackChange(int[] nArray) {
        ArrayList<LogInformation.Revision> arrayList = new ArrayList<LogInformation.Revision>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Object e = this.dispResults.get(n);
            if (!(e instanceof SearchHistoryPanel.DispRevision)) continue;
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            arrayList.add(dispRevision.getRevision());
        }
        SummaryView.rollbackChanges(arrayList.toArray(new LogInformation.Revision[arrayList.size()]));
    }

    private static void rollbackChange(LogInformation.Revision revision, ExecutorGroup executorGroup) {
        UpdateCommand updateCommand = new UpdateCommand();
        updateCommand.setFiles(new File[]{revision.getLogInfoHeader().getFile()});
        updateCommand.setMergeRevision1(revision.getNumber());
        updateCommand.setMergeRevision2(Utils.previousRevision(revision.getNumber()));
        executorGroup.addExecutors(UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), null));
    }

    static void rollbackChanges(LogInformation.Revision[] revisionArray) {
        ExecutorGroup executorGroup = new ExecutorGroup(NbBundle.getMessage((Class)SummaryView.class, (String)"MSG_SummaryView_RollingBackChange"));
        for (int i = 0; i < revisionArray.length; ++i) {
            SummaryView.rollbackChange(revisionArray[i], executorGroup);
        }
        executorGroup.execute();
    }

    private void rollback(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            String string = dispRevision.getRevision().getNumber().trim();
            File file = dispRevision.getRevision().getLogInfoHeader().getFile();
            GetCleanAction.rollback(file, string);
        }
    }

    private void view(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            String string = dispRevision.getRevision().getNumber().trim();
            ViewCookie viewCookie = (ViewCookie)new RevisionNode(dispRevision).getCookie(ViewCookie.class);
            if (viewCookie != null) {
                viewCookie.view();
            }
        }
    }

    private void diffPrevious(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            this.master.showDiff(dispRevision);
        } else {
            SearchHistoryPanel.ResultsContainer resultsContainer = (SearchHistoryPanel.ResultsContainer)e;
            this.master.showDiff(resultsContainer);
        }
    }

    private void associatedChangesInOpenProjects(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            int n2 = projectArray.length;
            SearchHistoryAction.openSearch(n2 == 1 ? ProjectUtils.getInformation((Project)projectArray[0]).getDisplayName() : NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_FindAssociateChanges_OpenProjects_Title", (Object)Integer.toString(n2)), dispRevision.getRevision().getMessage().trim(), dispRevision.getRevision().getAuthor(), dispRevision.getRevision().getDate());
        }
    }

    private void associatedChangesInProject(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            File file = dispRevision.getRevision().getLogInfoHeader().getFile();
            Project project = Utils.getProject(file);
            Context context = Utils.getProjectsContext(new Project[]{Utils.getProject(file)});
            SearchHistoryAction.openSearch(context, ProjectUtils.getInformation((Project)project).getDisplayName(), dispRevision.getRevision().getMessage().trim(), dispRevision.getRevision().getAuthor(), dispRevision.getRevision().getDate());
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    static /* synthetic */ void access$800(SummaryView summaryView, int n) {
        summaryView.view(n);
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel(String string, Color color, Color color2) {
            if (color.equals(UIManager.getColor("List.foreground"))) {
                this.setText("<html><a href=\"\">" + string + "</a></html>");
            } else {
                String string2 = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
                this.setText("<html><a href=\"\" style=\"color:" + string2 + "\">" + string + "</a></html>");
            }
            this.setBackground(color2);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    private class SummaryCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private static final double DARKEN_FACTOR = 0.95;
        private Style selectedStyle;
        private Style normalStyle;
        private Style filenameStyle;
        private Style indentStyle;
        private Style noindentStyle;
        private Style hiliteStyle;
        private JTextPane textPane = new JTextPane();
        private JPanel actionsPane = new JPanel();
        private DateFormat defaultFormat;
        private int index;
        private HyperlinkLabel diffLink;
        private HyperlinkLabel acpLink;
        private HyperlinkLabel acopLink;

        public SummaryCellRenderer() {
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, UIManager.getColor("List.selectionForeground"));
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
            StyleConstants.setBold(this.filenameStyle, true);
            this.indentStyle = this.textPane.addStyle("indent", null);
            StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
            this.noindentStyle = this.textPane.addStyle("noindent", null);
            StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
            this.defaultFormat = DateFormat.getDateTimeInstance();
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            StyleConstants.setBackground(this.hiliteStyle, (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background));
            StyleConstants.setForeground(this.hiliteStyle, (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground));
            this.setLayout(new BorderLayout());
            this.add(this.textPane);
            this.add((Component)this.actionsPane, "Last");
            this.actionsPane.setLayout(new FlowLayout(4, 2, 5));
            this.textPane.setBorder(null);
        }

        public Color darker(Color color) {
            return new Color(Math.max((int)((double)color.getRed() * 0.95), 0), Math.max((int)((double)color.getGreen() * 0.95), 0), Math.max((int)((double)color.getBlue() * 0.95), 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof SearchHistoryPanel.ResultsContainer) {
                this.renderContainer(jList, (SearchHistoryPanel.ResultsContainer)object, n, bl);
            } else {
                this.renderRevision(jList, (SearchHistoryPanel.DispRevision)object, n, bl);
            }
            return this;
        }

        private void renderContainer(JList jList, SearchHistoryPanel.ResultsContainer resultsContainer, int n, boolean bl) {
            Style style;
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            if (bl) {
                this.textPane.setBackground(UIManager.getColor("List.selectionBackground"));
                this.actionsPane.setBackground(UIManager.getColor("List.selectionBackground"));
                style = this.selectedStyle;
            } else {
                Color color = UIManager.getColor("List.background");
                this.textPane.setBackground((n & 1) == 0 ? color : this.darker(color));
                this.actionsPane.setBackground((n & 1) == 0 ? color : this.darker(color));
                style = this.normalStyle;
            }
            try {
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, true);
                styledDocument.insertString(0, resultsContainer.getName(), null);
                styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.filenameStyle, false);
                styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + resultsContainer.getPath(), null);
                styledDocument.setCharacterAttributes(0, styledDocument.getLength(), style, false);
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.noindentStyle, false);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            this.actionsPane.removeAll();
            this.actionsPane.revalidate();
        }

        private void renderRevision(JList jList, SearchHistoryPanel.DispRevision dispRevision, int n, boolean bl) {
            int n2;
            Style style;
            Color color;
            Color color2;
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            this.index = n;
            if (bl) {
                color2 = UIManager.getColor("List.selectionForeground");
                color = UIManager.getColor("List.selectionBackground");
                style = this.selectedStyle;
            } else {
                color2 = UIManager.getColor("List.foreground");
                color = UIManager.getColor("List.background");
                color = (n & 1) == 0 ? color : this.darker(color);
                style = this.normalStyle;
            }
            this.textPane.setBackground(color);
            this.actionsPane.setBackground(color);
            LogInformation.Revision revision = dispRevision.getRevision();
            String string = revision.getMessage();
            if (string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            int n3 = dispRevision.getIndentation();
            try {
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, true);
                if (n3 == 0) {
                    styledDocument.insertString(0, dispRevision.getRevision().getLogInfoHeader().getFile().getName(), null);
                    styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.filenameStyle, false);
                    styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + dispRevision.getName().substring(0, dispRevision.getName().lastIndexOf(47)) + "\n", null);
                }
                styledDocument.insertString(styledDocument.getLength(), revision.getNumber() + FIELDS_SEPARATOR, null);
                styledDocument.insertString(styledDocument.getLength(), this.defaultFormat.format(revision.getDate()) + FIELDS_SEPARATOR, null);
                styledDocument.insertString(styledDocument.getLength(), revision.getAuthor(), null);
                if ("dead".equalsIgnoreCase(dispRevision.getRevision().getState())) {
                    styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView = SummaryView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView), (String)"MSG_SummaryView_DeadState"), null);
                }
                styledDocument.insertString(styledDocument.getLength(), "\n", null);
                styledDocument.insertString(styledDocument.getLength(), string, null);
                if (SummaryView.this.message != null && !bl && (n2 = revision.getMessage().indexOf(SummaryView.this.message)) != -1) {
                    int n4 = string.length();
                    int n5 = styledDocument.getLength();
                    styledDocument.setCharacterAttributes(n5 - n4 + n2, SummaryView.this.message.length(), this.hiliteStyle, false);
                }
                styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
                if (n3 > 0) {
                    styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.indentStyle, false);
                } else {
                    styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.noindentStyle, false);
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            if (string != null && (n2 = SummaryView.this.master.getWidth()) > 0) {
                FontMetrics fontMetrics = jList.getFontMetrics(jList.getFont());
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.textPane.getGraphics());
                int n6 = -1;
                int n7 = 0;
                while (n7 != -1) {
                    n7 = string.indexOf(10, n7 + 1);
                    ++n6;
                }
                if (n3 == 0) {
                    ++n6;
                }
                int n8 = (int)(rectangle2D.getWidth() / (double)(n2 - 80) + 1.0);
                int n9 = fontMetrics.getHeight() * (n8 + n6 + 1) + 0;
                this.textPane.setPreferredSize(new Dimension(n2 - 50, n9));
            }
            this.actionsPane.removeAll();
            String string2 = Utils.previousRevision(dispRevision.getRevision().getNumber());
            if (string2 != null) {
                JLabel jLabel = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView = SummaryView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView), (String)"CTL_Action_DiffTo"));
                jLabel.setForeground(color2);
                this.actionsPane.add(jLabel);
                this.diffLink = new HyperlinkLabel(string2, color2, color);
                this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
                this.actionsPane.add(this.diffLink);
            } else {
                this.diffLink = null;
            }
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            this.acopLink = projectArray.length > 0 ? new HyperlinkLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView = SummaryView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView), (String)"CTL_Action_FindCommitInOpenProjects"), color2, color) : null;
            Project project = Utils.getProject(dispRevision.getRevision().getLogInfoHeader().getFile());
            if (project != null) {
                String string3 = ProjectUtils.getInformation((Project)project).getDisplayName();
                this.acpLink = new HyperlinkLabel("\"" + string3 + "\"", color2, color);
            } else {
                this.acpLink = null;
            }
            if (this.acpLink != null || this.acopLink != null) {
                JLabel jLabel = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView = SummaryView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView), (String)"CTL_Action_FindCommitIn"));
                jLabel.setForeground(color2);
                this.actionsPane.add(jLabel);
                if (this.acpLink != null) {
                    this.actionsPane.add(this.acpLink);
                }
                if (this.acopLink != null) {
                    if (this.acpLink != null) {
                        JLabel jLabel2 = new JLabel(",");
                        jLabel2.setForeground(color2);
                        this.actionsPane.add(jLabel2);
                    }
                    this.actionsPane.add(this.acopLink);
                }
            }
            this.actionsPane.revalidate();
        }

        protected void paintComponent(Graphics graphics) {
            Rectangle rectangle;
            super.paintComponent(graphics);
            Rectangle rectangle2 = this.actionsPane.getBounds();
            if (this.diffLink != null) {
                rectangle = this.diffLink.getBounds();
                rectangle.setBounds(rectangle.x, rectangle.y + rectangle2.y, rectangle.width, rectangle.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Diff-" + this.index, rectangle);
            }
            if (this.acpLink != null) {
                rectangle = this.acpLink.getBounds();
                rectangle.setBounds(rectangle.x, rectangle.y + rectangle2.y, rectangle.width, rectangle.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Acp-" + this.index, rectangle);
            }
            if (this.acopLink != null) {
                rectangle = this.acopLink.getBounds();
                rectangle.setBounds(rectangle.x, rectangle.y + rectangle2.y, rectangle.width, rectangle.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Acop-" + this.index, rectangle);
            }
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        public Object getElementAt(int n) {
            return SummaryView.this.dispResults.get(n);
        }
    }
}

