/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxySelector;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class ProxyDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ProxyDescriptor DIRECT = new ProxyDescriptor(0, null, -1, null, null);
    public static final ProxyDescriptor SYSTEM = new ProxyDescriptor();
    public static final int TYPE_DIRECT = 0;
    public static final int TYPE_HTTP = 1;
    public static final int TYPE_SOCKS = 2;
    private int type;
    private int port;
    private String host;
    private String userName;
    private String password;
    private String description;
    private final boolean system;
    private transient ProxyDescriptor systemDescriptor;

    ProxyDescriptor(int n, String string, int n2, String string2, String string3) {
        this(n, string, n2, string2, string3, null);
    }

    ProxyDescriptor(int n, String string, int n2, String string2, String string3, String string4) {
        this.type = n;
        this.host = string;
        this.password = string3;
        this.port = n2;
        this.userName = string2;
        this.system = false;
        this.description = string4;
    }

    ProxyDescriptor() {
        this.system = true;
    }

    public int getType() {
        ProxyDescriptor proxyDescriptor = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            proxyDescriptor = this.systemDescriptor;
        }
        if (proxyDescriptor == null) {
            return 0;
        }
        return proxyDescriptor.type;
    }

    public boolean isSystemProxyDescriptor() {
        return this.system;
    }

    public String getHost() {
        ProxyDescriptor proxyDescriptor = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            proxyDescriptor = this.systemDescriptor;
        }
        return proxyDescriptor != null ? proxyDescriptor.host : null;
    }

    public int getPort() {
        ProxyDescriptor proxyDescriptor = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            proxyDescriptor = this.systemDescriptor;
        }
        return proxyDescriptor != null ? proxyDescriptor.port : -1;
    }

    public String getUserName() {
        ProxyDescriptor proxyDescriptor = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            proxyDescriptor = this.systemDescriptor;
        }
        return proxyDescriptor != null ? proxyDescriptor.userName : null;
    }

    public String getPassword() {
        ProxyDescriptor proxyDescriptor = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            proxyDescriptor = this.systemDescriptor;
        }
        return proxyDescriptor != null ? proxyDescriptor.password : null;
    }

    public String getDescription() {
        ProxyDescriptor proxyDescriptor = this;
        if (this.system && this.systemDescriptor == null) {
            this.systemDescriptor = ProxySelector.detectSystemProxy();
        }
        if (this.system) {
            proxyDescriptor = this.systemDescriptor;
        }
        if (proxyDescriptor == null) {
            return NbBundle.getMessage((Class)ProxyDescriptor.class, (String)"BK2002");
        }
        return proxyDescriptor.description;
    }

    public boolean needsProxy(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            boolean bl = inetAddress.isLoopbackAddress();
            if (!(bl |= inetAddress.isSiteLocalAddress())) {
                try {
                    Method method = inetAddress.getClass().getMethod("isReachable", Integer.TYPE);
                    Object[] objectArray = new Object[]{new Integer(137)};
                    Object object = method.invoke((Object)inetAddress, objectArray);
                    bl |= Boolean.TRUE.equals(object);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.notify(1, (Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.notify(1, (Throwable)invocationTargetException);
                }
            }
            return !bl;
        }
        catch (UnknownHostException unknownHostException) {
            return true;
        }
    }
}

