/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.versioning.system.cvss.settings.HistorySettings;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxyConfigurationPanel;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxyDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ProxySelector
implements ActionListener,
DocumentListener {
    private ProxyDescriptor proxyDescriptor;
    private ProxyConfigurationPanel proxyPanel;
    private DialogDescriptor dialogDescriptor;

    public ProxyDescriptor selectProxy() {
        this.proxyPanel = new ProxyConfigurationPanel();
        if (this.proxyDescriptor != null) {
            if (this.proxyDescriptor.isSystemProxyDescriptor()) {
                this.proxyPanel.systemProxyRadioButton.setSelected(true);
            } else if (this.proxyDescriptor.getType() == 1) {
                this.proxyPanel.httpProxyRadioButton.setSelected(true);
            } else if (this.proxyDescriptor.getType() == 2) {
                this.proxyPanel.socksProxyRadioButton.setSelected(true);
            } else if (this.proxyDescriptor.getType() == 0) {
                this.proxyPanel.directRadioButton.setSelected(true);
            }
        } else {
            this.proxyDescriptor = new ProxyDescriptor();
        }
        this.updateFields(this.proxyDescriptor);
        this.proxyPanel.systemProxyRadioButton.addActionListener(this);
        this.proxyPanel.directRadioButton.addActionListener(this);
        this.proxyPanel.httpProxyRadioButton.addActionListener(this);
        this.proxyPanel.socksProxyRadioButton.addActionListener(this);
        this.proxyPanel.portTextField.getDocument().addDocumentListener(this);
        this.proxyPanel.serverTextField.getDocument().addDocumentListener(this);
        this.proxyPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.dialogDescriptor = new DialogDescriptor((Object)this.proxyPanel, NbBundle.getMessage((Class)ProxySelector.class, (String)"BK2004"));
        this.dialogDescriptor.setModal(true);
        this.dialogDescriptor.setHelpCtx(new HelpCtx(ProxySelector.class));
        this.revalidate();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProxySelector.class, (String)"ACSD_ProxyDialog"));
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(this.dialogDescriptor.getValue())) {
            if (this.proxyPanel.systemProxyRadioButton.isSelected()) {
                return new ProxyDescriptor();
            }
            int n = 1;
            if (this.proxyPanel.socksProxyRadioButton.isSelected()) {
                n = 2;
            } else if (this.proxyPanel.directRadioButton.isSelected()) {
                return ProxyDescriptor.DIRECT;
            }
            String string = this.proxyPanel.serverTextField.getText();
            int n2 = -1;
            String string2 = this.proxyPanel.portTextField.getText();
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string3 = null;
            String string4 = null;
            if (this.proxyPanel.loginCheckBox.isSelected()) {
                string3 = this.proxyPanel.nameTextField.getText();
                string4 = this.proxyPanel.passwordTextField.getText();
            }
            HistorySettings historySettings = HistorySettings.getDefault();
            if (n == 1) {
                historySettings.setHttpProxyHost(string);
                historySettings.setHttpProxyPort(string2);
            } else if (n == 2) {
                historySettings.setSocksProxyHost(string);
                historySettings.setSocksProxyPort(string2);
            }
            return new ProxyDescriptor(n, string, n2, string3, string4);
        }
        return null;
    }

    private void updateFields(ProxyDescriptor proxyDescriptor) {
        boolean bl = !proxyDescriptor.isSystemProxyDescriptor() && proxyDescriptor.getType() != 0;
        String string = null;
        if (!bl) {
            string = proxyDescriptor.getDescription();
        }
        if (string == null) {
            string = ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_UseSystemProxy");
        }
        this.proxyPanel.systemProxyRadioButton.setToolTipText(string);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (proxyDescriptor.getType() != 0) {
            string2 = proxyDescriptor.getHost();
            int n = proxyDescriptor.getPort();
            if (n != -1) {
                string3 = "" + n;
            }
            string4 = proxyDescriptor.getUserName();
            string5 = proxyDescriptor.getPassword();
        }
        this.proxyPanel.serverTextField.setText(string2);
        this.proxyPanel.portTextField.setText(string3);
        this.proxyPanel.loginCheckBox.setSelected(string4 != null);
        this.proxyPanel.nameTextField.setText(string4);
        this.proxyPanel.passwordTextField.setText(string5);
        this.proxyPanel.serverTextField.setEditable(bl);
        this.proxyPanel.portTextField.setEditable(bl);
        this.proxyPanel.loginCheckBox.setEnabled(bl);
        this.proxyPanel.passwordTextField.setEnabled(bl && string4 != null);
        this.proxyPanel.nameTextField.setEnabled(bl && string4 != null);
        this.proxyPanel.enableServerPart(bl);
    }

    private void revalidate() {
        if (this.proxyPanel.directRadioButton.isSelected() || this.proxyPanel.systemProxyRadioButton.isSelected()) {
            this.dialogDescriptor.setValid(true);
        } else {
            boolean bl = true;
            Document document = this.proxyPanel.portTextField.getDocument();
            try {
                int n = Integer.parseInt(document.getText(0, document.getLength()));
                bl &= n > 0;
            }
            catch (Exception exception) {
                bl = false;
            }
            document = this.proxyPanel.serverTextField.getDocument();
            this.dialogDescriptor.setValid(bl &= document.getLength() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ProxyDescriptor detectSystemProxy() {
        block21: {
            block20: {
                var0 = System.getProperty("socksProxyHost");
                if (var0 != null) {
                    var1_1 = Integer.parseInt(System.getProperty("socksProxyPort", "1080"));
                    var2_3 = System.getProperty("java.net.socks.username", System.getProperty("user.name"));
                    var3_5 = System.getProperty("java.net.socks.password");
                    return new ProxyDescriptor(2, var0, var1_1, var2_3, var3_5);
                }
                var1_2 = ProxySelector.detectNetbeansHttpProxy();
                if (var1_2 != null) {
                    return var1_2;
                }
                var2_4 = System.getProperty("http.ProxyHost");
                var3_6 = System.getProperty("http.ProxyPort");
                if (var2_4 != null) {
                    try {
                        var4_7 = Integer.parseInt(var3_6);
                        return new ProxyDescriptor(1, var2_4, var4_7, null, null);
                    }
                    catch (NumberFormatException var5_9) {
                        var4_7 = 8080;
                    }
                    return new ProxyDescriptor(1, var2_4, var4_7, null, null);
                }
                if ("Linux".equalsIgnoreCase(System.getProperty("os.name")) == false) return null;
                var4_8 = System.getProperty("user.home");
                var5_10 = new File(var4_8, ".kde/share/config/kioslaverc");
                if (var5_10.exists() == false) return null;
                var6_11 = null;
                try {
                    try {
                        var7_12 = new FileInputStream(var5_10);
                        var8_14 = new InputStreamReader(var7_12);
                        var6_11 = new BufferedReader(var8_14);
                        var10_16 = var6_11.readLine();
                        while (var10_16 != null) {
                            if (var10_16.startsWith("httpProxy=")) {
                                var11_17 = var10_16.substring("httpProxy=".length());
                                var13_18 = -1;
                                var14_19 = var11_17.indexOf("//");
                                if (var14_19 != -1) {
                                    var11_17 = var11_17.substring(var14_19 + 2);
                                }
                                if ((var15_20 = var11_17.indexOf(58)) != -1) {
                                    var12_21 = var11_17.substring(0, var15_20);
                                    var16_22 = var11_17.substring(var15_20 + 1);
                                    var13_18 = Integer.parseInt(var16_22);
                                } else {
                                    var12_21 = var11_17;
                                }
                                var16_22 = NbBundle.getMessage((Class)ProxySelector.class, (String)"BK2001");
                                var18_24 = var17_23 = new ProxyDescriptor(1, var12_21, var13_18, null, null, var16_22);
                                var20_25 = null;
                                if (var6_11 == null) return var18_24;
                                break block20;
                            }
                            var10_16 = var6_11.readLine();
                        }
                        break block21;
                    }
                    catch (IOException var7_13) {
                        var8_15 = ErrorManager.getDefault();
                        var8_15.annotate((Throwable)var7_13, NbBundle.getMessage((Class)ProxySelector.class, (String)"BK2023") + var5_10);
                        var8_15.notify((Throwable)var7_13);
                        var20_27 = null;
                        if (var6_11 == null) return null;
                        try {
                            var6_11.close();
                            return null;
                        }
                        catch (IOException var21_31) {
                            return null;
                        }
                    }
                }
                catch (Throwable var19_33) {
                    var20_28 = null;
                    if (var6_11 == null) throw var19_33;
                    ** try [egrp 3[TRYBLOCK] [7 : 456->464)] { 
lbl70:
                    // 1 sources

                    var6_11.close();
                    throw var19_33;
lbl72:
                    // 1 sources

                    catch (IOException var21_32) {
                        // empty catch block
                    }
                    throw var19_33;
                }
            }
            ** try [egrp 3[TRYBLOCK] [7 : 456->464)] { 
lbl77:
            // 1 sources

            var6_11.close();
            return var18_24;
lbl79:
            // 1 sources

            catch (IOException var21_29) {
                // empty catch block
            }
            return var18_24;
        }
        var20_26 = null;
        if (var6_11 == null) return null;
        try {}
        catch (IOException var21_30) {}
        var6_11.close();
        return null;
        return null;
    }

    private static ProxyDescriptor detectNetbeansHttpProxy() {
        int n;
        String string = ProxySelector.getNetbeansProxyHost();
        if (string == null) {
            return null;
        }
        String string2 = ProxySelector.getNetbeansProxyPort();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 8080;
        }
        String string3 = NbBundle.getMessage((Class)ProxySelector.class, (String)"BK2000");
        return new ProxyDescriptor(1, string, n, null, null, string3);
    }

    private static String getNetbeansProxyHost() {
        String string = System.getProperty("netbeans.system_http_proxy");
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        if (n <= 0 || n >= string.length() - 1) {
            return null;
        }
        return string.substring(0, n);
    }

    private static String getNetbeansProxyPort() {
        String string = System.getProperty("netbeans.system_http_proxy");
        if (string == null) {
            return "";
        }
        int n = string.indexOf(":");
        if (n <= 0 || n >= string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public void setProxyDescriptor(ProxyDescriptor proxyDescriptor) {
        this.proxyDescriptor = proxyDescriptor;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.proxyPanel.systemProxyRadioButton.isSelected()) {
            ProxyDescriptor proxyDescriptor = ProxySelector.detectSystemProxy();
            if (proxyDescriptor == null) {
                proxyDescriptor = ProxyDescriptor.DIRECT;
            }
            this.updateFields(proxyDescriptor);
        } else if (this.proxyPanel.directRadioButton.isSelected()) {
            this.updateFields(ProxyDescriptor.DIRECT);
        } else if (this.proxyPanel.httpProxyRadioButton.isSelected()) {
            if ("".equals(this.proxyPanel.portTextField.getText()) && "".equals(this.proxyPanel.serverTextField.getText())) {
                HistorySettings historySettings = HistorySettings.getDefault();
                this.proxyPanel.serverTextField.setText(historySettings.getHttpProxyHost());
                this.proxyPanel.portTextField.setText(historySettings.getHttpProxyPort());
            }
        } else if (this.proxyPanel.socksProxyRadioButton.isSelected() && "".equals(this.proxyPanel.portTextField.getText()) && "".equals(this.proxyPanel.serverTextField.getText())) {
            HistorySettings historySettings = HistorySettings.getDefault();
            this.proxyPanel.serverTextField.setText(historySettings.getSocksProxyHost());
            this.proxyPanel.portTextField.setText(historySettings.getSocksProxyPort());
        }
        this.revalidate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.revalidate();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.revalidate();
    }
}

