/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.syncview;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class OpenInEditorAction
extends AbstractAction {
    public OpenInEditorAction() {
        super(NbBundle.getBundle((Class)OpenInEditorAction.class).getString("CTL_Synchronize_Popup_OpenInEditor"));
        this.setEnabled(this.isActionEnabled());
    }

    private boolean isActionEnabled() {
        File[] fileArray = Utils.getCurrentContext(null).getFiles();
        return fileArray.length == 1 && fileArray[0].canRead();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file = Utils.getCurrentContext(null).getFiles()[0];
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return;
        }
        try {
            this.openDataObjectByCookie(DataObject.find((FileObject)fileObject));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    private final boolean openDataObjectByCookie(DataObject dataObject) {
        Class clazz = EditorCookie.Observable.class;
        Node.Cookie cookie = dataObject.getCookie(clazz);
        if (cookie != null || (cookie = dataObject.getCookie(clazz = EditorCookie.class)) != null || (cookie = dataObject.getCookie(clazz = OpenCookie.class)) != null || (cookie = dataObject.getCookie(clazz = EditCookie.class)) != null || (cookie = dataObject.getCookie(clazz = ViewCookie.class)) != null) {
            return this.openByCookie(cookie, clazz);
        }
        return false;
    }

    private boolean openByCookie(Node.Cookie cookie, Class clazz) {
        if (clazz == EditorCookie.class || clazz == EditorCookie.Observable.class) {
            ((EditorCookie)cookie).open();
        } else if (clazz == OpenCookie.class) {
            ((OpenCookie)cookie).open();
        } else if (clazz == EditCookie.class) {
            ((EditCookie)cookie).edit();
        } else if (clazz == ViewCookie.class) {
            ((ViewCookie)cookie).view();
        } else {
            throw new IllegalArgumentException("Reopen #58766: " + clazz);
        }
        return true;
    }
}

