/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.syncview;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.versioning.system.cvss.Annotator;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.DeleteLocalAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.SystemActionBridge;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ignore.IgnoreAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.AnnotationsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateAction;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.ExcludeFromCommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.OpenInEditorAction;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode;
import org.netbeans.modules.versioning.system.cvss.util.TableSorter;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class SyncTable
implements MouseListener,
ListSelectionListener,
AncestorListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private SyncFileNode[] nodes = new SyncFileNode[0];
    private String[] tableColumns;
    private TableSorter sorter;
    private static final Map columnLabels = new HashMap(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            Node.Property property = (Node.Property)object;
            Node.Property property2 = (Node.Property)object2;
            String string = (String)property.getValue("sortkey");
            if (string != null) {
                String string2 = (String)property2.getValue("sortkey");
                return string.compareToIgnoreCase(string2);
            }
            try {
                String string3 = (String)property.getValue();
                String string4 = (String)property2.getValue();
                return string3.compareToIgnoreCase(string4);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
                return 0;
            }
        }
    };
    static /* synthetic */ Class class$java$lang$String;

    public SyncTable() {
        Object object = NbBundle.getBundle((Class)SyncTable.class);
        columnLabels.put("sticky", new String[]{((ResourceBundle)object).getString("CTL_VersioningView_Column_Sticky_Title"), ((ResourceBundle)object).getString("CTL_VersioningView_Column_Sticky_Desc")});
        columnLabels.put("name", new String[]{((ResourceBundle)object).getString("CTL_VersioningView_Column_File_Title"), ((ResourceBundle)object).getString("CTL_VersioningView_Column_File_Desc")});
        columnLabels.put("status", new String[]{((ResourceBundle)object).getString("CTL_VersioningView_Column_Status_Title"), ((ResourceBundle)object).getString("CTL_VersioningView_Column_Status_Desc")});
        columnLabels.put("path", new String[]{((ResourceBundle)object).getString("CTL_VersioningView_Column_Path_Title"), ((ResourceBundle)object).getString("CTL_VersioningView_Column_Path_Desc")});
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new JTable(this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        object = UIManager.getColor("scrollpane_border");
        if (object == null) {
            object = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)object));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new SyncTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)SyncTable.class, (String)"ACSN_VersioningTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SyncTable.class, (String)"ACSD_VersioningTable"));
        this.setColumns(new String[]{"name", "status", "path"});
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                block5: {
                    int n;
                    block4: {
                        n = SyncTable.this.table.getWidth();
                        if (SyncTable.this.tableColumns.length != 3) break block4;
                        for (int i = 0; i < SyncTable.this.tableColumns.length; ++i) {
                            if ("path".equals(SyncTable.this.tableColumns[i])) {
                                SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 60 / 100);
                                continue;
                            }
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 20 / 100);
                        }
                        break block5;
                    }
                    if (SyncTable.this.tableColumns.length != 4) break block5;
                    for (int i = 0; i < SyncTable.this.tableColumns.length; ++i) {
                        if ("path".equals(SyncTable.this.tableColumns[i])) {
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 55 / 100);
                            continue;
                        }
                        SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 15 / 100);
                    }
                }
            }
        });
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSizes();
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public SyncFileNode[] getDisplayedNodes() {
        int n = this.sorter.getRowCount();
        SyncFileNode[] syncFileNodeArray = new SyncFileNode[n];
        for (int i = 0; i < n; ++i) {
            syncFileNodeArray[i] = this.nodes[this.sorter.modelIndex(i)];
        }
        return syncFileNodeArray;
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] stringArray) {
        if (Arrays.equals(stringArray, this.tableColumns)) {
            return;
        }
        this.setDefaultColumnSizes();
        this.setModelProperties(stringArray);
        this.tableColumns = stringArray;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
    }

    private void setModelProperties(String[] stringArray) {
        Node.Property[] propertyArray = new Node.Property[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = (String[])columnLabels.get(string);
            propertyArray[i] = new ColumnDescriptor(string, class$java$lang$String == null ? SyncTable.class$("java.lang.String") : class$java$lang$String, stringArray2[0], stringArray2[1]);
        }
        this.tableModel.setProperties(propertyArray);
    }

    void setTableModel(SyncFileNode[] syncFileNodeArray) {
        this.nodes = syncFileNodeArray;
        this.tableModel.setNodes((Node[])syncFileNodeArray);
    }

    void focus() {
        this.table.requestFocus();
    }

    private void showPopup(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n != -1) {
            boolean bl = true;
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        }
        JPopupMenu jPopupMenu = this.getPopup();
        jPopupMenu.show(this.table, mouseEvent.getX(), mouseEvent.getY());
    }

    private JPopupMenu getPopup() {
        SystemActionBridge systemActionBridge;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = jPopupMenu.add(new OpenInEditorAction());
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(new SystemActionBridge((Action)SystemAction.get((Class)DiffAction.class), this.actionString("CTL_PopupMenuItem_Diff")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jMenuItem = jPopupMenu.add(new SystemActionBridge((Action)SystemAction.get((Class)UpdateAction.class), this.actionString("CTL_PopupMenuItem_Update")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jMenuItem = jPopupMenu.add(new SystemActionBridge((Action)SystemAction.get((Class)CommitAction.class), this.actionString("CTL_PopupMenuItem_Commit")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(new SystemActionBridge((Action)SystemAction.get((Class)TagAction.class), this.actionString("CTL_PopupMenuItem_Tag")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jMenuItem = jPopupMenu.add(new SystemActionBridge((Action)SystemAction.get((Class)BranchAction.class), this.actionString("CTL_PopupMenuItem_Branch")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(new SystemActionBridge((Action)SystemAction.get((Class)AnnotationsAction.class), ((AnnotationsAction)SystemAction.get((Class)AnnotationsAction.class)).visible(null) ? this.actionString("CTL_PopupMenuItem_HideAnnotations") : this.actionString("CTL_PopupMenuItem_ShowAnnotations")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jMenuItem = jPopupMenu.add(new SystemActionBridge((Action)SystemAction.get((Class)SearchHistoryAction.class), this.actionString("CTL_PopupMenuItem_SearchHistory")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(new ExcludeFromCommitAction());
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        boolean bl = true;
        boolean bl2 = true;
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        File[] fileArray = Utils.getCurrentContext(null).getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileInformation fileInformation = fileStatusCache.getStatus(file);
            if ((fileInformation.getStatus() & 0x1004) == 0) {
                bl = false;
            }
            if (fileInformation.getStatus() == 2048 || fileInformation.getStatus() == 256) continue;
            bl2 = false;
        }
        if (bl) {
            SystemAction systemAction = SystemAction.get((Class)DeleteLocalAction.class);
            systemActionBridge = new SystemActionBridge((Action)systemAction, this.actionString("CTL_PopupMenuItem_Delete"));
        } else {
            systemActionBridge = bl2 ? new SystemActionBridge((Action)SystemAction.get((Class)GetCleanAction.class), this.actionString("CTL_PopupMenuItem_RevertDelete")) : new SystemActionBridge((Action)SystemAction.get((Class)GetCleanAction.class), this.actionString("CTL_PopupMenuItem_GetClean"));
        }
        jMenuItem = jPopupMenu.add(systemActionBridge);
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        jMenuItem = jPopupMenu.add(new SystemActionBridge((Action)SystemAction.get((Class)ResolveConflictsAction.class), this.actionString("CTL_PopupMenuItem_ResolveConflicts")));
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        SystemActionBridge systemActionBridge2 = new SystemActionBridge((Action)SystemAction.get((Class)IgnoreAction.class), ((IgnoreAction)SystemAction.get((Class)IgnoreAction.class)).getActionStatus(fileArray) == 2 ? this.actionString("CTL_PopupMenuItem_Unignore") : this.actionString("CTL_PopupMenuItem_Ignore"));
        jMenuItem = jPopupMenu.add(systemActionBridge2);
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
        return jPopupMenu;
    }

    private String actionString(String string) {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)Annotator.class);
        return resourceBundle.getString(string);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
            int n = this.table.rowAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            Action action = this.nodes[n = this.sorter.modelIndex(n)].getPreferredAction();
            if (action == null || !action.isEnabled()) {
                action = new OpenInEditorAction();
            }
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ArrayList<SyncFileNode> arrayList = new ArrayList<SyncFileNode>();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.table);
        if (topComponent == null) {
            return;
        }
        int n = listSelectionModel.getMinSelectionIndex();
        if (n == -1) {
            topComponent.setActivatedNodes(new Node[0]);
        }
        int n2 = listSelectionModel.getMaxSelectionIndex();
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            int n3 = this.sorter.modelIndex(i);
            arrayList.add(this.nodes[n3]);
        }
        topComponent.setActivatedNodes(arrayList.toArray(new Node[arrayList.size()]));
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component;
            Object object2;
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == 0) {
                object2 = SyncTable.this.nodes[SyncTable.this.sorter.modelIndex(n)];
                if (!bl) {
                    object = "<html>" + ((SyncFileNode)((Object)object2)).getHtmlDisplayName();
                }
                if (CvsModuleConfig.getDefault().isExcludedFromCommit(((SyncFileNode)((Object)object2)).getFile().getAbsolutePath())) {
                    String string = object2.getDisplayName();
                    object = bl ? "<html><s>" + string + "</s></html>" : "<html><s>" + CvsVersioningSystem.getInstance().getAnnotator().annotateNameHtml(string, ((SyncFileNode)((Object)object2)).getFileInformation(), null) + "</s>";
                }
            }
            if ((component = n3 == 2 ? this.pathRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JComponent) {
                object2 = SyncTable.this.nodes[SyncTable.this.sorter.modelIndex(n)].getFile().getAbsolutePath();
                ((JComponent)component).setToolTipText((String)object2);
            }
            return component;
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

