/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ExtConnection;
import org.netbeans.lib.cvsclient.connection.LocalConnection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.PasswordsFile;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;
import org.netbeans.modules.proxy.ClientSocketFactory;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.SSHConnection;
import org.netbeans.modules.versioning.system.cvss.settings.CvsRootSettings;
import org.netbeans.modules.versioning.system.cvss.settings.HistorySettings;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxyDescriptor;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxySelector;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.AbstractStep;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.wizards.RootWizard;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class RepositoryStep
extends AbstractStep
implements WizardDescriptor.AsynchronousValidatingPanel,
ActionListener,
DocumentListener {
    private RequestProcessor.Task updatePasswordTask;
    private volatile boolean passwordExpected;
    private boolean userVisitedProxySettings;
    private ProgressHandle progress;
    private JComponent progressComponent;
    private JLabel progressLabel;
    private volatile boolean internalDocumentChange;
    private Thread backgroundValidationThread;
    private RepositoryPanel repositoryPanel;
    private ProxyDescriptor proxyDescriptor;
    private String scrambledPassword;
    private final String initialCvsRoot;
    private String preferedCvsRoot;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RepositoryStep() {
        this.initialCvsRoot = null;
    }

    public RepositoryStep(String string) {
        this.initialCvsRoot = string;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(RepositoryStep.class);
    }

    public void initPreferedCvsRoot(String string) {
        this.preferedCvsRoot = string;
    }

    protected JComponent createComponent() {
        Object object;
        String string;
        this.repositoryPanel = new RepositoryPanel();
        this.repositoryPanel.extSshRadioButton.addActionListener(this);
        this.repositoryPanel.internalSshRadioButton.addActionListener(this);
        this.repositoryPanel.extCommandTextField.getDocument().addDocumentListener(this);
        this.repositoryPanel.extPasswordField.getDocument().addDocumentListener(this);
        this.repositoryPanel.passwordTextField.getDocument().addDocumentListener(this);
        RequestProcessor requestProcessor = new RequestProcessor();
        this.updatePasswordTask = requestProcessor.create(new Runnable(){

            public void run() {
                String string = RepositoryStep.this.selectedCvsRoot();
                String string2 = PasswordsFile.findPassword((String)string);
                if (string2 != null && RepositoryStep.this.passwordExpected) {
                    String string3 = new String(string2).substring(1);
                    RepositoryStep.this.scrambledPassword = string2;
                    RepositoryStep.this.internalDocumentChange = true;
                    ((RepositoryStep)RepositoryStep.this).repositoryPanel.passwordTextField.setText(string3);
                    RepositoryStep.this.internalDocumentChange = false;
                    RepositoryStep.this.cancelPasswordUpdate();
                }
            }
        });
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.preferedCvsRoot != null) {
            linkedHashSet.add(this.preferedCvsRoot);
        }
        linkedHashSet.addAll(HistorySettings.getRecent("cvsRoots"));
        if (this.initialCvsRoot != null) {
            linkedHashSet.add(this.initialCvsRoot);
        }
        Iterator iterator = PasswordsFile.listRoots((String)":pserver:").iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (linkedHashSet.contains(string)) continue;
            linkedHashSet.add(string);
        }
        string = System.getProperty("user.name", "");
        if (string.length() > 0) {
            string = string + "@";
        }
        linkedHashSet.add(":pserver:" + string);
        linkedHashSet.add(":ext:" + string);
        linkedHashSet.add(":fork:");
        linkedHashSet.add(":local:");
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
        this.repositoryPanel.rootComboBox.setModel(defaultComboBoxModel);
        this.repositoryPanel.rootComboBox.addActionListener(this);
        Component component = this.repositoryPanel.rootComboBox.getEditor().getEditorComponent();
        JTextComponent jTextComponent = (JTextComponent)component;
        if (linkedHashSet.size() == 0) {
            jTextComponent.setText(":pserver:" + string);
        } else {
            this.validateCvsRoot();
            object = this.getCVSRoot();
            this.proxyDescriptor = CvsRootSettings.getProxyFor(object);
            this.schedulePasswordUpdate();
        }
        jTextComponent.selectAll();
        jTextComponent.getDocument().addDocumentListener(this);
        object = HistorySettings.getDefault().getExtCommand();
        this.repositoryPanel.extCommandTextField.setText((String)object);
        this.repositoryPanel.proxyConfigurationButton.addActionListener(this);
        this.repositoryPanel.editButton.addActionListener(this);
        this.valid();
        this.onCvsRootChange();
        if (this.initialCvsRoot != null) {
            boolean bl = false;
            this.repositoryPanel.headerLabel.setVisible(bl);
            this.repositoryPanel.rootsLabel.setVisible(bl);
            this.repositoryPanel.rootComboBox.setVisible(bl);
            this.repositoryPanel.descLabel.setVisible(bl);
            this.repositoryPanel.editButton.setVisible(bl);
        }
        return this.repositoryPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void validateBeforeNext() {
        if (!this.validateCvsRoot()) {
            return;
        }
        final CVSRoot cVSRoot = this.getCVSRoot();
        this.backgroundValidationThread = Thread.currentThread();
        final String[] stringArray = new String[1];
        Runnable runnable = new Runnable(){
            static final /* synthetic */ boolean $assertionsDisabled;

            private void fail(String string) {
                stringArray[0] = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block35: {
                    IOException iOException2222;
                    Object var5_5;
                    Socket socket;
                    String string;
                    block33: {
                        string = cVSRoot.getHostName();
                        String string2 = cVSRoot.getUserName();
                        int n = cVSRoot.getPort();
                        socket = null;
                        var5_5 = null;
                        if (cVSRoot.isLocal()) {
                            LocalConnection localConnection = new LocalConnection();
                            localConnection.setRepository(cVSRoot.getRepository());
                            localConnection.verify();
                        } else {
                            Object object;
                            RepositoryStep.this.invalid(null);
                            RepositoryStep.this.progress(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = RepositoryStep.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK2011"));
                            SocketFactory socketFactory = SocketFactory.getDefault();
                            if (RepositoryStep.this.proxyDescriptor != null && RepositoryStep.this.proxyDescriptor.needsProxy(cVSRoot.getHostName())) {
                                object = ClientRuntime.toConnectivitySettings(RepositoryStep.this.proxyDescriptor);
                                socketFactory = new ClientSocketFactory(object);
                            }
                            if ("pserver".equals(cVSRoot.getMethod())) {
                                n = n == 0 ? 2401 : n;
                                object = new InetSocketAddress(string, n);
                                socket = socketFactory.createSocket();
                                socket.connect((SocketAddress)object, 5000);
                                socket.close();
                                RepositoryStep.this.progress(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = RepositoryStep.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK2010"));
                                PServerConnection pServerConnection = new PServerConnection(cVSRoot, socketFactory);
                                String string3 = RepositoryStep.this.getScrambledPassword();
                                pServerConnection.setEncodedPassword(string3);
                                pServerConnection.verify();
                            } else if ("ext".equals(cVSRoot.getMethod())) {
                                if (((RepositoryStep)RepositoryStep.this).repositoryPanel.internalSshRadioButton.isSelected()) {
                                    n = n == 0 ? 22 : n;
                                    object = ((RepositoryStep)RepositoryStep.this).repositoryPanel.extPasswordField.getText();
                                    SSHConnection sSHConnection = new SSHConnection(socketFactory, string, n, string2, (String)object);
                                    sSHConnection.setRepository(cVSRoot.getRepository());
                                    sSHConnection.verify();
                                } else {
                                    object = ((RepositoryStep)RepositoryStep.this).repositoryPanel.extCommandTextField.getText();
                                    String string4 = "";
                                    if (string2 != null) {
                                        string4 = " -l " + string2;
                                    }
                                    String string5 = System.getProperty("Env-CVS_SERVER", "cvs") + " server";
                                    object = (String)object + " " + string + string4 + " " + string5;
                                    ExtConnection extConnection = new ExtConnection((String)object);
                                    extConnection.setRepository(cVSRoot.getRepository());
                                    extConnection.verify();
                                }
                            } else if (!$assertionsDisabled) {
                                throw new AssertionError((Object)"Login check implemented only for pserver");
                            }
                        }
                        Object var12_21 = null;
                        if (socket == null) break block33;
                        try {
                            socket.close();
                        }
                        catch (IOException iOException2222) {
                            // empty catch block
                        }
                    }
                    if (var5_5 != null) {
                        try {
                            var5_5.close();
                        }
                        catch (IOException iOException2222) {}
                    }
                    break block35;
                    {
                        catch (IOException iOException3) {
                            IOException iOException42222;
                            ErrorManager errorManager = ErrorManager.getDefault();
                            errorManager.annotate((Throwable)iOException3, NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$RepositoryStep == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$RepositoryStep = RepositoryStep.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryStep")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$RepositoryStep), (String)"BK2019"));
                            errorManager.notify(1, (Throwable)iOException3);
                            String string6 = NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = RepositoryStep.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK1001", (Object)string);
                            this.fail(string6);
                            Object var12_22 = null;
                            if (socket != null) {
                                try {
                                    socket.close();
                                }
                                catch (IOException iOException42222) {
                                    // empty catch block
                                }
                            }
                            if (var5_5 != null) {
                                try {
                                    var5_5.close();
                                }
                                catch (IOException iOException42222) {}
                            }
                            break block35;
                        }
                        catch (AuthenticationException authenticationException) {
                            IOException iOException52222;
                            ErrorManager errorManager = ErrorManager.getDefault();
                            errorManager.annotate((Throwable)authenticationException, "Connection authentification verification failed.");
                            errorManager.notify(1, (Throwable)authenticationException);
                            String string7 = authenticationException.getLocalizedMessage() != null && authenticationException.getLocalizedMessage().startsWith("<") ? authenticationException.getLocalizedMessage() : (cVSRoot.isLocal() ? NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = RepositoryStep.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK1004") : NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard = RepositoryStep.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.CheckoutWizard")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$CheckoutWizard), (String)"BK1002"));
                            this.fail(string7);
                            Object var12_23 = null;
                            if (socket != null) {
                                try {
                                    socket.close();
                                }
                                catch (IOException iOException52222) {
                                    // empty catch block
                                }
                            }
                            if (var5_5 != null) {
                                try {
                                    var5_5.close();
                                }
                                catch (IOException iOException52222) {}
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        IOException iOException62222;
                        Object var12_24 = null;
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException62222) {
                                // empty catch block
                            }
                        }
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (IOException iOException62222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$versioning$system$cvss$ui$wizards$RepositoryStep == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$wizards$RepositoryStep = RepositoryStep.class$("org.netbeans.modules.versioning.system.cvss.ui.wizards.RepositoryStep")) : class$org$netbeans$modules$versioning$system$cvss$ui$wizards$RepositoryStep).desiredAssertionStatus();
            }
        };
        Thread thread = new Thread(runnable, "CVS I/O Probe ");
        thread.start();
        try {
            try {
                thread.join();
                if (stringArray[0] == null) {
                    this.valid();
                    this.storeValidValues();
                }
                this.valid(stringArray[0]);
            }
            catch (InterruptedException interruptedException) {
                this.invalid(NbBundle.getMessage((Class)RepositoryStep.class, (String)"BK2023"));
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)interruptedException, "Passing interrupt to possibly uninterruptible nested thread: " + thread);
                thread.interrupt();
                errorManager.notify(1, (Throwable)interruptedException);
                Object var8_6 = null;
                this.backgroundValidationThread = null;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RepositoryStep.this.validationDone();
                    }
                });
                return;
            }
            Object var8_5 = null;
            this.backgroundValidationThread = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.backgroundValidationThread = null;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void progress(String string) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(string);
        }
    }

    private void validationDone() {
        this.progress.finish();
        this.repositoryPanel.jPanel1.remove(this.progressComponent);
        this.repositoryPanel.jPanel1.revalidate();
        this.repositoryPanel.jPanel1.repaint();
        this.editable(true);
    }

    private void editable(boolean bl) {
        this.repositoryPanel.rootComboBox.setEditable(bl);
        this.repositoryPanel.passwordTextField.setEditable(bl);
        this.repositoryPanel.extCommandTextField.setEditable(bl);
        this.repositoryPanel.extPasswordField.setEditable(bl);
        this.repositoryPanel.proxyConfigurationButton.setEnabled(bl);
        this.repositoryPanel.extREmemberPasswordCheckBox.setEnabled(bl);
        this.repositoryPanel.internalSshRadioButton.setEnabled(bl);
        this.repositoryPanel.extSshRadioButton.setEnabled(bl);
    }

    void storeValidValues() {
        String string = this.selectedCvsRoot();
        CVSRoot cVSRoot = CVSRoot.parse((String)string);
        boolean bl = false;
        if (string.startsWith(":pserver:")) {
            bl = true;
            try {
                PasswordsFile.storePassword((String)string, (String)this.getScrambledPassword());
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, NbBundle.getMessage((Class)RepositoryStep.class, (String)"BK2020"));
                errorManager.notify((Throwable)iOException);
            }
        } else if (string.startsWith(":ext:")) {
            boolean bl2;
            bl = bl2 = this.repositoryPanel.internalSshRadioButton.isSelected();
            CvsRootSettings.ExtSettings extSettings = new CvsRootSettings.ExtSettings();
            extSettings.extUseInternalSsh = bl2;
            if (bl2) {
                extSettings.extPassword = this.repositoryPanel.extPasswordField.getText();
                extSettings.extRememberPassword = this.repositoryPanel.extREmemberPasswordCheckBox.isSelected();
            } else {
                extSettings.extCommand = this.repositoryPanel.extCommandTextField.getText();
                HistorySettings.getDefault().setExtCommand(extSettings.extCommand);
            }
            CvsRootSettings.setExtSettingsFor(cVSRoot, extSettings);
        }
        if (bl) {
            CvsRootSettings.setProxyFor(cVSRoot, this.getProxyDescriptor());
        }
        HistorySettings.addRecent("cvsRoots", (Serializable)((Object)string));
    }

    private boolean validateCvsRoot() {
        String string = this.selectedCvsRoot();
        String string2 = null;
        boolean bl = false;
        if (string != null) {
            bl |= string.startsWith(":pserver:");
            bl |= string.startsWith(":local:");
            bl |= string.startsWith(":fork:");
            bl |= string.startsWith(":ext:");
        }
        if (!bl) {
            string2 = NbBundle.getMessage((Class)CheckoutWizard.class, (String)"BK1000");
        } else {
            try {
                CVSRoot.parse((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string2 = NbBundle.getMessage((Class)RepositoryStep.class, (String)"BK2021") + illegalArgumentException.getLocalizedMessage();
            }
        }
        if (string2 != null) {
            this.invalid(string2);
        }
        return string2 == null;
    }

    private void onCvsRootChange() {
        if (this.validateCvsRoot()) {
            this.valid();
            CVSRoot cVSRoot = this.getCVSRoot();
            if (!this.userVisitedProxySettings) {
                this.proxyDescriptor = CvsRootSettings.getProxyFor(cVSRoot);
            }
            if ("ext".equals(cVSRoot.getMethod()) && CvsRootSettings.hasExtSettingsFor(cVSRoot)) {
                CvsRootSettings.ExtSettings extSettings = CvsRootSettings.getExtSettingsFor(cVSRoot);
                this.repositoryPanel.internalSshRadioButton.setSelected(extSettings.extUseInternalSsh);
                this.repositoryPanel.extPasswordField.setText(extSettings.extPassword);
                this.repositoryPanel.extREmemberPasswordCheckBox.setSelected(extSettings.extRememberPassword);
                this.repositoryPanel.extCommandTextField.setText(extSettings.extCommand);
            }
            this.schedulePasswordUpdate();
        }
        this.updateVisibility();
        this.updateLabel();
    }

    private void updateLabel() {
        String string = this.selectedCvsRoot();
        if (string.startsWith(":pserver:")) {
            this.repositoryPanel.descLabel.setText("(:pserver:username@hostname:/repository_path)");
        } else if (string.startsWith(":local:")) {
            this.repositoryPanel.descLabel.setText("(:local:/repository_path)");
        } else if (string.startsWith(":fork:")) {
            this.repositoryPanel.descLabel.setText("(:fork:/repository_path)");
        } else if (string.startsWith(":ext:")) {
            this.repositoryPanel.descLabel.setText("(:ext:username@hostname:/repository_path)");
        } else {
            this.repositoryPanel.descLabel.setText(NbBundle.getMessage((Class)CheckoutWizard.class, (String)"BK1014"));
        }
    }

    private void updateVisibility() {
        String string = this.selectedCvsRoot();
        boolean bl = string.startsWith(":pserver:");
        boolean bl2 = string.startsWith(":ext:");
        this.repositoryPanel.passwordTextField.setVisible(bl);
        this.repositoryPanel.pPaswordLabel.setVisible(bl);
        this.repositoryPanel.internalSshRadioButton.setVisible(bl2);
        this.repositoryPanel.extSshRadioButton.setVisible(bl2);
        this.repositoryPanel.extPasswordLabel5.setVisible(bl2);
        this.repositoryPanel.extPasswordField.setVisible(bl2);
        this.repositoryPanel.extREmemberPasswordCheckBox.setVisible(bl2);
        this.repositoryPanel.extCommandLabel.setVisible(bl2);
        this.repositoryPanel.extCommandTextField.setVisible(bl2);
        this.repositoryPanel.proxyConfigurationButton.setVisible(bl || bl2);
    }

    private String selectedCvsRoot() {
        if (this.initialCvsRoot != null) {
            return this.initialCvsRoot;
        }
        final String[] stringArray = new String[1];
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    stringArray[0] = (String)((RepositoryStep)RepositoryStep.this).repositoryPanel.rootComboBox.getEditor().getItem();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
            return stringArray[0];
        }
        catch (InterruptedException interruptedException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.notify((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.notify((Throwable)invocationTargetException);
        }
        return null;
    }

    private CVSRoot getCVSRoot() {
        try {
            String string = this.selectedCvsRoot();
            return CVSRoot.parse((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private void schedulePasswordUpdate() {
        String string = this.selectedCvsRoot();
        if (string.startsWith(":pserver:")) {
            this.passwordExpected = true;
            this.updatePasswordTask.schedule(10);
        }
    }

    private void cancelPasswordUpdate() {
        this.passwordExpected = false;
    }

    private void onPasswordChange() {
        this.cancelPasswordUpdate();
        this.scrambledPassword = null;
        this.valid();
    }

    private void setValid() {
        this.valid();
    }

    private void onProxyConfiguration() {
        ProxySelector proxySelector = new ProxySelector();
        proxySelector.setProxyDescriptor(this.proxyDescriptor);
        ProxyDescriptor proxyDescriptor = proxySelector.selectProxy();
        if (proxyDescriptor != null) {
            this.proxyDescriptor = proxyDescriptor;
            this.userVisitedProxySettings = true;
            this.valid();
        }
    }

    private void editRoot() {
        String string = this.selectedCvsRoot();
        if ((string = RootWizard.editCvsRoot(string)) != null) {
            this.repositoryPanel.rootComboBox.setSelectedItem(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.repositoryPanel.proxyConfigurationButton == actionEvent.getSource()) {
            this.onProxyConfiguration();
        } else if (this.repositoryPanel.rootComboBox == actionEvent.getSource()) {
            this.onCvsRootChange();
        } else if (this.repositoryPanel.editButton == actionEvent.getSource()) {
            this.editRoot();
        } else if (this.repositoryPanel.extSshRadioButton == actionEvent.getSource()) {
            this.setValid();
            this.validateCvsRoot();
        } else if (this.repositoryPanel.internalSshRadioButton == actionEvent.getSource()) {
            this.setValid();
            this.validateCvsRoot();
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unexpected event source: " + actionEvent.getSource()));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    private void textChanged(final DocumentEvent documentEvent) {
        if (this.internalDocumentChange) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (documentEvent.getDocument() == ((RepositoryStep)RepositoryStep.this).repositoryPanel.passwordTextField.getDocument()) {
                    RepositoryStep.this.onPasswordChange();
                } else if (documentEvent.getDocument() == ((JTextComponent)((RepositoryStep)RepositoryStep.this).repositoryPanel.rootComboBox.getEditor().getEditorComponent()).getDocument()) {
                    RepositoryStep.this.onCvsRootChange();
                } else if (documentEvent.getDocument() == ((RepositoryStep)RepositoryStep.this).repositoryPanel.extPasswordField.getDocument()) {
                    RepositoryStep.this.setValid();
                    RepositoryStep.this.validateCvsRoot();
                } else if (documentEvent.getDocument() == ((RepositoryStep)RepositoryStep.this).repositoryPanel.extCommandTextField.getDocument()) {
                    RepositoryStep.this.setValid();
                    RepositoryStep.this.validateCvsRoot();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void prepareValidation() {
        this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)CheckoutWizard.class, (String)"BK2012"));
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progress);
        JButton jButton = new JButton(NbBundle.getMessage((Class)RepositoryStep.class, (String)"BK2022"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RepositoryStep.this.backgroundValidationThread != null) {
                    RepositoryStep.this.backgroundValidationThread.interrupt();
                }
            }
        });
        this.progressComponent = new JPanel();
        this.progressComponent.setLayout(new BorderLayout(6, 0));
        this.progressLabel = new JLabel();
        this.progressComponent.add((Component)this.progressLabel, "North");
        this.progressComponent.add((Component)jComponent, "Center");
        this.progressComponent.add((Component)jButton, "After");
        this.progress.start();
        this.repositoryPanel.jPanel1.setLayout(new BorderLayout());
        this.repositoryPanel.jPanel1.add((Component)this.progressComponent, "South");
        this.repositoryPanel.jPanel1.revalidate();
        this.editable(false);
    }

    private String getPassword() {
        return new String(this.repositoryPanel.passwordTextField.getPassword());
    }

    public String getCvsRoot() {
        return this.selectedCvsRoot();
    }

    public ProxyDescriptor getProxyDescriptor() {
        return this.proxyDescriptor;
    }

    public String getScrambledPassword() {
        if (this.scrambledPassword == null) {
            String string = this.getPassword();
            this.scrambledPassword = StandardScrambler.getInstance().scramble(string);
        }
        return this.scrambledPassword;
    }

    static {
        $assertionsDisabled = !RepositoryStep.class.desiredAssertionStatus();
    }
}

