/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.util;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.versioning.system.cvss.util.FlatFolder;
import org.netbeans.modules.versioning.system.cvss.util.Utils;

public class Context
implements Serializable {
    public static final Context Empty = new Context(Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    private static final long serialVersionUID = 1L;
    private final List filteredFiles;
    private final List rootFiles;
    private final List exclusions;

    public Context(List list, List list2, List list3) {
        this.filteredFiles = list;
        this.rootFiles = list2;
        this.exclusions = list3;
        while (this.normalize()) {
        }
    }

    private boolean normalize() {
        Iterator iterator = this.rootFiles.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            Iterator iterator2 = this.exclusions.iterator();
            while (iterator2.hasNext()) {
                File file2 = (File)iterator2.next();
                if (!Utils.isParentOrEqual(file2, file)) continue;
                iterator2.remove();
                this.exclusionRemoved(file2, file);
                return true;
            }
        }
        this.removeDuplicates(this.rootFiles);
        this.removeDuplicates(this.exclusions);
        return false;
    }

    private void removeDuplicates(List list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            File file = (File)iterator.next();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                File file2 = (File)iterator2.next();
                if (Utils.isParentOrEqual(file2, file) && (file.isFile() || !(file2 instanceof FlatFolder))) continue block0;
                if (!Utils.isParentOrEqual(file, file2) || !file2.isFile() && file instanceof FlatFolder) continue;
                iterator2.remove();
            }
            arrayList.add(file);
        }
        list.clear();
        list.addAll(arrayList);
    }

    private void exclusionRemoved(File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (Utils.isParentOrEqual(file2, file3)) continue;
            this.exclusions.add(file3);
        }
    }

    public List getRoots() {
        return this.rootFiles;
    }

    public List getExclusions() {
        return this.exclusions;
    }

    public File[] getFiles() {
        return this.filteredFiles.toArray(new File[this.filteredFiles.size()]);
    }

    public File[] getRootFiles() {
        return this.rootFiles.toArray(new File[this.rootFiles.size()]);
    }

    public boolean contains(File file) {
        Iterator iterator = this.rootFiles.iterator();
        block0: while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            if (!Utils.isParentOrEqual(file2, file)) continue;
            Iterator iterator2 = this.exclusions.iterator();
            while (iterator2.hasNext()) {
                File file3 = (File)iterator2.next();
                if (!Utils.isParentOrEqual(file3, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }
}

