/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.modules.debugger.ui.Utils;
import org.openide.util.NbBundle;

public class DebuggerAction
extends AbstractAction {
    private Object action;

    private DebuggerAction(Object object) {
        this.action = object;
        new Listener(this);
        this.setEnabled(DebuggerAction.getCurrentActionsManager().isEnabled(this.getAction()));
    }

    public Object getAction() {
        return this.action;
    }

    public Object getValue(String string) {
        if (string == "Name") {
            return NbBundle.getMessage((Class)DebuggerAction.class, (String)((String)super.getValue(string)));
        }
        Object object = super.getValue(string);
        if (string == "SmallIcon" && object instanceof String) {
            object = Utils.getIcon((String)object);
        }
        return object;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DebuggerAction.getCurrentActionsManager().postAction(this.getAction());
    }

    private static ActionsManager getCurrentActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    public static DebuggerAction createContinueAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_CONTINUE);
        debuggerAction.putValue("Name", "CTL_Continue_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Continue");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Continue.gif");
        return debuggerAction;
    }

    public static DebuggerAction createFixAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_FIX);
        debuggerAction.putValue("Name", "CTL_Fix_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Fix");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Fix.gif");
        return debuggerAction;
    }

    public static DebuggerAction createKillAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_KILL);
        debuggerAction.putValue("Name", "CTL_KillAction_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Kill");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Kill.gif");
        debuggerAction.setEnabled(false);
        return debuggerAction;
    }

    public static DebuggerAction createMakeCalleeCurrentAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_MAKE_CALLEE_CURRENT);
        debuggerAction.putValue("Name", "CTL_MakeCalleeCurrentAction_name");
        return debuggerAction;
    }

    public static DebuggerAction createMakeCallerCurrentAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_MAKE_CALLER_CURRENT);
        debuggerAction.putValue("Name", "CTL_MakeCallerCurrentAction_name");
        return debuggerAction;
    }

    public static DebuggerAction createPauseAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_PAUSE);
        debuggerAction.putValue("Name", "CTL_Pause_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Pause");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Pause.gif");
        return debuggerAction;
    }

    public static DebuggerAction createPopTopmostCallAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_POP_TOPMOST_CALL);
        debuggerAction.putValue("Name", "CTL_PopTopmostCallAction_name");
        return debuggerAction;
    }

    public static DebuggerAction createRunIntoMethodAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_RUN_INTO_METHOD);
        debuggerAction.putValue("Name", "CTL_Run_into_method_action_name");
        return debuggerAction;
    }

    public static DebuggerAction createRunToCursorAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_RUN_TO_CURSOR);
        debuggerAction.putValue("Name", "CTL_Run_to_cursor_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/RunToCursor");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/RunToCursor.gif");
        return debuggerAction;
    }

    public static DebuggerAction createStepIntoAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_STEP_INTO);
        debuggerAction.putValue("Name", "CTL_Step_into_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/StepInto");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepInto.gif");
        return debuggerAction;
    }

    public static DebuggerAction createStepOutAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_STEP_OUT);
        debuggerAction.putValue("Name", "CTL_Step_out_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/StepOut");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepOut.gif");
        return debuggerAction;
    }

    public static DebuggerAction createStepOverAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_STEP_OVER);
        debuggerAction.putValue("Name", "CTL_Step_over_action_name");
        debuggerAction.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/StepOver");
        debuggerAction.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepOver.gif");
        return debuggerAction;
    }

    public static DebuggerAction createToggleBreakpointAction() {
        DebuggerAction debuggerAction = new DebuggerAction(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
        debuggerAction.putValue("Name", "CTL_Toggle_breakpoint");
        return debuggerAction;
    }

    static class Listener
    extends DebuggerManagerAdapter
    implements ActionsManagerListener {
        private ActionsManager currentActionsManager;
        private WeakReference ref;

        Listener(DebuggerAction debuggerAction) {
            this.ref = new WeakReference<DebuggerAction>(debuggerAction);
            DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            this.updateCurrentActionsManager();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DebuggerAction debuggerAction = this.getDebuggerAction();
            if (debuggerAction == null) {
                return;
            }
            this.updateCurrentActionsManager();
            boolean bl = this.currentActionsManager.isEnabled(debuggerAction.getAction());
            SwingUtilities.invokeLater(new Runnable(this, debuggerAction, bl){
                private final /* synthetic */ DebuggerAction val$da;
                private final /* synthetic */ boolean val$en;
                private final /* synthetic */ Listener this$0;
                {
                    this.this$0 = listener;
                    this.val$da = debuggerAction;
                    this.val$en = bl;
                }

                public void run() {
                    this.val$da.setEnabled(this.val$en);
                }
            });
        }

        public void actionPerformed(Object object) {
        }

        public void actionStateChanged(Object object, boolean bl) {
            DebuggerAction debuggerAction = this.getDebuggerAction();
            if (debuggerAction == null) {
                return;
            }
            if (object != debuggerAction.getAction()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(this, debuggerAction, bl){
                private final /* synthetic */ DebuggerAction val$da;
                private final /* synthetic */ boolean val$enabled;
                private final /* synthetic */ Listener this$0;
                {
                    this.this$0 = listener;
                    this.val$da = debuggerAction;
                    this.val$enabled = bl;
                }

                public void run() {
                    this.val$da.setEnabled(this.val$enabled);
                }
            });
        }

        private void updateCurrentActionsManager() {
            ActionsManager actionsManager = DebuggerAction.getCurrentActionsManager();
            if (this.currentActionsManager == actionsManager) {
                return;
            }
            if (this.currentActionsManager != null) {
                this.currentActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            if (actionsManager != null) {
                actionsManager.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            this.currentActionsManager = actionsManager;
        }

        private DebuggerAction getDebuggerAction() {
            DebuggerAction debuggerAction = (DebuggerAction)this.ref.get();
            if (debuggerAction == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
                if (this.currentActionsManager != null) {
                    this.currentActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
                }
                this.currentActionsManager = null;
                return null;
            }
            return debuggerAction;
        }
    }
}

