/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.debugger.ui.Utils;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ViewActions
extends AbstractAction {
    private String viewName;

    private ViewActions(String string) {
        this.viewName = string;
    }

    public Object getValue(String string) {
        if (string == "Name") {
            return NbBundle.getMessage((Class)ViewActions.class, (String)((String)super.getValue(string)));
        }
        Object object = super.getValue(string);
        if (string == "SmallIcon" && object instanceof String) {
            object = Utils.getIcon((String)object);
        }
        return object;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ViewActions.openComponent(this.viewName, true);
    }

    static void openComponent(String string, boolean bl) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
        if (topComponent == null) {
            throw new IllegalArgumentException(string);
        }
        topComponent.open();
        if (bl) {
            topComponent.requestActive();
        }
    }

    public static Action createBreakpointsViewAction() {
        ViewActions viewActions = new ViewActions("breakpointsView");
        viewActions.putValue("Name", "CTL_BreakpointsAction");
        viewActions.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint");
        return viewActions;
    }

    public static Action createCallStackViewAction() {
        ViewActions viewActions = new ViewActions("callstackView");
        viewActions.putValue("Name", "CTL_CallStackAction");
        viewActions.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame");
        return viewActions;
    }

    public static Action createLocalsViewAction() {
        ViewActions viewActions = new ViewActions("localsView");
        viewActions.putValue("Name", "CTL_LocalVariablesAction");
        viewActions.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/localsView/LocalVariable");
        return viewActions;
    }

    public static Action createSessionsViewAction() {
        ViewActions viewActions = new ViewActions("sessionsView");
        viewActions.putValue("Name", "CTL_SessionsAction");
        viewActions.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/sessionsView/Session");
        return viewActions;
    }

    public static Action createThreadsViewAction() {
        ViewActions viewActions = new ViewActions("threadsView");
        viewActions.putValue("Name", "CTL_ThreadsAction");
        viewActions.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/threadsView/ThreadGroup");
        return viewActions;
    }

    public static Action createWatchesViewAction() {
        ViewActions viewActions = new ViewActions("watchesView");
        viewActions.putValue("Name", "CTL_WatchesAction");
        viewActions.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/watchesView/Watch");
        return viewActions;
    }
}

