/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class BreakpointsTreeModel
implements TreeModel {
    private static final Comparator BREAKPOINTS_COMPARATOR = new BreakpointsComparator();
    private Listener listener;
    private Vector listeners = new Vector();

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
            TreeSet<Object> treeSet = new TreeSet<Object>(BREAKPOINTS_COMPARATOR);
            int n3 = breakpointArray.length;
            for (int i = 0; i < n3; ++i) {
                if (breakpointArray[i].getGroupName().equals("")) {
                    treeSet.add(breakpointArray[i]);
                    continue;
                }
                treeSet.add(breakpointArray[i].getGroupName());
            }
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            if (n2 == 0) {
                return new ArrayList(treeSet).toArray();
            }
            n2 = Math.min(treeSet.size(), n2);
            n = Math.min(treeSet.size(), n);
            return new ArrayList(treeSet).subList(n, n2).toArray();
        }
        if (object instanceof String) {
            String string = (String)object;
            Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
            TreeSet<Breakpoint> treeSet = new TreeSet<Breakpoint>(BREAKPOINTS_COMPARATOR);
            int n4 = breakpointArray.length;
            for (int i = 0; i < n4; ++i) {
                if (!breakpointArray[i].getGroupName().equals(string)) continue;
                treeSet.add(breakpointArray[i]);
            }
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            if (n2 == 0) {
                return new ArrayList(treeSet).toArray();
            }
            n2 = Math.min(treeSet.size(), n2);
            n = Math.min(treeSet.size(), n);
            return new ArrayList(treeSet).subList(n, n2).toArray();
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return this.getChildren(object, 0, 0).length;
        }
        if (object instanceof String) {
            return this.getChildren(object, 0, 0).length;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof Breakpoint) {
            return true;
        }
        if (object instanceof String) {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private void fireTreeChanged(ModelEvent modelEvent) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(modelEvent);
        }
    }

    private static class BreakpointsComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof Comparable && object.getClass() == object2.getClass()) {
                return ((Comparable)object).compareTo(object2);
            }
            if (object instanceof String) {
                if (object2 instanceof String) {
                    return ((String)object).compareTo((String)object2);
                }
                return -1;
            }
            if (object2 instanceof String) {
                return 1;
            }
            return ((Breakpoint)object).toString().compareTo(((Breakpoint)object2).toString());
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference model;

        public Listener(BreakpointsTreeModel breakpointsTreeModel) {
            this.model = new WeakReference<BreakpointsTreeModel>(breakpointsTreeModel);
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
            Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
            int n = breakpointArray.length;
            for (int i = 0; i < n; ++i) {
                breakpointArray[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private BreakpointsTreeModel getModel() {
            BreakpointsTreeModel breakpointsTreeModel = (BreakpointsTreeModel)this.model.get();
            if (breakpointsTreeModel == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
                Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
                int n = breakpointArray.length;
                for (int i = 0; i < n; ++i) {
                    breakpointArray[i].removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            return breakpointsTreeModel;
        }

        public void breakpointAdded(Breakpoint breakpoint) {
            BreakpointsTreeModel breakpointsTreeModel = this.getModel();
            if (breakpointsTreeModel == null) {
                return;
            }
            breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
            breakpointsTreeModel.fireTreeChanged();
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
            BreakpointsTreeModel breakpointsTreeModel = this.getModel();
            if (breakpointsTreeModel == null) {
                return;
            }
            breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
            breakpointsTreeModel.fireTreeChanged();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BreakpointsTreeModel breakpointsTreeModel = this.getModel();
            if (breakpointsTreeModel == null) {
                return;
            }
            if (!(propertyChangeEvent.getSource() instanceof Breakpoint)) {
                return;
            }
            if (propertyChangeEvent.getPropertyName() == "groupName") {
                breakpointsTreeModel.fireTreeChanged();
            } else {
                breakpointsTreeModel.fireTreeChanged((ModelEvent)new ModelEvent.NodeChanged((Object)breakpointsTreeModel, propertyChangeEvent.getSource()));
            }
        }
    }
}

