/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class ColumnModels {
    static /* synthetic */ Class class$org$netbeans$modules$debugger$ui$models$ColumnModels;

    public static ColumnModel createDefaultBreakpointsColumn() {
        return new AbstractColumn("DefaultBreakpointColumn", "CTL_BreakpointView_Column_Name_Name", "CTL_BreakpointView_Column_Name_Desc", null);
    }

    public static ColumnModel createBreakpointEnabledColumn() {
        return new AbstractColumn("BreakpointEnabled", "CTL_BreakpointView_Column_Enabled_Name", "CTL_BreakpointView_Column_Enabled_Desc", Boolean.TYPE);
    }

    public static ColumnModel createDefaultCallStackColumn() {
        return new AbstractColumn("DefaultCallStackColumn", "CTL_CallstackView_Column_Name_Name", "CTL_CallstackView_Column_Name_Desc", null);
    }

    public static ColumnModel createCallStackLocationColumn() {
        return new AbstractColumn("CallStackFrameLocation", "CTL_CallstackView_Column_Location_Name", "CTL_CallstackView_Column_Location_Desc", String.class, false);
    }

    public static ColumnModel createDefaultLocalsColumn() {
        return new AbstractColumn("DefaultLocalsColumn", "CTL_LocalsView_Column_Name_Name", "CTL_LocalsView_Column_Name_Desc", null);
    }

    public static ColumnModel createLocalsToStringColumn() {
        return new AbstractColumn("LocalsToString", "LocalsValue", null, "CTL_LocalsView_Column_ToString_Name", "CTL_LocalsView_Column_ToString_Desc", String.class, false);
    }

    public static ColumnModel createLocalsTypeColumn() {
        return new AbstractColumn("LocalsType", null, "LocalsValue", "CTL_LocalsView_Column_Type_Name", "CTL_LocalsView_Column_Type_Desc", String.class, true);
    }

    public static ColumnModel createLocalsValueColumn() {
        return new AbstractColumn("LocalsValue", "LocalsType", "LocalsToString", "CTL_LocalsView_Column_Value_Name", "CTL_LocalsView_Column_Value_Desc", String.class, true);
    }

    public static ColumnModel createDefaultSessionColumn() {
        return new AbstractColumn("DefaultSessionColumn", "CTL_SessionsView_Column_Name_Name", "CTL_SessionsView_Column_Name_Desc", null);
    }

    public static ColumnModel createSessionHostNameColumn() {
        return new AbstractColumn("SessionHostName", "SessionLanguage", null, "CTL_SessionsView_Column_HostName_Name", "CTL_SessionsView_Column_HostName_Desc", String.class, false);
    }

    public static ColumnModel createSessionStateColumn() {
        return new AbstractColumn("SessionState", null, "SessionHostName", "CTL_SessionsView_Column_State_Name", "CTL_SessionsView_Column_State_Desc", String.class, true);
    }

    public static ColumnModel createSessionLanguageColumn() {
        return new AbstractColumn("SessionLanguage", "SessionState", "SessionHostName", "CTL_SessionsView_Column_Language_Name", "CTL_SessionsView_Column_Language_Desc", Session.class, true, new LanguagePropertyEditor());
    }

    public static ColumnModel createDefaultThreadColumn() {
        return new AbstractColumn("DefaultThreadColumn", "CTL_ThreadsView_Column_Name_Name", "CTL_ThreadsView_Column_Name_Desc", null);
    }

    public static ColumnModel createThreadStateColumn() {
        return new AbstractColumn("ThreadState", null, "ThreadSuspended", "CTL_ThreadsView_Column_State_Name", "CTL_ThreadsView_Column_State_Desc", String.class, true);
    }

    public static ColumnModel createThreadSuspendedColumn() {
        return new AbstractColumn("ThreadSuspended", "ThreadState", null, "CTL_ThreadsView_Column_Suspended_Name", "CTL_ThreadsView_Column_Suspended_Desc", Boolean.TYPE, false);
    }

    public static ColumnModel createDefaultWatchesColumn() {
        return new AbstractColumn("DefaultWatchesColumn", "CTL_WatchesView_Column_Name_Name", "CTL_WatchesView_Column_Name_Desc", null);
    }

    public static ColumnModel createWatchToStringColumn() {
        return new AbstractColumn("WatchToString", "WatchValue", null, "CTL_WatchesView_Column_ToString_Name", "CTL_WatchesView_Column_ToString_Desc", String.class, false);
    }

    public static ColumnModel createWatchTypeColumn() {
        return new AbstractColumn("WatchType", null, "WatchValue", "CTL_WatchesView_Column_Type_Name", "CTL_WatchesView_Column_Type_Desc", String.class, true);
    }

    public static ColumnModel createWatchValueColumn() {
        return new AbstractColumn("WatchValue", "WatchType", "WatchToString", "CTL_WatchesView_Column_Value_Name", "CTL_WatchesView_Column_Value_Desc", String.class, true);
    }

    private static class LanguagePropertyEditor
    extends PropertyEditorSupport {
        private LanguagePropertyEditor() {
        }

        public void setValue(Object object) {
            if (object != null && !(object instanceof Session)) {
                ErrorManager.getDefault().notify((Throwable)new IllegalArgumentException("Value " + object + " is not an instance of Session!"));
            }
            super.setValue(object);
        }

        public String[] getTags() {
            if (this.getValue() == null) {
                return new String[0];
            }
            String[] stringArray = ((Session)this.getValue()).getSupportedLanguages();
            return stringArray;
        }

        public String getAsText() {
            String string = ((Session)this.getValue()).getCurrentLanguage();
            return string;
        }

        public void setAsText(String string) {
            ((Session)this.getValue()).setCurrentLanguage(string);
        }
    }

    private static class AbstractColumn
    extends ColumnModel {
        private String id;
        private String previousColumnId = null;
        private String nextColumnId = null;
        private String displayName;
        private String shortDescription;
        private Class type;
        private boolean defaultVisible;
        private PropertyEditor propertyEditor;
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public AbstractColumn(String string, String string2, String string3, Class clazz) {
            this(string, string2, string3, clazz, true);
        }

        public AbstractColumn(String string, String string2, String string3, Class clazz, boolean bl) {
            this(string, null, null, string2, string3, clazz, bl);
        }

        public AbstractColumn(String string, String string2, String string3, String string4, String string5, Class clazz, boolean bl) {
            this(string, string2, string3, string4, string5, clazz, bl, null);
        }

        public AbstractColumn(String string, String string2, String string3, String string4, String string5, Class clazz, boolean bl, PropertyEditor propertyEditor) {
            this.id = string;
            this.previousColumnId = string2;
            this.nextColumnId = string3;
            this.displayName = string4;
            this.shortDescription = string5;
            this.type = clazz;
            this.defaultVisible = bl;
            this.propertyEditor = propertyEditor;
        }

        public String getID() {
            return this.id;
        }

        public String getPreviuosColumnID() {
            return this.previousColumnId;
        }

        public String getNextColumnID() {
            return this.nextColumnId;
        }

        public String getDisplayName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$ui$models$ColumnModels == null ? (class$org$netbeans$modules$debugger$ui$models$ColumnModels = ColumnModels.class$("org.netbeans.modules.debugger.ui.models.ColumnModels")) : class$org$netbeans$modules$debugger$ui$models$ColumnModels)).getString(this.displayName);
        }

        public String getShortDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$ui$models$ColumnModels == null ? (class$org$netbeans$modules$debugger$ui$models$ColumnModels = ColumnModels.class$("org.netbeans.modules.debugger.ui.models.ColumnModels")) : class$org$netbeans$modules$debugger$ui$models$ColumnModels)).getString(this.shortDescription);
        }

        public Class getType() {
            return this.type;
        }

        public void setVisible(boolean bl) {
            this.properties.setBoolean(this.getID() + ".visible", bl);
        }

        public void setSorted(boolean bl) {
            this.properties.setBoolean(this.getID() + ".sorted", bl);
        }

        public void setSortedDescending(boolean bl) {
            this.properties.setBoolean(this.getID() + ".sortedDescending", bl);
        }

        public int getCurrentOrderNumber() {
            return this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
        }

        public void setCurrentOrderNumber(int n) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", n);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int n) {
            this.properties.setInt(this.getID() + ".columnWidth", n);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", this.defaultVisible);
        }

        public boolean isSorted() {
            return this.properties.getBoolean(this.getID() + ".sorted", false);
        }

        public boolean isSortedDescending() {
            return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
        }

        public PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }
    }
}

