/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class SessionsActionsProvider
implements NodeActionsProvider {
    private static final Action FINISH_ALL_ACTION = new AbstractAction(NbBundle.getBundle((Class)SessionsActionsProvider.class).getString("CTL_SessionAction_FinishAll_Label")){

        public void actionPerformed(ActionEvent actionEvent) {
            Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
            int n = sessionArray.length;
            for (int i = 0; i < n; ++i) {
                sessionArray[i].kill();
            }
        }
    };
    private Action MAKE_CURRENT_ACTION = Models.createAction((String)NbBundle.getBundle((Class)SessionsActionsProvider.class).getString("CTL_SessionAction_MakeCurrent_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return DebuggerManager.getDebuggerManager().getCurrentSession() != object;
        }

        public void perform(Object[] objectArray) {
            DebuggerManager.getDebuggerManager().setCurrentSession((Session)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action FINISH_ACTION = Models.createAction((String)NbBundle.getBundle((Class)SessionsActionsProvider.class).getString("CTL_SessionAction_Finish_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ((Session)objectArray[i]).kill();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return new Action[]{FINISH_ALL_ACTION};
        }
        if (object instanceof Session) {
            return new Action[]{this.MAKE_CURRENT_ACTION, FINISH_ACTION, null, FINISH_ALL_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof Session) {
            if (DebuggerManager.getDebuggerManager().getCurrentSession() == object) {
                return;
            }
            DebuggerManager.getDebuggerManager().setCurrentSession((Session)object);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }
}

