/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class ContextProvider {
    private ContextProvider() {
    }

    public static Writer createWriterContextProvider(Writer writer, FileObject fileObject) {
        return new WriterProvider(writer, fileObject);
    }

    public static Reader createReaderContextProvider(Reader reader, FileObject fileObject) {
        return new ReaderProvider(reader, fileObject);
    }

    private static final class FileObjectContext
    extends FileObject {
        private static final String UNSUPPORTED = "The Restricted FileObject implementation allowing to get just read-only informations about name and location. It should prevent any manipulation with file or its content.";
        private final FileObject fo;

        public FileObjectContext(FileObject fileObject) {
            this.fo = fileObject;
        }

        public void addFileChangeListener(FileChangeListener fileChangeListener) {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public FileObject createData(String string, String string2) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public FileObject createFolder(String string) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public void delete(FileLock fileLock) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public Object getAttribute(String string) {
            return this.fo.getAttribute(string);
        }

        public Enumeration getAttributes() {
            return this.fo.getAttributes();
        }

        public FileObject[] getChildren() {
            return new FileObject[0];
        }

        public String getExt() {
            return this.fo.getExt();
        }

        public FileObject getFileObject(String string, String string2) {
            return null;
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fo.getFileSystem();
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public String getName() {
            return this.fo.getName();
        }

        public OutputStream getOutputStream(FileLock fileLock) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public FileObject getParent() {
            return this.fo.getParent();
        }

        public long getSize() {
            return this.fo.getSize();
        }

        public boolean isData() {
            return true;
        }

        public boolean isFolder() {
            return false;
        }

        public boolean isReadOnly() {
            return this.fo.isReadOnly();
        }

        public boolean isRoot() {
            return false;
        }

        public boolean isValid() {
            return this.fo.isValid();
        }

        public Date lastModified() {
            return this.fo.lastModified();
        }

        public FileLock lock() throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public void setAttribute(String string, Object object) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public void setImportant(boolean bl) {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }
    }

    private static final class ReaderProvider
    extends Reader
    implements Lookup.Provider {
        private final Reader orig;
        private final FileObject src;
        private Lookup lookup;

        public ReaderProvider(Reader reader, FileObject fileObject) {
            this.orig = reader;
            this.src = fileObject;
        }

        public void close() throws IOException {
            this.orig.close();
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            return this.orig.read(cArray, n, n2);
        }

        public Lookup getLookup() {
            if (this.lookup == null) {
                this.lookup = Lookups.singleton((Object)((Object)new FileObjectContext(this.src)));
            }
            return this.lookup;
        }
    }

    private static final class WriterProvider
    extends Writer
    implements Lookup.Provider {
        private final Writer orig;
        private final FileObject src;
        private Lookup lookup;

        public WriterProvider(Writer writer, FileObject fileObject) {
            this.orig = writer;
            this.src = fileObject;
        }

        public void close() throws IOException {
            this.orig.close();
        }

        public void flush() throws IOException {
            this.orig.flush();
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.orig.write(cArray, n, n2);
        }

        public Lookup getLookup() {
            if (this.lookup == null) {
                this.lookup = Lookups.singleton((Object)((Object)new FileObjectContext(this.src)));
            }
            return this.lookup;
        }
    }
}

