/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.settings.ContextProvider;
import org.netbeans.modules.settings.Env;
import org.netbeans.modules.settings.SaveSupport;
import org.netbeans.modules.settings.ScheduledRequest;
import org.netbeans.modules.settings.convertors.SerialDataNode;
import org.netbeans.spi.settings.Convertor;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

final class InstanceProvider
extends FileChangeAdapter
implements PropertyChangeListener,
FileSystem.AtomicAction {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance(InstanceProvider.class.getName());
    private static final boolean willLog = err.isLoggable(1);
    private final InstanceContent lkpContent;
    private final Lookup lookup;
    private final DataObject dobj;
    private final FileObject settingFO;
    private final FileObject providerFO;
    private final NodeConvertor node;
    private SaveSupport saver;
    private SaveCookie scCache;
    private boolean wasReportedProblem = false;
    private Set instanceOfSet;
    private String instanceClassName;
    final Object READWRITE_LOCK = new Object();
    private Convertor convertor;
    private ScheduledRequest request;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$nodes$Node;

    public InstanceProvider(DataObject dataObject, FileObject fileObject) {
        this.settingFO = dataObject.getPrimaryFile();
        this.providerFO = fileObject;
        this.dobj = dataObject;
        this.settingFO.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.settingFO));
        this.lkpContent = new InstanceContent();
        this.lkpContent.add((Object)this.createInstance(null));
        this.node = new NodeConvertor();
        this.lkpContent.add((Object)this, (InstanceContent.Convertor)this.node);
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.lkpContent);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    FileObject getProvider() {
        return this.providerFO;
    }

    FileObject getFile() {
        return this.settingFO;
    }

    DataObject getDataObject() {
        return this.dobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string == "savecookie") {
            this.provideSaveCookie();
        } else if (string == "fileChanged") {
            InstanceProvider instanceProvider = this;
            synchronized (instanceProvider) {
                this.instanceOfSet = null;
            }
            this.instanceCookieChanged(null);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        if (this.saver != null && fileEvent.firedFrom((FileSystem.AtomicAction)this.saver.getSaveCookie())) {
            return;
        }
        this.propertyChange(new PropertyChangeEvent(this, "fileChanged", null, null));
    }

    public void fileDeleted(FileEvent fileEvent) {
        if (this.saver != null && fileEvent.firedFrom((FileSystem.AtomicAction)this.saver.getSaveCookie())) {
            return;
        }
        this.releaseInstance();
    }

    private synchronized void attachToInstance(Object object) {
        if (this.saver != null) {
            this.saver.removePropertyChangeListener(this);
            this.getScheduledRequest().forceToFinish();
        }
        this.saver = this.createSaveSupport(object);
        this.saver.addPropertyChangeListener(this);
    }

    private InstanceCookie.Of createInstance(Object object) {
        return new InstanceCookieImpl(object);
    }

    private SaveSupport createSaveSupport(Object object) {
        return new SaveSupport(this, object);
    }

    private void provideSaveCookie() {
        SaveCookie saveCookie = this.saver.getSaveCookie();
        if (this.scCache != null) {
            if (!this.saver.isChanged()) {
                if (willLog) {
                    err.log("remove save cookie: " + this.dobj);
                }
                this.lkpContent.remove((Object)this.scCache);
                this.scCache = null;
                return;
            }
        } else if (this.saver.isChanged()) {
            this.scCache = saveCookie;
            if (willLog) {
                err.log("add save cookie: " + this.dobj + " cookie: " + saveCookie);
            }
            this.lkpContent.add((Object)saveCookie);
            return;
        }
    }

    private void releaseInstance() {
        SaveSupport saveSupport = this.saver;
        if (saveSupport != null) {
            saveSupport.removePropertyChangeListener(this);
        }
        if (this.scCache != null) {
            if (willLog) {
                err.log("release instance and remove save cookie: " + this.dobj);
            }
            this.lkpContent.remove((Object)this.scCache);
            this.getScheduledRequest().cancel();
            this.scCache = null;
        }
        this.lkpContent.remove((Object)this, (InstanceContent.Convertor)this.node);
    }

    private void instanceCookieChanged(Object object) {
        if (willLog) {
            err.log("instanceCookieChanged: " + this.dobj + " inst: " + object);
        }
        this.releaseInstance();
        this.lkpContent.add((Object)this, (InstanceContent.Convertor)this.node);
        Object object2 = this.lookup.lookup(InstanceCookie.class);
        this.lkpContent.remove(object2);
        InstanceCookie.Of of = this.createInstance(object);
        this.lkpContent.add((Object)of);
        if (willLog) {
            err.log("cookie replaced: " + this.dobj + " old: " + object2 + " new: " + of);
        }
    }

    Convertor getConvertor() throws IOException {
        if (this.convertor == null) {
            Object object = this.providerFO.getAttribute("settings.convertor");
            if (object == null || !(object instanceof Convertor)) {
                throw new IOException("cannot create convertor: " + object + ", provider:" + this.providerFO);
            }
            this.convertor = (Convertor)object;
        }
        return this.convertor;
    }

    private synchronized String getInstanceClassName() {
        if (this.instanceClassName == null) {
            Object object = this.providerFO.getAttribute("settings.instanceClass");
            this.instanceClassName = object != null && object instanceof String ? Utilities.translate((String)((String)object)) : null;
        }
        return this.instanceClassName;
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)) + '[' + this.getDataObject() + ", " + this.getProvider() + ']';
    }

    public void run() throws IOException {
        this.saver.writeDown();
    }

    synchronized ScheduledRequest getScheduledRequest() {
        if (this.request == null) {
            this.request = new ScheduledRequest(this.settingFO, this);
        }
        return this.request;
    }

    private static final class NodeConvertor
    implements InstanceContent.Convertor {
        NodeConvertor() {
        }

        public Object convert(Object object) {
            InstanceProvider instanceProvider = (InstanceProvider)object;
            return new SerialDataNode(instanceProvider.getDataObject());
        }

        public Class type(Object object) {
            return class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = InstanceProvider.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node;
        }

        public String id(Object object) {
            return object.toString();
        }

        public String displayName(Object object) {
            return object.toString();
        }
    }

    final class InstanceCookieImpl
    implements InstanceCookie.Of {
        private SoftReference cachedInstance;

        public InstanceCookieImpl(Object object) {
            this.setCachedInstance(object);
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            String string = InstanceProvider.this.getInstanceClassName();
            if (string == null) {
                return this.instanceCreate().getClass();
            }
            return ((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = InstanceProvider.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).loadClass(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object instanceCreate() throws IOException, ClassNotFoundException {
            Object object;
            Object object2;
            Object object3 = this;
            synchronized (object3) {
                object2 = this.getCachedInstance();
                if (object2 != null) {
                    return object2;
                }
            }
            try {
                object3 = InstanceProvider.this.READWRITE_LOCK;
                synchronized (object3) {
                    object = ContextProvider.createReaderContextProvider(new InputStreamReader(InstanceProvider.this.settingFO.getInputStream(), "UTF-8"), InstanceProvider.this.getFile());
                    object2 = InstanceProvider.this.getConvertor().read((Reader)object);
                }
            }
            catch (IOException iOException) {
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)iOException, InstanceProvider.this.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (ClassNotFoundException)ErrorManager.getDefault().annotate((Throwable)classNotFoundException, InstanceProvider.this.toString());
            }
            object3 = this;
            synchronized (object3) {
                object = this.getCachedInstance();
                if (object != null) {
                    return object;
                }
                this.setCachedInstance(object2);
            }
            InstanceProvider.this.attachToInstance(object2);
            return object2;
        }

        public String instanceName() {
            String string = InstanceProvider.this.getInstanceClassName();
            if (string != null) {
                return string;
            }
            Exception exception = null;
            try {
                return this.instanceClass().getName();
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception = classNotFoundException;
            }
            if (exception != null && !InstanceProvider.this.wasReportedProblem) {
                InstanceProvider.this.wasReportedProblem = true;
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)exception, InstanceProvider.this.dobj.toString());
                errorManager.notify(1, (Throwable)exception);
            }
            return "Unknown";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean instanceOf(Class clazz) {
            Object object = InstanceProvider.this;
            synchronized (object) {
                if (InstanceProvider.this.instanceOfSet == null) {
                    InstanceProvider.this.instanceOfSet = Env.parseAttribute(InstanceProvider.this.providerFO.getAttribute("settings.instanceOf"));
                    Iterator iterator = InstanceProvider.this.instanceOfSet.iterator();
                    InstanceProvider.this.instanceOfSet = new HashSet(InstanceProvider.this.instanceOfSet.size() * 5 / 4);
                    while (iterator.hasNext()) {
                        InstanceProvider.this.instanceOfSet.add(Utilities.translate((String)((String)iterator.next())));
                    }
                }
            }
            if (InstanceProvider.this.instanceOfSet.isEmpty()) {
                object = null;
                try {
                    return clazz.isAssignableFrom(this.instanceClass());
                }
                catch (IOException iOException) {
                    object = iOException;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object = classNotFoundException;
                }
                if (object != null && !InstanceProvider.this.wasReportedProblem) {
                    InstanceProvider.this.wasReportedProblem = true;
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)object, InstanceProvider.this.dobj.toString());
                    errorManager.notify(1, (Throwable)object);
                }
                return false;
            }
            return InstanceProvider.this.instanceOfSet.contains(clazz.getName());
        }

        public void setInstance(Object object, boolean bl) throws IOException {
            InstanceProvider.this.instanceCookieChanged(object);
            if (object != null) {
                InstanceProvider.this.attachToInstance(object);
                if (bl) {
                    InstanceProvider.this.getScheduledRequest().runAndWait();
                }
            }
        }

        private Object getCachedInstance() {
            return this.cachedInstance.get();
        }

        private void setCachedInstance(Object object) {
            this.cachedInstance = new SoftReference<Object>(object);
        }
    }
}

