/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.EditorKit;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.modules.ant.debugger.DebuggerAntLogger;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

final class AdvancedActionPanel
extends JPanel {
    private static final String ATTR_TARGETS = "org.apache.tools.ant.module.preferredTargets";
    private static final String ATTR_PROPERTIES = "org.apache.tools.ant.module.preferredProperties";
    private static final String ATTR_VERBOSITY = "org.apache.tools.ant.module.preferredVerbosity";
    private static final String[] VERBOSITIES;
    private static final int[] VERBOSITY_LEVELS;
    private final AntProjectCookie project;
    private final Set allTargets;
    private String defaultTarget = null;
    private JLabel propertiesLabel;
    private JEditorPane propertiesPane;
    private JScrollPane propertiesScrollPane;
    private JComboBox targetComboBox;
    private JTextField targetDescriptionField;
    private JLabel targetDescriptionLabel;
    private JLabel targetLabel;
    private JComboBox verbosityComboBox;
    private JLabel verbosityLabel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AdvancedActionPanel(AntProjectCookie antProjectCookie, Set set) {
        this.project = antProjectCookie;
        this.allTargets = set;
        this.initComponents();
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)NbBundle.getMessage((Class)AdvancedActionPanel.class, (String)"AdvancedActionsPanel.targetLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.targetDescriptionLabel, (String)NbBundle.getMessage((Class)AdvancedActionPanel.class, (String)"AdvancedActionsPanel.targetDescriptionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.propertiesLabel, (String)NbBundle.getMessage((Class)AdvancedActionPanel.class, (String)"AdvancedActionsPanel.propertiesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.verbosityLabel, (String)NbBundle.getMessage((Class)AdvancedActionPanel.class, (String)"AdvancedActionsPanel.verbosityLabel.text"));
        EditorKit editorKit = this.propertiesPane.getEditorKit();
        String string = editorKit.getClass().getName();
        if (string.equals("javax.swing.text.DefaultEditorKit") || string.equals("javax.swing.JEditorPane$PlainEditorKit")) {
            this.propertiesPane.setEditorKit(JEditorPane.createEditorKitForContentType("text/plain"));
        }
        this.targetComboBox.getInputMap().remove(KeyStroke.getKeyStroke("ENTER"));
        this.initializeFields();
    }

    private void initializeFields() {
        Serializable serializable;
        Object object;
        FileObject fileObject;
        block9: {
            fileObject = this.project.getFileObject();
            if (!$assertionsDisabled && fileObject == null) {
                throw new AssertionError((Object)("No file found for " + this.project));
            }
            String string = (String)fileObject.getAttribute(ATTR_TARGETS);
            TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
            Iterator iterator = this.allTargets.iterator();
            while (iterator.hasNext()) {
                object = (TargetLister.Target)iterator.next();
                if (object.isOverridden() || object.isInternal()) continue;
                treeSet.add(object.getName());
                if (this.defaultTarget != null || !object.isDefault()) continue;
                this.defaultTarget = object.getName();
            }
            this.targetComboBox.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
            if (string != null) {
                this.targetComboBox.setSelectedItem(string);
            } else {
                this.targetComboBox.setSelectedItem(this.defaultTarget);
            }
            this.targetComboBoxActionPerformed(null);
            object = (String)fileObject.getAttribute(ATTR_PROPERTIES);
            if (object == null) {
                serializable = AntSettings.getDefault().getProperties();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    ((Properties)serializable).store(byteArrayOutputStream, null);
                    String string2 = byteArrayOutputStream.toString("ISO-8859-1");
                    object = string2.replaceFirst("^#.*\n", "");
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)iOException);
                }
            }
        }
        this.propertiesPane.setText((String)object);
        serializable = (Integer)fileObject.getAttribute(ATTR_VERBOSITY);
        if (serializable == null) {
            serializable = new Integer(AntSettings.getDefault().getVerbosity());
        }
        this.verbosityComboBox.setModel(new DefaultComboBoxModel<String>(VERBOSITIES));
        for (int i = 0; i < VERBOSITY_LEVELS.length; ++i) {
            if (VERBOSITY_LEVELS[i] != (Integer)serializable) continue;
            this.verbosityComboBox.setSelectedItem(VERBOSITIES[i]);
            break;
        }
    }

    private void initComponents() {
        this.targetLabel = new JLabel();
        this.targetComboBox = new JComboBox();
        this.targetDescriptionLabel = new JLabel();
        this.targetDescriptionField = new JTextField();
        this.propertiesLabel = new JLabel();
        this.propertiesScrollPane = new JScrollPane();
        this.propertiesPane = new JEditorPane();
        this.verbosityLabel = new JLabel();
        this.verbosityComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.targetLabel.setText("Select target(s) to run:");
        this.targetLabel.setLabelFor(this.targetComboBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.targetLabel, gridBagConstraints);
        this.targetComboBox.setEditable(true);
        this.targetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"sampleTarget1", "sampleTarget2", "sampleTarget3"}));
        this.targetComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedActionPanel.this.targetComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.targetComboBox, gridBagConstraints);
        this.targetDescriptionLabel.setText("Target description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.targetDescriptionLabel, gridBagConstraints);
        this.targetDescriptionField.setEditable(false);
        this.targetDescriptionField.setText("Sample description here.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.targetDescriptionField, gridBagConstraints);
        this.propertiesLabel.setText("Special Ant properties:");
        this.propertiesLabel.setLabelFor(this.propertiesPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 12;
        this.add((Component)this.propertiesLabel, gridBagConstraints);
        this.propertiesScrollPane.setPreferredSize(new Dimension(400, 150));
        this.propertiesScrollPane.setMinimumSize(new Dimension(400, 150));
        this.propertiesPane.setText("# This is sample text for GUI design.\nsomeprop1=someval1\nsomeprop2=someval2\nsomeprop3=someval3\n");
        this.propertiesPane.setContentType("text/x-properties");
        this.propertiesScrollPane.setViewportView(this.propertiesPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.propertiesScrollPane, gridBagConstraints);
        this.verbosityLabel.setText("Verbosity level:");
        this.verbosityLabel.setLabelFor(this.verbosityComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.verbosityLabel, gridBagConstraints);
        this.verbosityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Errors only [SAMPLE]", "Normal [SAMPLE]", "Verbose [SAMPLE]"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.verbosityComboBox, gridBagConstraints);
    }

    private void targetComboBoxActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.targetComboBox.getSelectedItem();
        if (string == null) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        ArrayList<Object> arrayList = Collections.list(stringTokenizer);
        String string2 = "";
        if (arrayList.size() == 1) {
            String string3 = (String)arrayList.get(0);
            Iterator iterator = this.allTargets.iterator();
            while (iterator.hasNext()) {
                TargetLister.Target target = (TargetLister.Target)iterator.next();
                if (target.isOverridden() || !target.getName().equals(string3)) continue;
                string2 = target.getElement().getAttribute("description");
                break;
            }
        }
        this.targetDescriptionField.setText(string2);
    }

    public void run() throws IOException {
        StringBuffer stringBuffer;
        StringTokenizer stringTokenizer = new StringTokenizer((String)this.targetComboBox.getSelectedItem(), " ,");
        ArrayList<Object> arrayList = Collections.list(stringTokenizer);
        String[] stringArray = arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
        Properties properties = new Properties();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.propertiesPane.getText().getBytes("ISO-8859-1"));
        properties.load(byteArrayInputStream);
        int n = 2;
        String string = (String)this.verbosityComboBox.getSelectedItem();
        for (int i = 0; i < VERBOSITIES.length; ++i) {
            if (!VERBOSITIES[i].equals(string)) continue;
            n = VERBOSITY_LEVELS[i];
            break;
        }
        FileObject fileObject = this.project.getFileObject();
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError();
        }
        if (stringArray.length == 1 && stringArray[0].equals(this.defaultTarget) || stringArray.length == 0) {
            fileObject.setAttribute(ATTR_TARGETS, null);
        } else {
            stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(stringArray[i]);
            }
            fileObject.setAttribute(ATTR_TARGETS, (Object)stringBuffer.toString());
        }
        if (properties.equals(AntSettings.getDefault().getProperties())) {
            fileObject.setAttribute(ATTR_PROPERTIES, null);
        } else {
            fileObject.setAttribute(ATTR_PROPERTIES, (Object)this.propertiesPane.getText());
        }
        if (n == AntSettings.getDefault().getVerbosity()) {
            fileObject.setAttribute(ATTR_VERBOSITY, null);
        } else {
            fileObject.setAttribute(ATTR_VERBOSITY, (Object)new Integer(n));
        }
        DebuggerAntLogger.getDefault().debugFile(this.project.getFile());
        stringBuffer = new AntTargetExecutor.Env();
        stringBuffer.setProperties(properties);
        stringBuffer.setVerbosity(n);
        AntTargetExecutor antTargetExecutor = AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)stringBuffer);
        antTargetExecutor.execute(this.project, stringArray);
    }

    static {
        $assertionsDisabled = !AdvancedActionPanel.class.desiredAssertionStatus();
        VERBOSITIES = new String[]{NbBundle.getMessage((Class)AdvancedActionPanel.class, (String)"LBL_verbosity_warn"), NbBundle.getMessage((Class)AdvancedActionPanel.class, (String)"LBL_verbosity_info"), NbBundle.getMessage((Class)AdvancedActionPanel.class, (String)"LBL_verbosity_verbose"), NbBundle.getMessage((Class)AdvancedActionPanel.class, (String)"LBL_verbosity_debug")};
        VERBOSITY_LEVELS = new int[]{1, 2, 3, 4};
    }
}

